/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.brtm.utilities.common;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.brtm.utilities.common.URLMatch;
import com.wily.introscope.agent.brtm.utilities.common.URLPattern;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public class ExcludeLists {
    private static volatile ExcludeLists instance = null;
    private URLPattern[] urlExcludeList;
    private URLPattern[] urlIncludeList;
    private URLPattern[] urlDoNotReportList;
    private URLPattern[] urlReportList;
    private URLPattern[] redirectOkList;

    public static ExcludeLists getInstance() {
        if (instance == null) {
            instance = new ExcludeLists();
        }
        return instance;
    }

    private ExcludeLists() {
    }

    private URLPattern[] setUrlList(String[] urlList) throws UnsupportedEncodingException {
        if (urlList == null) {
            return null;
        }
        URLPattern[] result = new URLPattern[urlList.length];
        int i = 0;
        while (i < urlList.length) {
            result[i] = new URLPattern(urlList[i]);
            ++i;
        }
        return result;
    }

    private String hasWhiteSpaces(String url) {
        url = url.replaceAll("%20", "");
        return url;
    }

    private boolean hasFragmentIdentifier(String url) {
        String params;
        int qindex = url.indexOf(63);
        String string = params = qindex > 0 ? url.substring(qindex + 1) : "";
        if (params != null) {
            int findex = params.indexOf(35);
            int eindex = params.indexOf("%23");
            if (findex > 0 || eindex > 0) {
                return true;
            }
        }
        return false;
    }

    public void setUrlExcludeList(String[] urlList) throws UnsupportedEncodingException {
        this.urlExcludeList = this.setUrlList(urlList);
        if (urlList != null && urlList.length > 0) {
            int i = 0;
            while (i < urlList.length) {
                if (this.hasFragmentIdentifier(urlList[i])) {
                    AgentShim.getAgentShim().IAgentShim_getModuleFeedback().warn("BRTM Excludelist entry: " + urlList[i] + " contains a URI fragment identifier '#' which is not handled as part of an excluded url. Please specify a URL without the '#'. ");
                }
                ++i;
            }
        }
    }

    public void setRedirectOkList(String[] redirectOkList) throws UnsupportedEncodingException {
        this.redirectOkList = this.setUrlList(redirectOkList);
    }

    public void setDoNotReportList(String[] doNotReportList) throws UnsupportedEncodingException {
        this.urlDoNotReportList = this.setUrlList(doNotReportList);
    }

    public void setReportList(String[] reportList) throws UnsupportedEncodingException {
        this.urlReportList = this.setUrlList(reportList);
    }

    public void setUrlIncludeList(String[] includeList) throws UnsupportedEncodingException {
        this.urlIncludeList = this.setUrlList(includeList);
        if (includeList != null && includeList.length > 0) {
            int i = 0;
            while (i < includeList.length) {
                if (this.hasFragmentIdentifier(includeList[i])) {
                    AgentShim.getAgentShim().IAgentShim_getModuleFeedback().warn("BRTM Includelist entry: " + includeList[i] + " contains a URI fragment identifier '#' which is not handled as part of an included url. Please specify a URL without the '#'. ");
                }
                ++i;
            }
        }
    }

    public boolean inURLExcludeList(String path, Map pathMap) throws UnsupportedEncodingException {
        return this.inPatternList(this.urlExcludeList, path, pathMap, false);
    }

    public boolean inExcludeLists(String path, Map pathMap) throws UnsupportedEncodingException {
        return !this.inURLIncludeList(path, pathMap) || this.inURLExcludeList(path, pathMap);
    }

    private boolean inPatternList(URLPattern[] aPatterns, String path, Map pathMap, boolean nullMeaning) throws UnsupportedEncodingException {
        if (aPatterns == null || aPatterns.length == 0) {
            return nullMeaning;
        }
        int i = 0;
        while (i < aPatterns.length) {
            if (URLMatch.isMatch(path, pathMap, aPatterns[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean inURLDoNotReportList(String path, Map pathMap) throws UnsupportedEncodingException {
        return this.inPatternList(this.urlDoNotReportList, path, pathMap, false);
    }

    public boolean inRedirectOkList(String path, Map pathMap) throws UnsupportedEncodingException {
        return this.inPatternList(this.redirectOkList, path, pathMap, false);
    }

    public boolean inURLReportList(String path, Map pathMap) throws UnsupportedEncodingException {
        return this.inPatternList(this.urlReportList, path, pathMap, true);
    }

    public boolean inURLIncludeList(String path, Map pathMap) throws UnsupportedEncodingException {
        return this.inPatternList(this.urlIncludeList, path, pathMap, true);
    }

    public void setAllLists(String[] urlExcludeList, String[] agentExcludeList, String[] redirectOkList, String[] doNotReportList, String[] reportList, String[] includeList) throws UnsupportedEncodingException {
        this.setUrlExcludeList(urlExcludeList);
        this.setUrlIncludeList(includeList);
        this.setRedirectOkList(redirectOkList);
        this.setDoNotReportList(doNotReportList);
        this.setReportList(reportList);
    }
}

