/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.brtm.utilities.common;

import com.wily.introscope.agent.brtm.utilities.common.URLComponents;
import com.wily.introscope.agent.brtm.utilities.common.URLMatch;
import com.wily.introscope.agent.brtm.utilities.common.URLPattern;
import com.wily.introscope.agent.brtm.utilities.common.Util;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class URLGroupRule {
    private URLPattern m_pattern;
    private ArrayList m_formatUnits;

    public URLGroupRule(String patternString, String formatExpression) throws UnsupportedEncodingException {
        this.m_pattern = new URLPattern(patternString);
        this.m_formatUnits = this.parseFormatExpression(formatExpression);
    }

    private ArrayList parseFormatExpression(String formatExpression) {
        ArrayList<FormatUnit> result = new ArrayList<FormatUnit>();
        int len = formatExpression.length();
        int i = 0;
        int last = 0;
        while (i < len) {
            i = formatExpression.indexOf(123, last);
            if (i < 0) {
                if (last + 1 >= len) break;
                result.add(new FormatUnit(formatExpression.substring(last, len)));
                break;
            }
            if (i > last) {
                result.add(new FormatUnit(formatExpression.substring(last, i)));
            }
            if ((i = formatExpression.indexOf(125, last = i)) < 0) {
                if (last + 1 >= len) break;
                result.add(new FormatUnit(formatExpression.substring(last, len)));
                break;
            }
            if (i > last) {
                result.add(new FormatUnit(formatExpression.substring(last, i + 1)));
            }
            last = i + 1;
        }
        return result;
    }

    public boolean isMatch(URLComponents urlComponents) {
        if (urlComponents.m_partPath == null || this.m_pattern == null) {
            return false;
        }
        return URLMatch.isMatch(urlComponents.m_partPath, urlComponents.m_params, this.m_pattern);
    }

    public String format(URLComponents urlComponents) {
        StringBuffer result = new StringBuffer();
        ListIterator iter = this.m_formatUnits.listIterator();
        while (iter.hasNext()) {
            result.append(((FormatUnit)iter.next()).format(urlComponents));
        }
        return result.toString();
    }

    public String toString() {
        StringBuffer result = new StringBuffer("URLGroupRule(m_pattern: ");
        result.append(this.m_pattern);
        result.append(" m_formatUnits: ");
        ListIterator iter = this.m_formatUnits.listIterator();
        while (iter.hasNext()) {
            result.append(((FormatUnit)iter.next()).toString());
        }
        result.append(")");
        return result.toString();
    }

    private static class FormatUnit {
        static final int UNKNOWN = 0;
        static final int STRING_LITERAL = 1;
        static final int PROTOCOL = 2;
        static final int HOST = 3;
        static final int PATH_SUBSTRING = 4;
        static final int QUERY_PARAM = 5;
        static final int PORT = 6;
        static final int PATH_DELIMITED = 7;
        static final String[] typeNames = new String[]{"", "", "protocol", "host", "path_substring", "query_param", "port", "path_delimited"};
        private int m_type = 0;
        private String m_arg = null;
        private int m_start;
        private int m_end;

        FormatUnit(String singleExpression) {
            if (singleExpression == null) {
                return;
            }
            int openCurly = singleExpression.indexOf(123);
            int colon = singleExpression.indexOf(58, openCurly < 0 ? 0 : openCurly);
            int closeCurly = singleExpression.indexOf(125, openCurly < 0 ? 0 : openCurly);
            if (openCurly < 0 || closeCurly < openCurly) {
                this.m_type = 1;
                this.m_arg = singleExpression;
                return;
            }
            String expr = singleExpression.substring(openCurly + 1, colon < 0 ? closeCurly : colon);
            int i = 2;
            while (i < typeNames.length) {
                if (typeNames[i].equals(expr)) {
                    this.m_type = i;
                    if (colon <= openCurly || colon >= closeCurly) break;
                    this.m_arg = singleExpression.substring(colon + 1, closeCurly);
                    break;
                }
                ++i;
            }
            switch (this.m_type) {
                case 0: {
                    this.m_arg = expr;
                    break;
                }
                case 4: {
                    this.m_start = 0;
                    this.m_end = 0;
                    if (this.m_arg == null || this.m_arg.length() <= 0) break;
                    StringTokenizer tokenizer = new StringTokenizer(this.m_arg, ":");
                    if (tokenizer.countTokens() < 0 || tokenizer.countTokens() > 2) {
                        throw new IllegalArgumentException("This formatter takes 0 to 2 args");
                    }
                    if (tokenizer.hasMoreTokens()) {
                        this.m_start = Integer.parseInt(tokenizer.nextToken());
                    }
                    if (!tokenizer.hasMoreTokens()) break;
                    this.m_end = Integer.parseInt(tokenizer.nextToken());
                    break;
                }
                case 7: {
                    StringTokenizer tokenizer;
                    if (this.m_arg == null || this.m_arg.length() == 0) {
                        this.m_arg = "/";
                    }
                    if ((tokenizer = new StringTokenizer(this.m_arg, ":")).countTokens() < 0 || tokenizer.countTokens() > 3) {
                        throw new IllegalArgumentException("This formatter takes 0 to 3 args");
                    }
                    String delims = "/";
                    this.m_start = 1;
                    this.m_end = 1;
                    if (tokenizer.hasMoreTokens()) {
                        delims = tokenizer.nextToken();
                    }
                    if (tokenizer.hasMoreTokens()) {
                        this.m_start = Integer.parseInt(tokenizer.nextToken());
                    }
                    if (tokenizer.hasMoreTokens()) {
                        this.m_end = Integer.parseInt(tokenizer.nextToken());
                    }
                    this.m_arg = delims;
                }
            }
        }

        private String format(URLComponents urlComponents) {
            switch (this.m_type) {
                case 1: {
                    return this.m_arg;
                }
                case 2: {
                    return urlComponents.m_protocol;
                }
                case 3: {
                    return urlComponents.m_host;
                }
                case 4: {
                    String path = urlComponents.m_partPath;
                    int pathLen = path.length();
                    int start = this.m_start > pathLen ? pathLen : this.m_start;
                    int end = this.m_end <= 0 ? pathLen + this.m_end : this.m_end;
                    int n = end = pathLen < this.m_end ? pathLen : end;
                    if (start > end) {
                        return "";
                    }
                    return path.substring(start, end);
                }
                case 7: {
                    StringTokenizer tokenizer = new StringTokenizer(urlComponents.m_partPath, this.m_arg, true);
                    StringBuffer result = new StringBuffer();
                    if (this.m_start < 0) {
                        throw new IllegalArgumentException("start has to be non-negative");
                    }
                    if (this.m_end < 0) {
                        throw new IllegalArgumentException("end has to be non-negative");
                    }
                    if (this.m_start >= this.m_end) {
                        return "";
                    }
                    try {
                        int i = 0;
                        while (i < this.m_end) {
                            if (i >= this.m_start) {
                                result.append(tokenizer.nextToken());
                            } else {
                                tokenizer.nextToken();
                            }
                            ++i;
                        }
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                    if (result.length() == 0) {
                        return "<null>";
                    }
                    return result.toString();
                }
                case 5: {
                    String[] values = (String[])urlComponents.m_params.get(this.m_arg);
                    if (values == null) {
                        return "<empty>";
                    }
                    StringBuffer result = new StringBuffer();
                    int i = 0;
                    while (i < values.length) {
                        if (i > 0) {
                            result.append(' ');
                        }
                        result.append(values[i]);
                        ++i;
                    }
                    return Util.sanitizeMetricName(result.toString());
                }
                case 6: {
                    return urlComponents.m_port.toString();
                }
            }
            return "{" + (this.m_arg == null ? "<empty>" : this.m_arg) + "}";
        }

        public String toString() {
            switch (this.m_type) {
                case 1: {
                    return "(string literal: " + this.m_arg + ")";
                }
                case 2: {
                    return "(protocol)";
                }
                case 3: {
                    return "(host)";
                }
                case 4: {
                    return "(path substring: " + this.m_start + " " + this.m_end + ")";
                }
                case 7: {
                    return "(path delimited: " + this.m_arg + " " + this.m_start + " " + this.m_end + ")";
                }
                case 5: {
                    return "(query param: " + this.m_arg + ")";
                }
                case 6: {
                    return "(port)";
                }
            }
            return "{unknown: " + (this.m_arg == null ? "<empty>" : this.m_arg) + "}";
        }
    }
}

