/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.brtm.wrapper;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.brtm.wrapper.BRTHttpServletResponseWrapper;
import com.wily.introscope.agent.trace.BTThreadLocalAdministrator;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.util.feedback.DelegatingFeedbackChannel;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BrtmWrapperFactory {
    private static BrtmWrapperFactory singleton = new BrtmWrapperFactory();
    private static final Module BRTM_MODULE = new Module("BRTM");
    static final String JAVASCRIPT_CONTENTTYPE = "text/javascript";
    public static String g_snippetJavaScriptContent;
    public static String[] g_excludePatternList;
    private static IAgent agent;
    private static IModuleFeedbackChannel feedback;

    private BrtmWrapperFactory() {
    }

    public static BrtmWrapperFactory getInstance(IAgent arg0) {
        agent = arg0;
        feedback = new DelegatingFeedbackChannel(arg0.IAgent_getModuleFeedback(), BRTM_MODULE);
        return singleton;
    }

    public static Object updateJSResponse(Object response, String js) {
        BrtmWrapperFactory.returnJavaScriptInclude((HttpServletResponse)response, js);
        return response;
    }

    private static void returnJavaScriptInclude(HttpServletResponse response, String js) {
        response.setContentType(JAVASCRIPT_CONTENTTYPE);
        response.setContentLength(js.length());
        Date d = new Date();
        long dl = d.getTime() + 2592000000L;
        response.addDateHeader("Expires", dl);
        try {
            PrintWriter output = response.getWriter();
            output.write(js);
        }
        catch (IOException e) {
            feedback.error(BRTM_MODULE, "IOException: ", e);
        }
    }

    public static String getJSSnippet() {
        return g_snippetJavaScriptContent;
    }

    public static void setJSExcludePatternList(String[] excludePatternList) {
        g_excludePatternList = excludePatternList;
    }

    public static String[] getJSExcludePatternList() {
        return g_excludePatternList;
    }

    public void callSameMethodWithWrapperResponse(Object invocationDataObject, String methodName, String className, String methodDesc, Map argMap, String url) {
        try {
            Cookie[] requestCookies;
            Object[] argArray = (Object[])argMap.get("argPassArray");
            Map methodItem = (Map)argMap.get("methodItem");
            g_snippetJavaScriptContent = (String)argMap.get("snippetJS");
            InvocationData data = (InvocationData)argMap.get("invocationData");
            long maxResponseContentLengthForSearching = (Long)argMap.get("maxResponseContentLengthForSearching");
            Boolean responseWrapperCreated = Boolean.FALSE;
            if (argArray[1] instanceof BRTHttpServletResponseWrapper) {
                return;
            }
            if (argArray[1] instanceof HttpServletResponse) {
                argArray[1] = new BRTHttpServletResponseWrapper((HttpServletResponse)argArray[1], url, maxResponseContentLengthForSearching);
                responseWrapperCreated = Boolean.TRUE;
                if (feedback.isTraceEnabled()) {
                    feedback.trace(BRTM_MODULE, "...3 wrapperfactory...create new wrapper response... url =" + url);
                }
            } else if (feedback.isTraceEnabled()) {
                feedback.trace(BRTM_MODULE, "Get non HttpServletResponse: " + argArray[1].getClass().getName());
            }
            if (argArray[0] instanceof HttpServletRequest && (requestCookies = ((HttpServletRequest)argArray[0]).getCookies()) != null) {
                Cookie[] cookieArray = requestCookies;
                int n = requestCookies.length;
                int n2 = 0;
                while (n2 < n) {
                    Cookie c = cookieArray[n2];
                    if (c.getName().equals("x-apm-brtm-response-bt-id") && c.getValue() != null) {
                        try {
                            BTThreadLocalAdministrator.getInstance().insert("x-apm-brtm-response-bt-id", (Object)URLDecoder.decode(c.getValue(), "UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            feedback.error(BRTM_MODULE, "UnsupportedEncodingException: ", e);
                        }
                        if (responseWrapperCreated.booleanValue()) {
                            ((HttpServletResponse)argArray[1]).addHeader("x-apm-brtm-snippet", "1");
                        }
                    }
                    ++n2;
                }
            }
            Class[] cfr_ignored_0 = new Class[argArray.length];
            Class<?> oClass = invocationDataObject.getClass();
            Method m = null;
            if (methodItem != null) {
                m = (Method)methodItem.get("method");
                Class[] cfr_ignored_1 = (Class[])methodItem.get("argClassArray");
            }
            try {
                if (oClass != null && m != null) {
                    m.setAccessible(true);
                    if (feedback.isTraceEnabled()) {
                        feedback.trace(BRTM_MODULE, "...4 wrapperfactory... start reflection call to ... class=" + oClass.getName() + "...method=" + m.getName());
                    }
                    m.invoke(invocationDataObject, argArray);
                } else if (feedback.isTraceEnabled()) {
                    feedback.trace(BRTM_MODULE, "...No method is found, skip reflection call");
                }
            }
            catch (SecurityException e) {
                feedback.error(BRTM_MODULE, "SecurityException: ", e);
                this.restoreAppRequest(data);
            }
            catch (IllegalArgumentException e) {
                feedback.error(BRTM_MODULE, "IllegalArgumentException: ", e);
                this.restoreAppRequest(data);
            }
            catch (IllegalAccessException e) {
                feedback.error(BRTM_MODULE, "IllegalAccessException: ", e);
                this.restoreAppRequest(data);
            }
            catch (InvocationTargetException e) {
                data.IParameterizedMethodTracer_setThrownException((Object)e.getTargetException());
                this.restoreAppRequest(data);
            }
            if (feedback.isTraceEnabled()) {
                feedback.trace(BRTM_MODULE, "...5 wrapperfactory... finish reflection call to ... class=" + oClass.getName() + "...method=" + m.getName());
            }
        }
        catch (Exception e) {
            feedback.error(BRTM_MODULE, "...wrapperfactory... exception =" + e.toString());
            InvocationData data = (InvocationData)argMap.get("invocationData");
            this.restoreAppRequest(data);
        }
    }

    private void restoreAppRequest(InvocationData data) {
        data.IMethodTracer_setShouldStub(false);
        data.IMethodTracer_setReentrancyOverwrite(false);
    }
}

