/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.MonitoredClasses;

import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.MonitoredClasses.PlaceHolder;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.logger.MQPPLog;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.CAMQUtils;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.CAQueueManagerUtils;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.CAQueueUtils;
import java.lang.reflect.Field;

public class CAMQConnectionConsumer
extends PlaceHolder {
    private static Field fMQConnectionConsumer_conn = null;
    private static Field fMQConnectionConsumer_dest = null;
    private static Field fJMS_MQQueue_baseQueueName = null;
    private static Field fJMS_MQTopic_baseTopicName = null;

    public String getHostName(InvocationData invocationdata) {
        Object mqObject = invocationdata.getInvocationObject();
        Class<?> connConsumerClass = mqObject.getClass();
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQConnectionConsumer:getHostName:connConsumerClass: " + connConsumerClass.getName());
        try {
            if (fMQConnectionConsumer_conn == null) {
                fMQConnectionConsumer_conn = connConsumerClass.getDeclaredField("conn");
                fMQConnectionConsumer_conn.setAccessible(true);
            }
            Object mqConnectionObject = fMQConnectionConsumer_conn.get(mqObject);
            this.hostname = CAMQUtils.getMQConnectionHostName(mqConnectionObject);
        }
        catch (Exception e) {
            MQPPLog.getLogger().warn(MQPPLog.getModule(), "CAMQConnectionConsumer:getHostName:Exception: " + e.getMessage());
            MQPPLog.getLogger().debug((Throwable)e);
        }
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQConnectionConsumer:getHostName:Host Name: " + this.hostname);
        return this.hostname;
    }

    public String getQueueManagerName(InvocationData invocationdata) {
        Object mqObject = invocationdata.getInvocationObject();
        Class<?> connConsumerClass = mqObject.getClass();
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQConnectionConsumer:getQueueManagerName:connConsumerClass: " + connConsumerClass.getName());
        try {
            if (fMQConnectionConsumer_conn == null) {
                fMQConnectionConsumer_conn = connConsumerClass.getDeclaredField("conn");
                fMQConnectionConsumer_conn.setAccessible(true);
            }
            Object mqConnectionObject = fMQConnectionConsumer_conn.get(mqObject);
            this.qmname = CAMQUtils.getMQConnectionQueueManagerName(mqConnectionObject);
            if (this.qmname == null || this.qmname.trim().length() == 0) {
                Object mqQueueManagerObject = CAMQUtils.getMQConnectionQueueManager(mqConnectionObject);
                this.qmname = CAQueueManagerUtils.getQMName(mqQueueManagerObject);
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().warn(MQPPLog.getModule(), "CAMQConnectionConsumer:getQueueManagerName:Exception: " + e.getMessage());
            MQPPLog.getLogger().debug((Throwable)e);
        }
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQConnectionConsumer:getQueueManagerName:Queue Manager Name: " + this.qmname);
        return this.qmname;
    }

    public String getQueueName(InvocationData invocationdata) {
        boolean isQueue = true;
        Object mqObject = invocationdata.getInvocationObject();
        Class<?> connConsumerClass = mqObject.getClass();
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQConnectionConsumer:getQueueName:connConsumerClass: " + connConsumerClass.getName());
        try {
            Object destObject;
            Class<?> destClass;
            String destClassName;
            if (fMQConnectionConsumer_dest == null) {
                fMQConnectionConsumer_dest = connConsumerClass.getDeclaredField("dest");
                fMQConnectionConsumer_dest.setAccessible(true);
            }
            if ((destClassName = (destClass = (destObject = fMQConnectionConsumer_dest.get(mqObject)).getClass()).getName()).equals("com.ibm.mq.jms.MQQueue")) {
                isQueue = true;
                if (fJMS_MQQueue_baseQueueName == null) {
                    fJMS_MQQueue_baseQueueName = destClass.getDeclaredField("baseQueueName");
                    fJMS_MQQueue_baseQueueName.setAccessible(true);
                }
                this.queuename = ((String)fJMS_MQQueue_baseQueueName.get(destObject)).trim();
            } else if (destClassName.equals("com.ibm.mq.jms.MQTopic")) {
                isQueue = false;
                if (fJMS_MQTopic_baseTopicName == null) {
                    fJMS_MQTopic_baseTopicName = destClass.getDeclaredField("baseTopicName");
                    fJMS_MQTopic_baseTopicName.setAccessible(true);
                }
                this.queuename = ((String)fJMS_MQTopic_baseTopicName.get(destObject)).trim();
            }
            if (fMQConnectionConsumer_conn == null) {
                fMQConnectionConsumer_conn = connConsumerClass.getDeclaredField("conn");
                fMQConnectionConsumer_conn.setAccessible(true);
            }
            Object mqConnectionObject = fMQConnectionConsumer_conn.get(mqObject);
            Object mqQueueManagerObject = CAMQUtils.getMQConnectionQueueManager(mqConnectionObject);
            this.queuename = isQueue && CAQueueUtils.isDynamicQueue(mqQueueManagerObject, this.queuename) ? "Queues|Dynamic Queues" : (isQueue ? "Queues|" + this.queuename : "Topics|" + this.queuename);
        }
        catch (Exception e) {
            MQPPLog.getLogger().warn(MQPPLog.getModule(), "CAMQConnectionConsumer:getQueueName:Exception: " + e.getMessage());
            MQPPLog.getLogger().debug((Throwable)e);
        }
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQConnectionConsumer:getQueueName:Queue Name: " + this.queuename);
        return this.queuename;
    }
}

