/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.MonitoredClasses.v7;

import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.MonitoredClasses.PlaceHolder;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.logger.MQPPLog;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.CAMQUtils;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.CAQueueUtils;
import java.lang.reflect.Field;
import java.util.Hashtable;

public class CAMQ7ConnectionConsumer
extends PlaceHolder {
    private static Field fMQConnectionConsumer_delegateConConsumer = null;
    private static Field fJmsConnectionConsumerImpl_destination = null;

    public String getHostName(InvocationData invocationdata) {
        Object mqObject = invocationdata.getInvocationObject();
        Class<?> mqConnectionConsumerClass = mqObject.getClass();
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQ7ConnectionConsumer:getHostName:mqConnectionConsumerClass: " + mqConnectionConsumerClass.getName());
        try {
            this.hostname = CAMQUtils.getJMSObjectProperty(mqObject, "XMSC_WMQ_HOST_NAME");
            if ((this.hostname == null || this.hostname.equals("")) && CAMQUtils.getJMSObjectProperty(mqObject, "XMSC_WMQ_CONNECTION_MODE").equals("0")) {
                this.hostname = "localhost";
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().warn(MQPPLog.getModule(), "CAMQ7ConnectionConsumer:getHostName:Exception: " + e.getMessage());
            MQPPLog.getLogger().debug((Throwable)e);
        }
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQ7QueueSession:getHostName:Host Name: " + this.hostname);
        return this.hostname;
    }

    public String getQueueManagerName(InvocationData invocationdata) {
        Object mqObject = invocationdata.getInvocationObject();
        Class<?> mqConnectionConsumerClass = mqObject.getClass();
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQ7ConnectionConsumer:getQueueManagerName:mqConnectionConsumerClass: " + mqConnectionConsumerClass.getName());
        try {
            this.qmname = CAMQUtils.getJMSObjectProperty(mqObject, "XMSC_WMQ_QUEUE_MANAGER");
        }
        catch (Exception e) {
            MQPPLog.getLogger().warn(MQPPLog.getModule(), "CAMQ7ConnectionConsumer:getQueueManagerName:Exception: " + e.getMessage());
            MQPPLog.getLogger().debug((Throwable)e);
        }
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQ7ConnectionConsumer:getQueueManagerName:Queue Manager Name: " + this.qmname);
        return this.qmname;
    }

    public String getQueueName(InvocationData invocationdata) {
        boolean isQueue = true;
        boolean isTempQueue = false;
        Object mqObject = invocationdata.getInvocationObject();
        Class<?> mqConnectionConsumerClass = mqObject.getClass();
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQ7ConnectionConsumer:getQueueName:mqConnectionConsumerClass: " + mqConnectionConsumerClass.getName());
        try {
            if (fMQConnectionConsumer_delegateConConsumer == null) {
                fMQConnectionConsumer_delegateConConsumer = mqConnectionConsumerClass.getDeclaredField("delegateConConsumer");
                fMQConnectionConsumer_delegateConConsumer.setAccessible(true);
            }
            Object jmsConnectionConsumerObject = fMQConnectionConsumer_delegateConConsumer.get(mqObject);
            Class<?> jmsConnectionConsumerClass = jmsConnectionConsumerObject.getClass();
            Object jmsDestinationObject = null;
            if (jmsConnectionConsumerClass.getName().equals("com.ibm.msg.client.jms.internal.JmsConnectionConsumerImpl")) {
                if (fJmsConnectionConsumerImpl_destination == null) {
                    fJmsConnectionConsumerImpl_destination = jmsConnectionConsumerClass.getDeclaredField("destination");
                    fJmsConnectionConsumerImpl_destination.setAccessible(true);
                }
                jmsDestinationObject = fJmsConnectionConsumerImpl_destination.get(jmsConnectionConsumerObject);
            }
            if (jmsDestinationObject != null) {
                Class<?> jmsDestinationClass = jmsDestinationObject.getClass();
                String jmsDestinationClassName = jmsDestinationClass.getName();
                if (jmsDestinationClassName.equals("com.ibm.msg.client.jms.admin.JmsDestinationImpl") || jmsDestinationClassName.equals("com.ibm.mq.jms.MQDestination")) {
                    this.queuename = CAQueueUtils.getDestinationQueueName(jmsDestinationObject);
                    if (this.queuename.trim().length() != 0) {
                        isQueue = true;
                    } else {
                        isQueue = false;
                        this.queuename = CAQueueUtils.getDestinationTopicName(jmsDestinationObject);
                    }
                } else if (jmsDestinationClassName.equals("com.ibm.mq.jms.MQQueue")) {
                    isQueue = true;
                    this.queuename = CAQueueUtils.getJMSBaseQueueName(jmsDestinationObject);
                } else if (jmsDestinationClassName.equals("com.ibm.mq.jms.MQTopic")) {
                    isQueue = false;
                    this.queuename = CAQueueUtils.getJMSBaseTopicName(jmsDestinationObject);
                } else if (jmsDestinationClassName.equals("com.ibm.mq.jms.MQTemporaryQueue") || jmsDestinationClassName.equals("com.ibm.msg.client.jms.internal.JmsTemporaryQueueImpl")) {
                    isTempQueue = true;
                    isQueue = true;
                } else if (jmsDestinationClassName.equals("com.ibm.mq.jms.MQTemporaryTopic") || jmsDestinationClassName.equals("com.ibm.msg.client.jms.internal.JmsTemporaryTopicImpl")) {
                    isQueue = false;
                }
            }
            Hashtable props = null;
            if (isQueue) {
                props = CAMQUtils.getJMSObjectProperties(mqObject);
            }
            this.queuename = isQueue && isTempQueue ? "Queues|Dynamic Queues" : (isQueue && CAQueueUtils.isJMSDynamicQueue(jmsDestinationObject, this.queuename, props) ? "Queues|Dynamic Queues" : (isQueue ? "Queues|" + this.queuename : "Topics|" + this.queuename));
        }
        catch (Exception e) {
            MQPPLog.getLogger().warn(MQPPLog.getModule(), "CAMQ7ConnectionConsumer:getQueueName:Exception: " + e.getMessage());
            MQPPLog.getLogger().debug((Throwable)e);
        }
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQ7ConnectionConsumer:getQueueName:Queue Name: " + this.queuename);
        return this.queuename;
    }
}

