/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils;

import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.Kconstants;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.logger.MQPPLog;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.CAMQUtils;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.TraceProperties;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public final class CAQueueManagerUtils
implements Kconstants {
    private static final String CLASS_NAME = "CAQueueManagerUtils.";
    private static ClassLoader classLoader = null;
    private static Class cls_MQQueueManager = null;
    private static Constructor constructor_MQQueueManager = null;
    private static Constructor constructor_BindingMQQueueManager = null;
    private static Field fMQManagedConnectionJ11_properties = null;
    private static Field fMQManagedConnectionJ116_properties = null;
    private static Method mMQManagedObject_getAttributeString = null;
    private static Method mMQManagedObject6_getAttributeString = null;
    private static Method mMQQueueManager_isConnected = null;
    private static Method mMQQueueManager_disconnect = null;
    private static Map queueManagerNamesMap = Collections.synchronizedMap(new HashMap());
    private static Map tempQueueManagersMap = Collections.synchronizedMap(new HashMap());
    private static List tempQueueManagersList = Collections.synchronizedList(new ArrayList());
    private static String QM_UNAVAILABLE_INDICATOR = "CA_WILY_QM:";
    private static final long QM_UNAVAILABLE_CLEANUP_INTERVAL = 900000L;
    private static final long CLEANUP_INTERVAL = 86400000L;
    private static Map mQueueManagersMap = Collections.synchronizedMap(new HashMap(32));
    private static volatile int numberOfQMReferences = 0;
    private static long cleanUpTimeStamp = System.currentTimeMillis();

    public static String getQueueManagerDetailFromMQManConnJ11(Object mqManagedConnectionObject) throws Exception {
        if (!TraceProperties.MQNAMEFORMATTER_QM_CONNECTION) {
            MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAQueueManagerUtils.getQueueManagerDetailFromMQManConnJ11(mqManagedConnectionObject)  MQNameFormatter QM connection property is set to false. As a result, users will notice few unknown nodes in the investigator");
            return "";
        }
        String qmName = "";
        Hashtable props = new Hashtable();
        Class<?> mqManagedConnectionClass = mqManagedConnectionObject.getClass();
        Object mqQueueManagerObject = null;
        CAQueueManagerUtils.refreshCache();
        if (classLoader == null || constructor_MQQueueManager == null) {
            classLoader = mqManagedConnectionClass.getClassLoader();
            cls_MQQueueManager = Class.forName("com.ibm.mq.MQQueueManager", false, classLoader);
            constructor_MQQueueManager = cls_MQQueueManager.getConstructor(String.class, Hashtable.class);
        }
        if (mqManagedConnectionClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQManagedConnectionJ11")) {
            if (fMQManagedConnectionJ116_properties == null) {
                fMQManagedConnectionJ116_properties = mqManagedConnectionClass.getDeclaredField("properties");
                fMQManagedConnectionJ116_properties.setAccessible(true);
            }
            props = (Hashtable)fMQManagedConnectionJ116_properties.get(mqManagedConnectionObject);
        } else {
            if (fMQManagedConnectionJ11_properties == null || !fMQManagedConnectionJ11_properties.getDeclaringClass().isInstance(mqManagedConnectionObject)) {
                fMQManagedConnectionJ11_properties = mqManagedConnectionClass.getDeclaredField("properties");
                fMQManagedConnectionJ11_properties.setAccessible(true);
            }
            props = (Hashtable)fMQManagedConnectionJ11_properties.get(mqManagedConnectionObject);
        }
        String hostname = String.valueOf(props.get("hostname"));
        String port = String.valueOf(props.get("port"));
        if ((hostname == null || hostname.trim().length() == 0) && props.get("transport").equals("MQSeries Bindings")) {
            hostname = "localhost";
        }
        if (hostname != null && hostname.trim().length() != 0 && port != null && port.trim().length() != 0) {
            String hostPortKey = String.valueOf(hostname) + "|" + port;
            qmName = (String)queueManagerNamesMap.get(hostPortKey);
            MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAQueueManagerUtils.getQueueManagerDetailFromMQManConnJ11(mqManagedConnectionObject) Queue Manager Name from Cache: " + qmName + " for " + hostPortKey);
            if (qmName == null || qmName.trim().length() == 0 || qmName.startsWith(QM_UNAVAILABLE_INDICATOR)) {
                Object[] arg = new Object[]{new String(""), props};
                try {
                    if (qmName != null && qmName.startsWith(QM_UNAVAILABLE_INDICATOR)) {
                        long lastTimeStampCheck = Long.parseLong(qmName.substring(QM_UNAVAILABLE_INDICATOR.length()));
                        if (System.currentTimeMillis() - lastTimeStampCheck > 900000L) {
                            mqQueueManagerObject = constructor_MQQueueManager.newInstance(arg);
                        } else {
                            qmName = "";
                        }
                    } else {
                        mqQueueManagerObject = constructor_MQQueueManager.newInstance(arg);
                    }
                }
                catch (Exception e) {
                    MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAQueueManagerUtils.getQueueManagerDetailFromMQManConnJ11(mqManagedConnectionObject) Could not connect to queue manager at " + hostPortKey);
                    queueManagerNamesMap.put(hostPortKey, String.valueOf(QM_UNAVAILABLE_INDICATOR) + System.currentTimeMillis());
                    CAQueueManagerUtils.disconnectQueueManager(mqQueueManagerObject);
                    throw e;
                }
                if (mqQueueManagerObject != null) {
                    try {
                        qmName = CAQueueManagerUtils.getQMName(mqQueueManagerObject);
                        queueManagerNamesMap.put(hostPortKey, qmName);
                    }
                    finally {
                        CAQueueManagerUtils.disconnectQueueManager(mqQueueManagerObject);
                        mqQueueManagerObject = null;
                    }
                }
            }
        }
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAQueueManagerUtils.getQueueManagerDetailFromMQManConnJ11(mqManagedConnectionObject) Queue Manager Name: " + qmName);
        return qmName;
    }

    public static String getQMName(Object mqQueueManagerObject) {
        String qmName = "";
        try {
            if (mqQueueManagerObject != null) {
                qmName = (String)mQueueManagersMap.get(mqQueueManagerObject);
                if (qmName == null || qmName.length() == 0) {
                    Object[] arglist = new Object[]{new Integer(2015), new Integer(48)};
                    Class<?> mqQueueManagerSuperClass = mqQueueManagerObject.getClass().getSuperclass();
                    if (mqQueueManagerSuperClass.getName().equals("com.ibm.mq.MQQueueManager")) {
                        mqQueueManagerSuperClass = mqQueueManagerSuperClass.getSuperclass();
                    }
                    if (mqQueueManagerSuperClass.getName().equals("com.ibm.msg.client.wmq.v6.base.internal.MQManagedObject")) {
                        if (mMQManagedObject6_getAttributeString == null || !mMQManagedObject6_getAttributeString.getDeclaringClass().isInstance(mqQueueManagerObject)) {
                            mMQManagedObject6_getAttributeString = mqQueueManagerSuperClass.getMethod("getAttributeString", Integer.TYPE, Integer.TYPE);
                        }
                        qmName = ((String)mMQManagedObject6_getAttributeString.invoke(mqQueueManagerObject, arglist)).trim();
                    } else {
                        if (mMQManagedObject_getAttributeString == null || !mMQManagedObject_getAttributeString.getDeclaringClass().isInstance(mqQueueManagerObject)) {
                            mMQManagedObject_getAttributeString = mqQueueManagerSuperClass.getMethod("getAttributeString", Integer.TYPE, Integer.TYPE);
                        }
                        qmName = ((String)mMQManagedObject_getAttributeString.invoke(mqQueueManagerObject, arglist)).trim();
                    }
                    mQueueManagersMap.put(mqQueueManagerObject, qmName);
                    ++numberOfQMReferences;
                }
                if (numberOfQMReferences > 100) {
                    mQueueManagersMap.clear();
                }
            }
        }
        catch (Exception e) {
            MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAQueueManagerUtils.getQMName(mqQueueManagerObject) ", (Throwable)e);
        }
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAQueueManagerUtils.getQMName(mqQueueManagerObject) Queue Manager Name: " + qmName);
        return qmName;
    }

    public static Object getQueueManagerObject(Object mqjmsobject, Hashtable props) {
        if (!TraceProperties.MQNAMEFORMATTER_QM_CONNECTION) {
            MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAQueueManagerUtils.getQueueManagerObject(mqjmsobject,props)  MQNameFormatter QM connection property is set to false. As a result, users will notice few unknown nodes in the investigator");
            return null;
        }
        Object qmgrObj = null;
        String qmObjectKey = null;
        CAQueueManagerUtils.refreshCache();
        if (mqjmsobject != null) {
            try {
                String connectionMode;
                if (classLoader == null) {
                    classLoader = mqjmsobject.getClass().getClassLoader();
                    cls_MQQueueManager = Class.forName("com.ibm.mq.MQQueueManager", false, classLoader);
                }
                if (CAMQUtils.MQCONN_BINDING_MODE.equals(connectionMode = (String)props.get("TRANSPORT_MODE"))) {
                    String qmName;
                    if (constructor_BindingMQQueueManager == null) {
                        constructor_BindingMQQueueManager = cls_MQQueueManager.getConstructor(String.class);
                    }
                    if ((qmgrObj = (Object)tempQueueManagersMap.get(qmObjectKey = "localhost|" + (qmName = (String)props.get("QUEUEMANAGER_NAME")))) == null || !CAQueueManagerUtils.isQueueManagerConnected(qmgrObj)) {
                        qmgrObj = constructor_BindingMQQueueManager.newInstance(qmName);
                        tempQueueManagersMap.put(qmObjectKey, qmgrObj);
                        tempQueueManagersList.add(qmgrObj);
                    }
                } else {
                    if (constructor_MQQueueManager == null) {
                        constructor_MQQueueManager = cls_MQQueueManager.getConstructor(String.class, Hashtable.class);
                    }
                    String hostname = String.valueOf(props.get("hostname"));
                    String port = String.valueOf(props.get("port"));
                    qmObjectKey = String.valueOf(hostname) + "|" + port;
                    qmgrObj = tempQueueManagersMap.get(qmObjectKey);
                    if (qmgrObj == null || !CAQueueManagerUtils.isQueueManagerConnected(qmgrObj)) {
                        Object[] arg = new Object[]{new String(""), props};
                        qmgrObj = constructor_MQQueueManager.newInstance(arg);
                        tempQueueManagersMap.put(qmObjectKey, qmgrObj);
                        tempQueueManagersList.add(qmgrObj);
                    }
                }
            }
            catch (Exception e) {
                MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAQueueManagerUtils.getQueueManagerObject(mqjmsobject,props) ", (Throwable)e);
                tempQueueManagersMap.remove(qmObjectKey);
                tempQueueManagersList.remove(qmgrObj);
                CAQueueManagerUtils.disconnectQueueManager(qmgrObj);
            }
        }
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAQueueManagerUtils.getQueueManagerObject(mqjmsobject,props) qmgrObj: " + qmgrObj);
        return qmgrObj;
    }

    public static boolean isQueueManagerConnected(Object mqQueueManager) {
        boolean connectedStatus = false;
        if (mqQueueManager != null) {
            Class<?> mqQueueManagerClass = mqQueueManager.getClass();
            if (mqQueueManagerClass.getName().equals("com.ibm.mq.MQSPIQueueManager")) {
                mqQueueManagerClass = mqQueueManagerClass.getSuperclass();
            }
            try {
                if (mMQQueueManager_isConnected == null) {
                    mMQQueueManager_isConnected = mqQueueManagerClass.getMethod("isConnected", new Class[0]);
                }
                if (!(connectedStatus = Boolean.parseBoolean(mMQQueueManager_isConnected.invoke(mqQueueManager, new Object[0]).toString()))) {
                    CAQueueManagerUtils.disconnectQueueManager(mqQueueManager);
                }
            }
            catch (Exception e) {
                MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAQueueManagerUtils.isQueueManagerConnected(mqQueueManager) ", (Throwable)e);
            }
        }
        return connectedStatus;
    }

    public static void disconnectQueueManager(Object mqQueueManager) {
        if (mqQueueManager != null) {
            Class<?> mqQueueManagerClass = mqQueueManager.getClass();
            if (mqQueueManagerClass.getName().equals("com.ibm.mq.MQSPIQueueManager")) {
                mqQueueManagerClass = mqQueueManagerClass.getSuperclass();
            }
            try {
                if (mMQQueueManager_disconnect == null) {
                    mMQQueueManager_disconnect = mqQueueManagerClass.getMethod("disconnect", new Class[0]);
                }
                mMQQueueManager_disconnect.invoke(mqQueueManager, new Object[0]);
                mqQueueManager = null;
            }
            catch (Exception e) {
                MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAQueueManagerUtils.disconnectQueueManager(mqQueueManager) ", (Throwable)e);
            }
        }
    }

    private static void refreshCache() {
        if (System.currentTimeMillis() - cleanUpTimeStamp > 86400000L) {
            queueManagerNamesMap.clear();
            tempQueueManagersMap.clear();
            int i = 0;
            while (i < tempQueueManagersList.size()) {
                CAQueueManagerUtils.disconnectQueueManager(tempQueueManagersList.get(i));
                ++i;
            }
            tempQueueManagersList.clear();
        }
        if (numberOfQMReferences > 100) {
            mQueueManagersMap.clear();
        }
    }
}

