/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils;

import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.Kconstants;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.logger.MQPPLog;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.CAQueueManagerUtils;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.CAQueueUtils;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.QMRepository;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.QMVO;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.QueueVO;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.MQTransactionTracerUtil;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.TraceProperties;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public final class QueueRepository
implements Kconstants {
    private static final String CLASS_NAME = "QueueRepository.";
    private static Map queueVOsMap = new WeakHashMap();
    private static final Object MUTEX_LOCK = new Object();
    public static List queuevosList = new CopyOnWriteArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueueVO getQueueVO(Object mqQueue, String queueName) {
        QueueVO vo = null;
        if (mqQueue != null) {
            if (queueName == null || queueName.trim().length() == 0) {
                queueName = MQTransactionTracerUtil.getQueueName(mqQueue);
            }
            if (!((vo = (QueueVO)queueVOsMap.get(mqQueue)) != null && vo.getQueueName().equalsIgnoreCase(queueName) || (vo = QueueRepository.createQueueVO(mqQueue, queueName)) == null)) {
                Object object = MUTEX_LOCK;
                synchronized (object) {
                    QueueVO vo1 = (QueueVO)queueVOsMap.get(mqQueue);
                    if (vo1 == null) {
                        queueVOsMap.put(mqQueue, vo);
                        if (TraceProperties.shouldStartDiscovery() && !queuevosList.contains(vo)) {
                            queuevosList.add(vo);
                        }
                    } else {
                        vo = vo1;
                    }
                }
            }
        }
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueueVO getQueueVO(Object mqQueue, String queueName, Hashtable properties) {
        QueueVO vo = null;
        Object qmgrObj = null;
        if (mqQueue != null) {
            vo = (QueueVO)queueVOsMap.get(mqQueue);
            if (queueName == null || queueName.trim().length() == 0 || properties == null) {
                return null;
            }
            if (!(vo != null && vo.getQueueName().equalsIgnoreCase(queueName) || (qmgrObj = CAQueueManagerUtils.getQueueManagerObject(mqQueue, properties)) == null || (vo = QueueRepository.createQueueVO(qmgrObj, queueName)) == null)) {
                Object object = MUTEX_LOCK;
                synchronized (object) {
                    QueueVO vo1 = (QueueVO)queueVOsMap.get(mqQueue);
                    if (vo1 == null) {
                        queueVOsMap.put(mqQueue, vo);
                        if (TraceProperties.shouldStartDiscovery() && !queuevosList.contains(vo)) {
                            queuevosList.add(vo);
                        }
                    } else {
                        vo = vo1;
                    }
                }
            }
        }
        return vo;
    }

    public static QueueVO createQueueVO(Object mqObject, String queueName) {
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "QueueRepository.createQueueVO(queue) entry");
        QueueVO vo = null;
        Object queue = null;
        boolean tempQueueCreated = false;
        if (QueueRepository.isQueueHasInquire(mqObject)) {
            queue = mqObject;
        } else {
            queue = MQTransactionTracerUtil.createTemporaryQueue(mqObject, queueName);
            if (queue != null) {
                tempQueueCreated = true;
            }
        }
        vo = QueueRepository.generateQueueVO(queue, queueName);
        int queueType = CAQueueUtils.getQueueType(queue);
        if (queueType != -1) {
            vo.setQueueType(queueType);
        }
        int queueDefType = -1;
        if (queueType == QueueVO.QUEUETYPE_LOCAL) {
            queueDefType = CAQueueUtils.getQueueDefinitionType(queue);
            if (queueDefType != -1) {
                vo.setQueueDefinitionType(queueDefType);
            }
            if (queueDefType == QueueVO.QUEUEDEFTYPE_TEMPORARY_DYNAMIC || queueDefType == QueueVO.QUEUETYPE_PERMANENT_DYNAMIC) {
                vo.setDynamic(true);
            }
        } else if (queueType == QueueVO.QUEUETYPE_ALIAS) {
            String baseQName = CAQueueUtils.getBaseQueueName(queue);
            if (vo.getBaseQueueName() == null || vo.getBaseQueueName().trim().length() == 0 || !vo.getBaseQueueName().equals(baseQName)) {
                vo.setBaseQueueName(baseQName);
                Object baseQueue = MQTransactionTracerUtil.createTemporaryQueue(queue, baseQName);
                int baseQType = CAQueueUtils.getQueueType(baseQueue);
                vo.setBaseQueueType(baseQType);
                if (baseQType == QueueVO.QUEUETYPE_LOCAL) {
                    int baseQDefType = CAQueueUtils.getQueueDefinitionType(baseQueue);
                    vo.setBaseQueueDefinitionType(baseQDefType);
                }
                MQTransactionTracerUtil.closeQueue(baseQueue);
            }
        }
        if (tempQueueCreated) {
            MQTransactionTracerUtil.closeQueue(queue);
        }
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "QueueRepository.createQueueVO(queue) exit");
        return vo;
    }

    private static boolean isQueueHasInquire(Object queue) {
        boolean inquireFlag = false;
        Class<?> mqclass = queue.getClass();
        String mqClassName = mqclass.getName();
        if (mqClassName.equals("com.ibm.mq.MQQueue") || mqClassName.equals("com.ibm.mq.MQSPIQueue")) {
            int queueType;
            int queueOpenOptions = CAQueueUtils.getQueueOpenOptions(queue);
            if ((queueOpenOptions & 0x60) == 96) {
                inquireFlag = true;
            } else if ((queueOpenOptions & 0x20) == 32 && (queueType = CAQueueUtils.getQueueType(queue)) != QueueVO.QUEUETYPE_CLUSTER) {
                inquireFlag = true;
            }
        }
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "QueueRepository.isQueueHasInquire(queue) inquireFlag " + inquireFlag);
        return inquireFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addQueueVO(InvocationData invocationdata, boolean isDynamic) {
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "QueueRepository.addQueueVO(InvocationData,boolean) entry");
        QueueVO vo = null;
        Object queueObj = invocationdata.getInvocationReturnValueAsObject();
        if (queueObj != null) {
            try {
                String queueName = MQTransactionTracerUtil.getQueueName(queueObj);
                vo = QueueRepository.generateQueueVO(queueObj, queueName);
                vo.setQueueType(QueueVO.QUEUETYPE_LOCAL);
                vo.setQueueDefinitionType(QueueVO.QUEUEDEFTYPE_TEMPORARY_DYNAMIC);
                vo.setDynamic(isDynamic);
                Object object = MUTEX_LOCK;
                synchronized (object) {
                    queueVOsMap.put(queueObj, vo);
                }
            }
            catch (Exception ex) {
                MQPPLog.getLogger().debug(MQPPLog.getModule(), "QueueRepository.addQueueVO(InvocationData,boolean) ", (Throwable)ex);
            }
        }
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "QueueRepository.addQueueVO(InvocationData,boolean) exit");
    }

    private static QueueVO generateQueueVO(Object queueObj, String queueName) {
        QueueVO vo = new QueueVO();
        Object qmObj = MQTransactionTracerUtil.getQueueManager(queueObj);
        QMVO qmVO = QMRepository.getQMVO(qmObj);
        vo.setQMVO(qmVO);
        if (queueName != null && queueName.length() != 0) {
            vo.setQueueName(queueName);
        }
        return vo;
    }

    public static List getQueuevosList() {
        return queuevosList;
    }

    public static void removeQueuevosList() {
        queuevosList.clear();
    }
}

