/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.trace.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.logger.MQPPLog;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.CAMQUtils;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.MQClassLoaderUtil;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.QueueVO;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.MQTransactionTracerConstants;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.MQTransactionTracerUtil;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.TraceProperties;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.discovery.MQDiscoveryDataProcessor;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.HandshakeManager;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.MQMonitorAgentsMonitor;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.Reflection;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.util.Hashtable;

public class JMSSendTransactionTracer
extends ASingleMetricTracerFactory
implements MQTransactionTracerConstants {
    private IModuleFeedbackChannel fLogger = MQPPLog.getLogger();
    public static final Module kModule = new Module("JMSSendTransactionTracer");

    static {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        MQClassLoaderUtil.initialize(classloader);
        Reflection.initialise(classloader);
        if (TraceProperties.shouldTraceMQCPT()) {
            HandshakeManager.getInstance();
        }
        if (TraceProperties.shouldStartDiscovery()) {
            MQDiscoveryDataProcessor.getInstance();
        }
    }

    public JMSSendTransactionTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.fLogger.debug(kModule, "Inside JMSSendTransactionTracer consutructor");
    }

    protected IDataAccumulator createDataAccumulator(String arg0) {
        return null;
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        this.fLogger.debug(kModule, "Inside ITracer_startTrace");
        try {
            Object jmsObject = data.getInvocationObject();
            this.fLogger.debug(kModule, "Invocation object class name: " + jmsObject.getClass().getName());
            int mqProviderVersion = MQTransactionTracerUtil.getMQProviderVersion(jmsObject);
            if (mqProviderVersion == 7) {
                boolean traceOn = this.getAgent().IAgent_getComponentTracer().shouldCurrentTraceBePropagated();
                this.fLogger.debug(kModule, "traceOn..:" + traceOn);
                boolean mqCrossProcessFlag = TraceProperties.shouldTraceMQCPT();
                boolean allQMMonitored = false;
                if (mqCrossProcessFlag) {
                    allQMMonitored = MQMonitorAgentsMonitor.getInstance(this.fLogger).isAllMQMonitored();
                }
                Object jmsMessage = null;
                Object jmsDestination = null;
                long timeToLive = 0L;
                int parameterCount = data.getInvocationParameterCount();
                if (parameterCount == 1 || parameterCount == 4) {
                    jmsMessage = data.getInvocationParameterAsObject(0);
                    jmsDestination = MQTransactionTracerUtil.getJMSDestinationObject(jmsObject);
                    if (parameterCount == 4) {
                        timeToLive = (Long)data.getInvocationParameterAsObject(3);
                    }
                } else if (parameterCount == 2 || parameterCount == 5) {
                    jmsMessage = data.getInvocationParameterAsObject(1);
                    jmsDestination = data.getInvocationParameterAsObject(0);
                    if (parameterCount == 5) {
                        timeToLive = (Long)data.getInvocationParameterAsObject(4);
                    }
                }
                MQTransactionTracerUtil.setJMSDestinationBooleanProperty(jmsDestination, "mdWriteEnabled", true);
                if (TraceProperties.shouldTraceMQSYSVIEW()) {
                    int feedback = MQTransactionTracerUtil.getJMSMessageIntProperty(jmsMessage, "JMS_IBM_MQMD_Feedback");
                    int messageType = MQTransactionTracerUtil.getJMSMessageIntProperty(jmsMessage, "JMS_IBM_MQMD_MsgType");
                    if (messageType != 4 && feedback == 0) {
                        if (traceOn) {
                            MQTransactionTracerUtil.setJMSMessageIntProperty(jmsMessage, "JMS_IBM_MQMD_Feedback", 99990001);
                        } else {
                            MQTransactionTracerUtil.setJMSMessageIntProperty(jmsMessage, "JMS_IBM_MQMD_Feedback", 99990000);
                        }
                    }
                }
                if (traceOn && mqCrossProcessFlag && allQMMonitored) {
                    Hashtable props;
                    String queueName = MQTransactionTracerUtil.getJMSDestinationName(jmsDestination);
                    String queueManagerName = CAMQUtils.getJMSObjectProperty(jmsObject, "XMSC_WMQ_QUEUE_MANAGER");
                    if (queueName != null && queueName.trim().length() != 0 && !MQTransactionTracerUtil.shouldExcludeQueue(queueManagerName, queueName) && (props = MQTransactionTracerUtil.getJMSPropertiesObject(jmsObject)) != null) {
                        QueueVO queueVO = MQTransactionTracerUtil.getQueueVO(jmsDestination, null, queueName, props);
                        this.queueStartTrace(queueVO, jmsMessage, jmsDestination, jmsObject, timeToLive);
                    }
                }
            }
        }
        catch (Exception e) {
            this.fLogger.debug(kModule, e.getMessage(), (Throwable)e);
        }
    }

    private void queueStartTrace(QueueVO queueVO, Object jmsMessage, Object jmsDestination, Object jmsObject, long timeToLive) {
        try {
            if (queueVO != null) {
                int qType = queueVO.getQueueType();
                int qDefinitionType = -1;
                if (qType == 1) {
                    qDefinitionType = queueVO.getQueueDefinitionType();
                }
                String qName = queueVO.getQueueName();
                if (qType == 3) {
                    qType = queueVO.getBaseQueueType();
                    qDefinitionType = queueVO.getBaseQueueDefinitionType();
                    qName = queueVO.getBaseQueueName();
                }
                if ("SYSTEM.ADMIN.ACTIVITY.QUEUE".equalsIgnoreCase(qName)) {
                    this.fLogger.debug(kModule, "Q is SYSTEM ADMIN ACTIVITY QUEUE, no JMS transaction trace");
                } else if (qDefinitionType == 2 || qDefinitionType == 3) {
                    this.fLogger.debug(kModule, "Q Type is PERMANENT or TEMPORARY DYNAMIC, no JMS transaction trace");
                } else if (qType == 1) {
                    this.fLogger.debug(kModule, "Q Type is LOCAL or ALIAS BASE LOCAL, will send dummy message...");
                } else {
                    this.fLogger.debug(kModule, "Q Type is REMOTE or Other, will set the activity bit");
                    MQTransactionTracerUtil.setJMSReportbitAndReplyToQueue(jmsMessage, jmsDestination);
                }
            }
        }
        catch (Exception e) {
            this.fLogger.debug(kModule, e.getMessage(), (Throwable)e);
        }
    }

    public void ITracer_finishTrace(int arg0, InvocationData data) {
        this.fLogger.debug(kModule, "Inside ITracer_finishTrace");
        try {
            Object jmsObject = data.getInvocationObject();
            int mqProviderVersion = MQTransactionTracerUtil.getMQProviderVersion(jmsObject);
            if (mqProviderVersion == 7) {
                int feedback;
                boolean traceOn = this.getAgent().IAgent_getComponentTracer().shouldCurrentTraceBePropagated();
                this.fLogger.debug(kModule, "traceOn..:" + traceOn);
                boolean mqCrossProcessFlag = TraceProperties.shouldTraceMQCPT();
                boolean allQMMonitored = false;
                if (mqCrossProcessFlag) {
                    allQMMonitored = MQMonitorAgentsMonitor.getInstance(this.fLogger).isAllMQMonitored();
                }
                Object jmsMessage = null;
                Object jmsDestination = null;
                long timeToLive = 0L;
                int parameterCount = data.getInvocationParameterCount();
                if (parameterCount == 1 || parameterCount == 4) {
                    jmsMessage = data.getInvocationParameterAsObject(0);
                    jmsDestination = MQTransactionTracerUtil.getJMSDestinationObject(jmsObject);
                    if (parameterCount == 4) {
                        timeToLive = (Long)data.getInvocationParameterAsObject(3);
                    }
                } else if (parameterCount == 2 || parameterCount == 5) {
                    jmsMessage = data.getInvocationParameterAsObject(1);
                    jmsDestination = data.getInvocationParameterAsObject(0);
                    if (parameterCount == 5) {
                        timeToLive = (Long)data.getInvocationParameterAsObject(4);
                    }
                }
                if (TraceProperties.shouldTraceMQSYSVIEW() && ((feedback = MQTransactionTracerUtil.getJMSMessageIntProperty(jmsMessage, "JMS_IBM_MQMD_Feedback")) == 99990001 || feedback == 99990000)) {
                    MQTransactionTracerUtil.setJMSMessageIntProperty(jmsMessage, "JMS_IBM_MQMD_Feedback", 0);
                }
                if (traceOn) {
                    String queueName = MQTransactionTracerUtil.getJMSDestinationName(jmsDestination);
                    String queueManagerName = CAMQUtils.getJMSObjectProperty(jmsObject, "XMSC_WMQ_QUEUE_MANAGER");
                    if (queueName != null && queueName.trim().length() != 0 && !MQTransactionTracerUtil.shouldExcludeQueue(queueManagerName, queueName)) {
                        Hashtable props;
                        String messageID = MQTransactionTracerUtil.getJMSMessageID(jmsMessage);
                        String correlationID = MQTransactionTracerUtil.getJMSCorrelationID(jmsMessage);
                        MQTransactionTracerUtil.addToCorrelation(this.getAgent(), messageID, correlationID);
                        if (mqCrossProcessFlag && allQMMonitored && (props = MQTransactionTracerUtil.getJMSPropertiesObject(jmsObject)) != null) {
                            QueueVO queueVO = MQTransactionTracerUtil.getQueueVO(jmsDestination, null, queueName, props);
                            this.queueFinishTrace(queueVO, jmsMessage, jmsObject, timeToLive);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.fLogger.debug(kModule, e.getMessage(), (Throwable)e);
        }
    }

    private void queueFinishTrace(QueueVO queueVO, Object jmsMessage, Object jmsObject, long timeToLive) {
        try {
            if (queueVO != null) {
                int qType = queueVO.getQueueType();
                int qDefinitionType = -1;
                if (qType == 1) {
                    qDefinitionType = queueVO.getQueueDefinitionType();
                }
                String qName = queueVO.getQueueName();
                if (qType == 3) {
                    qType = queueVO.getBaseQueueType();
                    qDefinitionType = queueVO.getBaseQueueDefinitionType();
                    qName = queueVO.getBaseQueueName();
                }
                if ("SYSTEM.ADMIN.ACTIVITY.QUEUE".equalsIgnoreCase(qName)) {
                    this.fLogger.debug(kModule, "Q is SYSTEM ADMIN ACTIVITY QUEUE, no JMS transaction trace");
                } else if (qDefinitionType == 2 || qDefinitionType == 3) {
                    this.fLogger.debug(kModule, "Q Type is PERMANENT or TEMPORARY DYNAMIC, no JMS transaction trace");
                } else if (qType == 1) {
                    Object jmsSessionObject = MQTransactionTracerUtil.getJMSSessionObject(jmsObject);
                    Object dummyJMSMessage = MQTransactionTracerUtil.createDummyJMSMessage(queueVO, jmsMessage, jmsSessionObject, timeToLive);
                    MQTransactionTracerUtil.sendDummyMessage(jmsSessionObject, dummyJMSMessage, timeToLive);
                    this.fLogger.debug(kModule, "Q Type is LOCAL or ALIAS BASE LOCAL, sent dummy message");
                }
            }
        }
        catch (Exception e) {
            this.fLogger.debug(kModule, e.getMessage(), (Throwable)e);
        }
    }
}

