/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives;

import com.wily.diagnos.cmp.directives.ADirective;
import com.wily.diagnos.cmp.directives.FlagName;
import com.wily.diagnos.cmp.directives.InvalidDirectiveException;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.directives.builder.TracerGroupBuilder;
import com.wily.diagnos.cmp.transform.builder.NoticeConstructorCompletionTransformationBuilder;
import com.wily.util.classfile.FullyQualifiedMethodName;
import com.wily.util.classfile.IMethodSignature;
import com.wily.util.classfile.ISlotSignature;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;

public final class NoticeConstructorCompletionIfFlaggedDirective
extends ADirective {
    private static final String kMethodMustHaveExactlyOneParameterMessage = "Method must have exactly one parameter: ";
    private static final String kParameterMustBeObjectReferenceMessage = "Method must have an object reference type for the parameter: ";
    private static final String kReturnTypeMustBeVoidMessage = "Return type for the method must be void";
    private final FlagName fFlagName;
    private final FullyQualifiedMethodName fNotificationMethod;

    public NoticeConstructorCompletionIfFlaggedDirective(String source, int lineNumber, FlagName flagName, FullyQualifiedMethodName methodToCall) throws InvalidDirectiveException {
        super(source, lineNumber);
        this.validateParameters(methodToCall);
        this.fFlagName = flagName;
        this.fNotificationMethod = methodToCall;
    }

    private void validateParameters(FullyQualifiedMethodName notificationMethod) throws InvalidDirectiveException {
        IMethodSignature notificationDescriptor = notificationMethod.getMethodName().getSignature();
        if (notificationDescriptor.getParameterCount() != 1) {
            throw new InvalidDirectiveException(kMethodMustHaveExactlyOneParameterMessage + notificationMethod.getMethodName().getNameAndSignatureString(), (ILocalizableMessage)new FormattedLocalizableMessage("Diagnos_Exception_Parsing_Notification_Method_One_Parameter_Only", notificationMethod.getMethodName().getNameAndSignatureString(), false));
        }
        ISlotSignature notificationParameter = notificationDescriptor.getParameterSignatureByIndex(0);
        if (!notificationParameter.isExactlyObject()) {
            throw new InvalidDirectiveException(kParameterMustBeObjectReferenceMessage + notificationMethod.getMethodName().getNameAndSignatureString(), (ILocalizableMessage)new FormattedLocalizableMessage("Diagnos_Exception_Parsing_Notification_Method_Parameter_Must_Be_Java_Lang_Object", notificationMethod.getMethodName().getNameAndSignatureString(), false));
        }
        ISlotSignature notificationReturnType = notificationDescriptor.getReturnSlotSignature();
        if (!notificationReturnType.isVoid()) {
            throw new InvalidDirectiveException(kReturnTypeMustBeVoidMessage + notificationMethod.getMethodName().getNameAndSignatureString(), (ILocalizableMessage)new FormattedLocalizableMessage("Diagnos_Exception_Parsing_Notification_Method_Return_Type_Must_Be_Void", notificationMethod.getMethodName().getNameAndSignatureString(), false));
        }
    }

    private FlagName getFlagName() {
        return this.fFlagName;
    }

    private FullyQualifiedMethodName getNotificationMethod() {
        return this.fNotificationMethod;
    }

    protected void applyToSettings(CompilerSettingsBuilder builder) {
        TracerGroupBuilder flag = builder.getTracerGroupBuilder(this.getFlagName());
        builder.addTransformation(new NoticeConstructorCompletionTransformationBuilder(flag, this.getNotificationMethod()));
    }
}

