/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.correlation;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.correlation.ICrossProcessCallback;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.WrappedInvocationData;
import com.wily.introscope.agent.trace.cas.ITransactionStructure;
import com.wily.introscope.agent.transactiontrace.CrossCorrelationStringParameterProvider;
import com.wily.introscope.agent.transactiontrace.ITransactionEventListener;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.spec.server.transactiontrace.GUIDGenerator;
import com.wily.introscope.spec.server.transactiontrace.SequenceId;
import com.wily.util.WilyStringBuilder;
import com.wily.util.adt.IGuaranteedCounter;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.StringSetConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import java.util.Map;

public class CrossProcessCorrelationAdmin {
    static final Module kModule = new Module("CrossProcessCorrelationAdmin");
    private static final String kLogConfigPropertyName = "log4j.logger.IntroscopeAgent";
    private static volatile boolean isAgentTraceEnabled = false;
    private static GUIDGenerator sGuidGenerator = GUIDGenerator.getInstance();
    private static volatile String coretxnuid = sGuidGenerator.generateKey();
    private static volatile IGuaranteedCounter counter;
    private static IInvocationDataParameterCallback sInvocationDataCallback;
    private static ITransactionEventListener sTransactionEventListener;
    private static final ThreadLocal fThreadLocalCorrelationCache;
    private static final ThreadLocal fThreadLocalCorrelationTxnId;

    static {
        try {
            counter = AgentShim.getAgent().IAgent_getGuaranteedCounter();
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            counter = null;
        }
        sInvocationDataCallback = new VirtualElementCallback();
        sTransactionEventListener = new ITransactionEventListener(){

            public void postTransactionEndCallback(IAgent agent, IStackElement lastRemoveComponent) {
            }

            public void preTransactionEndCallback(IAgent agent, IStackElement lastRemoveComponent) {
                lastRemoveComponent.setParameterCallback(sInvocationDataCallback);
            }

            public void transactionComponentAddCallback(IAgent agent, IStackElement data) {
                CrossProcessCorrelationAdmin.componentGotPushedNotification(agent, data);
            }

            public void transactionComponentRemoveCallback(IAgent agent, IStackElement data) {
            }

            public void transactionStartedCallback(IAgent agent, IStackElement firstAddedComponent) {
                CrossProcessCorrelationAdmin.prepForNewTransaction(agent, firstAddedComponent);
            }
        };
        fThreadLocalCorrelationCache = new ThreadLocal(){

            protected Object initialValue() {
                return new SharedCrossProcessData();
            }
        };
        fThreadLocalCorrelationTxnId = new ThreadLocal(){

            protected Object initialValue() {
                return new TransactionIdProvider();
            }
        };
    }

    public static void registerEventListenerToTxnStructure(ITransactionStructure structure) {
        structure.registerTxnEventListener(sTransactionEventListener);
    }

    public static void invalidateCrossProcessDataCache() {
        ((SharedCrossProcessData)fThreadLocalCorrelationCache.get()).clear();
    }

    public static SharedCrossProcessData getCrossProcessCorrelationCache() {
        return (SharedCrossProcessData)fThreadLocalCorrelationCache.get();
    }

    public static void initializeProperties(IAgent agent) {
        ConfigurationManager cm = agent.IAgent_getConfigurationManager();
        cm.add(new TraceLogConfigurationProperty(kLogConfigPropertyName, null, null, agent.IAgent_getModule(), agent.IAgent_getStringLocalizer(), agent));
    }

    private static void prepForNewTransaction() {
        try {
            IAgent agent = AgentShim.getAgent();
            CrossProcessCorrelationAdmin.prepForNewTransaction(agent, null);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
    }

    private static void prepForNewTransaction(IAgent agent, IStackElement element) {
        String transactionId;
        String txnuid = coretxnuid;
        int next = 0;
        if (counter != null) {
            next = counter.next();
            if (next > 10000) {
                coretxnuid = sGuidGenerator.generateKey();
                counter.reset();
            }
        } else {
            txnuid = sGuidGenerator.generateKey();
        }
        TransactionIdProvider tidProvider = (TransactionIdProvider)fThreadLocalCorrelationTxnId.get();
        tidProvider.setValues(txnuid, next);
        SharedCrossProcessData cache = null;
        if (element != null && element instanceof InvocationData) {
            cache = ((InvocationData)element).getSharedCrossProcessData();
        }
        if (cache == null) {
            cache = CrossProcessCorrelationAdmin.getCrossProcessCorrelationCache();
        }
        if ((transactionId = cache.getStringParamOut("TxnTraceId")) != null) {
            ((TransactionIdProvider)fThreadLocalCorrelationTxnId.get()).setTransactionId(transactionId);
            if (agent != null && isAgentTraceEnabled) {
                agent.IAgent_getModuleFeedback().trace("CrossProcessCorrelationAdmin re-using existing correlation TxnId " + transactionId);
            }
        } else {
            cache.addParamOut("TxnTraceId", tidProvider);
            if (agent != null && isAgentTraceEnabled) {
                agent.IAgent_getModuleFeedback().trace("CrossProcessCorrelationAdmin added new correlation TxnId " + txnuid);
            }
        }
    }

    public static void componentGotPushedNotification() {
        CrossProcessCorrelationAdmin.componentGotPushedNotification(null, null);
    }

    public static void componentGotPushedNotification(IAgent agent, IStackElement element) {
        SharedCrossProcessData cache = null;
        if (element != null && element instanceof InvocationData) {
            cache = ((InvocationData)element).getSharedCrossProcessData();
        }
        if (cache == null && element != null && element instanceof WrappedInvocationData) {
            cache = ((WrappedInvocationData)element).getInvocationData().getSharedCrossProcessData();
        }
        if (cache == null) {
            cache = CrossProcessCorrelationAdmin.getCrossProcessCorrelationCache();
        }
        cache.addParamOut("TxnTraceId", (TransactionIdProvider)fThreadLocalCorrelationTxnId.get());
    }

    private static void prepCorrelationParamsBeforeTxnEnd(Map parameters) {
        try {
            String corid;
            SharedCrossProcessData cache = CrossProcessCorrelationAdmin.getCrossProcessCorrelationCache();
            if (cache != null && (corid = cache.getCorrelationID()) != null) {
                String seqid;
                parameters.put("CorCrossProcessData", corid);
                SequenceId id = cache.getSeqID();
                if (id != null && (seqid = id.getSequenceId()) != null) {
                    parameters.put("SeqNoCrossProcessData", seqid);
                }
                String txnTraceId = cache.getStringParamIn("TxnTraceId");
                if (isAgentTraceEnabled) {
                    AgentShim.getAgent().IAgent_getModuleFeedback().trace("CrossProcessCorrelationAdmin my Caller TxnId " + txnTraceId);
                }
                if (txnTraceId != null) {
                    parameters.put("CallerTxnTraceId", txnTraceId);
                }
                if (isAgentTraceEnabled) {
                    AgentShim.getAgent().IAgent_getModuleFeedback().trace("CrossProcessCorrelationAdmin my GUID " + ((TransactionIdProvider)fThreadLocalCorrelationTxnId.get()).getTransactionId());
                }
                parameters.put("TxnTraceId", ((TransactionIdProvider)fThreadLocalCorrelationTxnId.get()).getTransactionId());
                String callerTxnTime = cache.getStringParamIn("CallerTimestamp");
                if (isAgentTraceEnabled) {
                    AgentShim.getAgent().IAgent_getModuleFeedback().trace("CrossProcessCorrelationAdmin my Caller's timestamp " + callerTxnTime);
                }
                if (callerTxnTime != null) {
                    parameters.put("CallerTimestamp", callerTxnTime);
                }
                String nonBlockTxn = cache.getStringParamIn("NBThreadTxn");
                if (isAgentTraceEnabled) {
                    AgentShim.getAgent().IAgent_getModuleFeedback().trace("CrossProcessCorrelationAdmin current Txn Non Blocking = " + nonBlockTxn);
                }
                if (nonBlockTxn != null) {
                    parameters.put("NBThreadTxn", nonBlockTxn);
                }
            }
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
    }

    public static final class TraceLogConfigurationProperty
    extends StringSetConfigurationProperty {
        private final IAgent agent;

        private TraceLogConfigurationProperty(String name, String descriptionKey, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer, IAgent agent) {
            super(name, descriptionKey, feedback, module, localizer);
            this.agent = agent;
        }

        public final void set(Object value) {
            isAgentTraceEnabled = this.agent.IAgent_getModuleFeedback().isTraceEnabled();
        }
    }

    private static class TransactionIdProvider
    implements CrossCorrelationStringParameterProvider {
        String coretxnuid;
        int next;
        String computedString = null;
        final WilyStringBuilder sb = new WilyStringBuilder(256);

        private TransactionIdProvider() {
        }

        void setValues(String base, int value) {
            this.computedString = null;
            this.coretxnuid = base;
            this.next = value;
        }

        String getTransactionId() {
            if (this.computedString == null) {
                this.sb.replace(0, this.sb.length(), "");
                this.computedString = this.sb.append(this.coretxnuid).append(this.next).toString();
            }
            return this.computedString;
        }

        public void setTransactionId(String transactionId) {
            this.computedString = transactionId;
        }

        public String getParam(String key) {
            if (key == "TxnTraceId") {
                return this.getTransactionId();
            }
            return null;
        }
    }

    private static class VirtualElementCallback
    implements IInvocationDataParameterCallback,
    ICrossProcessCallback {
        private VirtualElementCallback() {
        }

        public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map parameters) {
            CrossProcessCorrelationAdmin.prepCorrelationParamsBeforeTxnEnd(parameters);
        }

        public void IInvocationDataParameterCallback_addParameters(IStackElement data, Map parameters) {
            CrossProcessCorrelationAdmin.prepCorrelationParamsBeforeTxnEnd(parameters);
        }
    }
}

