/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.probe.io;

import com.wily.introscope.agent.ACommonAgent;
import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.recording.IMetricAgedListener;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.IIntegerRateDataAccumulator;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.wilyassert.Assertion;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;

public class ManagedFileOutputStream
extends FileOutputStream {
    private static final Object sLock = new Object();
    private static volatile IIntegerRateDataAccumulator sFileOutputRate = null;
    private static volatile IAgent sAgent;
    private static volatile boolean sHasNewConfiguration;
    private ThreadLocal fIsWriting;
    private static final ThreadLocal fIsInWilyCall;

    static {
        fIsInWilyCall = new ThreadLocal();
    }

    public ManagedFileOutputStream(FileDescriptor fd) {
        super(fd);
        try {
            this.com_wily_initialize();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    public ManagedFileOutputStream(String file) throws IOException {
        super(file);
        try {
            this.com_wily_initialize();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    public ManagedFileOutputStream(File file) throws IOException {
        super(file);
        try {
            this.com_wily_initialize();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    public ManagedFileOutputStream(String file, boolean append) throws IOException {
        super(file, append);
        try {
            this.com_wily_initialize();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    public ManagedFileOutputStream(File file, boolean append) throws IOException {
        super(file, append);
        try {
            this.com_wily_initialize();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void com_wily_initialize() {
        Object tl = AgentShim.getAgentShimThreadLocal();
        if (AgentShim.isThreadInAgentCode(tl)) {
            return;
        }
        try {
            block15: {
                try {
                    AgentShim.setThreadInAgentCode(tl);
                    this.fIsWriting = new ThreadLocal();
                    if (sFileOutputRate != null) break block15;
                    Object object = sLock;
                    synchronized (object) {
                        if (sFileOutputRate == null && (sAgent = AgentShim.getAgent()) != null) {
                            sFileOutputRate = ManagedFileOutputStream.createAccumulator(sAgent);
                            AgentMetric accmetric = sFileOutputRate.IDataAccumulator_getMetric();
                            sAgent.IAgent_getMetricRecordingAdministrator().addMetricRecordingListenerWithRewind(accmetric, new FileOutputStreamMetricListener());
                            if (sAgent instanceof ACommonAgent) {
                                sHasNewConfiguration = (Boolean)((ACommonAgent)ManagedFileOutputStream.sAgent).fAgentBlameConfigurationOldProperty.getValue();
                            }
                        }
                    }
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    try {
                        AgentShim.handleError("Exception initializing ManagedFileOutputStream", t);
                    }
                    catch (ThreadDeath td2) {
                        throw td2;
                    }
                    catch (Throwable throwable) {}
                }
            }
            Object var4_9 = null;
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            AgentShim.clearThreadInAgentCode(tl);
            throw throwable;
        }
        AgentShim.clearThreadInAgentCode(tl);
    }

    private static IIntegerRateDataAccumulator createAccumulator(IAgent agent) {
        DataAccumulatorFactory factory = sAgent.IAgent_getDataAccumulatorFactory();
        return factory.safeGetIntegerRateDataAccumulator("File System:File Output Rate (Bytes Per Second)");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(int b) throws IOException {
        Object var6_13;
        Object tl = AgentShim.getAgentShimThreadLocal();
        if (AgentShim.isThreadInAgentCode(tl)) {
            super.write(b);
            return;
        }
        boolean shouldMeter = false;
        try {
            try {
                AgentShim.setThreadInAgentCode(tl);
                shouldMeter = this.com_wily_shouldMeterThisCall();
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception recording write(int) to file output stream", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            AgentShim.clearThreadInAgentCode(tl);
            throw throwable;
        }
        {
            var6_13 = null;
        }
        AgentShim.clearThreadInAgentCode(tl);
        {
            super.write(b);
            AgentShim.setThreadInAgentCode(tl);
            try {
                if (shouldMeter) {
                    sFileOutputRate.IIntegerRateDataAccumulator_addSingleIncident(this.com_wily_getBlameStackSnapshot());
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception recording write(int) to file output stream", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
            }
            var6_13 = null;
        }
        try {
            if (shouldMeter) {
                this.com_wily_doneMeteringThisCall();
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception recording write(int) to file output stream", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        AgentShim.clearThreadInAgentCode(tl);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(byte[] b) throws IOException {
        Object var6_13;
        Object tl = AgentShim.getAgentShimThreadLocal();
        if (AgentShim.isThreadInAgentCode(tl)) {
            super.write(b);
            return;
        }
        boolean shouldMeter = false;
        try {
            try {
                AgentShim.setThreadInAgentCode(tl);
                shouldMeter = this.com_wily_shouldMeterThisCall();
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception recording write(byte[]) to file output stream", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            AgentShim.clearThreadInAgentCode(tl);
            throw throwable;
        }
        {
            var6_13 = null;
        }
        AgentShim.clearThreadInAgentCode(tl);
        {
            super.write(b);
            AgentShim.setThreadInAgentCode(tl);
            try {
                if (shouldMeter) {
                    sFileOutputRate.IIntegerRateDataAccumulator_addBatchIncidents(b.length, this.com_wily_getBlameStackSnapshot());
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception recording write(byte[]) to file output stream", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
            }
            var6_13 = null;
        }
        try {
            if (shouldMeter) {
                this.com_wily_doneMeteringThisCall();
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception recording write(byte[]) to file output stream", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        AgentShim.clearThreadInAgentCode(tl);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(byte[] b, int offset, int len) throws IOException {
        Object var8_15;
        Object tl = AgentShim.getAgentShimThreadLocal();
        if (AgentShim.isThreadInAgentCode(tl)) {
            super.write(b, offset, len);
            return;
        }
        boolean shouldMeter = false;
        try {
            try {
                AgentShim.setThreadInAgentCode(tl);
                shouldMeter = this.com_wily_shouldMeterThisCall();
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception recording write(byte[],int,int) to file output stream", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {
                }
            }
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            AgentShim.clearThreadInAgentCode(tl);
            throw throwable;
        }
        {
            var8_15 = null;
        }
        AgentShim.clearThreadInAgentCode(tl);
        {
            super.write(b, offset, len);
            AgentShim.setThreadInAgentCode(tl);
            try {
                if (shouldMeter) {
                    sFileOutputRate.IIntegerRateDataAccumulator_addBatchIncidents(len, this.com_wily_getBlameStackSnapshot());
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    AgentShim.handleError("Exception recording write(byte[],int,int) to file output stream", t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
            }
            var8_15 = null;
        }
        try {
            if (shouldMeter) {
                this.com_wily_doneMeteringThisCall();
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError("Exception recording write(byte[],int,int) to file output stream", t);
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Throwable throwable) {}
        }
        AgentShim.clearThreadInAgentCode(tl);
    }

    private final BlameStackSnapshot com_wily_getBlameStackSnapshot() {
        if (sHasNewConfiguration) {
            return BlameStackSnapshot.kEmptyBlameStackSnapshot;
        }
        try {
            ComponentTracer componentTracer = AgentShim.getAgent().IAgent_getComponentTracer();
            if (componentTracer != null) {
                return componentTracer.getSnapshot(ComponentTracer.kNoComponent);
            }
        }
        catch (AgentNotAvailableException anae) {
            AgentShim.handleError("Unable to access component tracer", anae);
        }
        return BlameStackSnapshot.kEmptyBlameStackSnapshot;
    }

    private final boolean com_wily_shouldMeterThisCall() {
        boolean shouldMeter;
        boolean bl = shouldMeter = sFileOutputRate != null;
        if (shouldMeter) {
            boolean bl2 = shouldMeter = this.fIsWriting.get() != Boolean.TRUE;
            if (shouldMeter) {
                AgentMetric metric = sFileOutputRate.IDataAccumulator_getMetric();
                boolean bl3 = shouldMeter = !sAgent.IAgent_isMetricShutOff(metric);
                if (shouldMeter) {
                    this.fIsWriting.set(Boolean.TRUE);
                }
            }
        }
        return shouldMeter;
    }

    private final void com_wily_doneMeteringThisCall() {
        Assertion.wilyAssert(false);
        this.fIsWriting.set(Boolean.FALSE);
    }

    public static void setInWilyCallInThread() {
        fIsInWilyCall.set(Boolean.TRUE);
    }

    public static void unsetInWilyCallInThread() {
        fIsInWilyCall.set(Boolean.FALSE);
    }

    public static boolean isInWilyCallInThread() {
        Object o = fIsInWilyCall.get();
        return Boolean.TRUE == o;
    }

    private static final class FileOutputStreamMetricListener
    implements IMetricAgedListener {
        private FileOutputStreamMetricListener() {
        }

        public void IMetricRecordingListener_metricIsShutOff(AgentMetric metric) {
        }

        public void IMetricRecordingListener_metricIsTurnedOn(AgentMetric metric) {
        }

        public void IMetricAgedListener_metricIsAged(AgentMetric metric) {
            try {
                sAgent = AgentShim.getAgent();
                if (sAgent != null) {
                    sFileOutputRate = ManagedFileOutputStream.createAccumulator(sAgent);
                    AgentMetric accmetric = sFileOutputRate.IDataAccumulator_getMetric();
                    sAgent.IAgent_getMetricRecordingAdministrator().addMetricRecordingListenerWithRewind(accmetric, new FileOutputStreamMetricListener());
                }
            }
            catch (AgentNotAvailableException agentNotAvailableException) {}
        }
    }
}

