/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.remote.arf;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.remote.arf.ArfCommandConnection;
import com.wily.introscope.agent.remote.arf.ArfException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;

public class TcpArfCommandConnection
extends ArfCommandConnection {
    private PrintWriter fOut;
    private BufferedReader fIn;
    private Socket fSocket;

    public TcpArfCommandConnection(IAgent agent, Socket socket, BufferedReader input, String connMsg) throws ArfException, IOException {
        super(agent, connMsg);
        this.fSocket = socket;
        InetAddress addr = this.fSocket.getInetAddress();
        this.fHost = addr.getHostAddress();
        this.fIpAddr = addr.getHostName();
        this.fOut = new PrintWriter(socket.getOutputStream(), true);
        this.fIn = input;
        if (this.fIn == null) {
            this.fIn = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        }
    }

    public TcpArfCommandConnection(IAgent agent, Socket socket) throws IOException {
        super(agent);
        this.fOut = new PrintWriter(socket.getOutputStream(), true);
        this.fIn = new BufferedReader(new InputStreamReader(socket.getInputStream()));
    }

    protected String waitForNextMessage() {
        try {
            return this.fIn.readLine();
        }
        catch (IOException e) {
            if (this.fListener != null) {
                this.fListener.processMessageError(this, null, new ArfException(e.getMessage()));
            }
            this.close();
            return null;
        }
    }

    protected void writeToTransport(String message) {
        if (this.fOut != null) {
            this.fOut.print(String.valueOf(message) + "\n");
            this.fOut.flush();
        }
    }

    public String toString() {
        return "TcpArfCommandConnection " + (this.isClient() ? "Client" : "Server");
    }

    protected void closeConnection() {
        try {
            if (this.fOut != null) {
                this.fOut.close();
            }
            if (this.fSocket != null) {
                this.fSocket.close();
            }
        }
        catch (IOException iOException) {}
        this.fIn = null;
        this.fOut = null;
        this.fSocket = null;
    }
}

