/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.agent.main.IIntelligentInstrumentationTracerHelper;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.extension.DuplicateDynamicClassException;
import com.wily.introscope.agent.extension.InvalidDynamicClassException;
import com.wily.introscope.agent.remote.IRemoteTracedObject;
import com.wily.introscope.agent.sustainability.ISustainabilityService;
import com.wily.introscope.agent.sustainability.ISustainabilityServiceTrace;
import com.wily.introscope.agent.trace.EmptyMethodTracer;
import com.wily.introscope.agent.trace.IMethodTracer;
import com.wily.introscope.agent.trace.IMetricNameFormatListener;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.IParameterizedMethodTracer;
import com.wily.introscope.agent.trace.IProbeInformationCreator;
import com.wily.introscope.agent.trace.ITraceSupportFactory;
import com.wily.introscope.agent.trace.ITracerFactory;
import com.wily.introscope.agent.trace.IWallClockDelegate;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.NameFormatterLoader;
import com.wily.introscope.agent.trace.NameFormatterOSGiLoader;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.ProbeLookup;
import com.wily.introscope.agent.trace.TraceSupportFactoryLoader;
import com.wily.introscope.agent.trace.TracerFactoryLoader;
import com.wily.introscope.agent.trace.TracerFactoryOSGiLoader;
import com.wily.util.classfile.IMethodSignature;
import com.wily.util.classfile.InvalidMethodDescriptorException;
import com.wily.util.classfile.NameUtilities;
import com.wily.util.classfile.NativeClassSchemaPolicy;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public final class TracerAdministrator {
    private volatile ISustainabilityService fService;
    private volatile IIntelligentInstrumentationTracerHelper fIntelligentInstrumentationService;
    private static final ITracerFactory[] kTracerFactoryEmptyArray = new ITracerFactory[0];
    private static final InvocationHandler sNoOpHandler = new NoOpInvocationHandler();
    private static final IMethodTracer sNoOpMethodTracer;
    private static final IParameterizedMethodTracer sNoOpParameterizedTracer;
    private final IAgent fAgent;
    private final ProbeLookup fProbeLookup;
    private final TracerFactoryOSGiLoader fTracerFactoryOSGiLoader;
    private final NameFormatterOSGiLoader fNameFormatterOSGiLoader;
    private final TracerFactoryLoader fTracerFactoryLoader;
    private final NameFormatterLoader fNameFormatterLoader;
    private final TraceSupportFactoryLoader fTraceSupportFactoryLoader;
    private final Map fMethodDescriptorCache;
    private final ComponentTracer fComponentTracer;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.wily.introscope.agent.trace.IMethodTracer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassLoader classLoader = clazz.getClassLoader();
        Class[] classArray = new Class[1];
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.wily.introscope.agent.trace.IMethodTracer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        sNoOpMethodTracer = (IMethodTracer)Proxy.newProxyInstance(classLoader, classArray, sNoOpHandler);
        sNoOpParameterizedTracer = new EmptyMethodTracer();
    }

    public TracerAdministrator(IAgent agent) {
        this.fAgent = agent;
        this.fComponentTracer = agent.IAgent_getComponentTracer();
        this.fMethodDescriptorCache = new HashMap();
        this.fProbeLookup = new ProbeLookup(new ProbeInformationCreator());
        this.fTracerFactoryLoader = new TracerFactoryLoader(agent);
        this.fNameFormatterLoader = new NameFormatterLoader(agent);
        this.fTraceSupportFactoryLoader = new TraceSupportFactoryLoader(agent);
        this.fTracerFactoryOSGiLoader = new TracerFactoryOSGiLoader(agent);
        this.fNameFormatterOSGiLoader = new NameFormatterOSGiLoader(agent);
        this.fTracerFactoryOSGiLoader.loadExtensions();
        this.fNameFormatterOSGiLoader.loadExtensions();
        this.fTracerFactoryLoader.addAllExtensions(this.fTracerFactoryOSGiLoader);
        this.fNameFormatterLoader.addAllExtensions(this.fNameFormatterOSGiLoader);
    }

    private IAgent getAgent() {
        return this.fAgent;
    }

    private IModuleFeedbackChannel getModuleFeedback() {
        return this.getAgent().IAgent_getModuleFeedback();
    }

    private IStringLocalizer getStringLocalizer() {
        return this.getAgent().IAgent_getStringLocalizer();
    }

    public final void registerNameFormatter(String nameFormatterName, Class nameFormatterClass, IStringLocalizer nameFormatterLocalizer) throws DuplicateDynamicClassException, InvalidDynamicClassException {
        this.fNameFormatterLoader.register(nameFormatterName, nameFormatterClass, nameFormatterLocalizer);
    }

    public final INameFormatter loadNameFormatter(String nameFormatterName) {
        return this.fNameFormatterLoader.loadNameFormatter(nameFormatterName);
    }

    public final ITraceSupportFactory loadTraceSupport(String tracerSupportName, String parameters) {
        ITraceSupportFactory result = null;
        try {
            return this.fTraceSupportFactoryLoader.createTracerSupportFactory(tracerSupportName, parameters);
        }
        catch (Exception e) {
            this.getModuleFeedback().verbose(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Tracer_Factory_Creation_Error_Message", tracerSupportName));
            this.getModuleFeedback().verbose(e);
            return result;
        }
    }

    public final ITraceSupportFactory loadTraceSupportOSGi(String tracerSupportName, String parameters) {
        ITraceSupportFactory result = null;
        try {
            return this.fTraceSupportFactoryLoader.createTracerSupportFactoryOSGi(this.fAgent, tracerSupportName, parameters);
        }
        catch (Exception e) {
            this.getModuleFeedback().verbose(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Tracer_Factory_Creation_Error_Message", tracerSupportName));
            this.getModuleFeedback().verbose(e);
            return result;
        }
    }

    public final void registerTracer(String tracerFactoryName, Class tracerFactoryClass, IStringLocalizer tracerFactoryLocalizer) throws DuplicateDynamicClassException, InvalidDynamicClassException {
        this.fTracerFactoryLoader.register(tracerFactoryName, tracerFactoryClass, tracerFactoryLocalizer);
    }

    public final IMethodTracer loadTracer(int probeHashCode, String probeClassName, String probeMethodName, String probeMethodDescriptor, Object tracedObject, String tracerEncoding) {
        if (this.fService != null) {
            ISustainabilityServiceTrace trace = this.fService.startSustainabilityTrace();
            Class<?> clazz = Thread.currentThread().getClass();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("com.wily.introscope.agent.AgentFactoryThread");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.equals(clazz2)) {
                return sNoOpMethodTracer;
            }
            ProbeInformation probeInfo = this.getProbeInformation(probeHashCode, probeClassName, probeMethodName, probeMethodDescriptor, tracedObject, tracerEncoding);
            InvocationData externalTracer = this.getExternalTracer(probeInfo, tracedObject);
            if (trace != null) {
                externalTracer.setSustainabilityTrace(trace);
            }
            if (this.fIntelligentInstrumentationService != null) {
                externalTracer.setIntelligentInstrumentationService(this.fIntelligentInstrumentationService, probeHashCode);
            }
            externalTracer.IMethodTracer_startTrace();
            return externalTracer;
        }
        Class<?> clazz = Thread.currentThread().getClass();
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("com.wily.introscope.agent.AgentFactoryThread");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz3)) {
            return sNoOpMethodTracer;
        }
        ProbeInformation probeInfo = this.getProbeInformation(probeHashCode, probeClassName, probeMethodName, probeMethodDescriptor, tracedObject, tracerEncoding);
        InvocationData externalTracer = this.getExternalTracer(probeInfo, tracedObject);
        if (this.fIntelligentInstrumentationService != null) {
            externalTracer.setIntelligentInstrumentationService(this.fIntelligentInstrumentationService, probeHashCode);
        }
        externalTracer.IMethodTracer_startTrace();
        return externalTracer;
    }

    public IMethodTracer loadTracer(int probeHashCode, String probeClassName, String probeMethodName, String probeMethodDescriptor, Object tracedObject, String tracerEncoding, IWallClockDelegate delegateClock) {
        Class<?> clazz = Thread.currentThread().getClass();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("com.wily.introscope.agent.AgentFactoryThread");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            return sNoOpMethodTracer;
        }
        ProbeInformation probeInfo = this.getProbeInformation(probeHashCode, probeClassName, probeMethodName, probeMethodDescriptor, tracedObject, tracerEncoding);
        InvocationData externalTracer = this.getExternalTracer(probeInfo, tracedObject, delegateClock);
        if (this.fIntelligentInstrumentationService != null) {
            externalTracer.setIntelligentInstrumentationService(this.fIntelligentInstrumentationService, probeHashCode);
        }
        externalTracer.IMethodTracer_startTrace();
        return externalTracer;
    }

    public IParameterizedMethodTracer loadParameterizedTracer(int probeHashCode, String probeClassName, String probeMethodName, String probeMethodDescriptor, Object tracedObject, String tracerEncoding) {
        if (this.fService != null) {
            ISustainabilityServiceTrace trace = this.fService.startSustainabilityTrace();
            Class<?> clazz = Thread.currentThread().getClass();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("com.wily.introscope.agent.AgentFactoryThread");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz.equals(clazz2)) {
                return sNoOpParameterizedTracer;
            }
            ProbeInformation probeInfo = this.getProbeInformation(probeHashCode, probeClassName, probeMethodName, probeMethodDescriptor, tracedObject, tracerEncoding);
            InvocationData externalTracer = this.getExternalTracer(probeInfo, tracedObject);
            externalTracer.allocateSpaceForParameters(this.getClassFileMethodDescriptor(probeMethodDescriptor));
            if (trace != null) {
                externalTracer.setSustainabilityTrace(trace);
            }
            if (this.fIntelligentInstrumentationService != null) {
                externalTracer.setIntelligentInstrumentationService(this.fIntelligentInstrumentationService, probeHashCode);
            }
            return externalTracer;
        }
        Class<?> clazz = Thread.currentThread().getClass();
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("com.wily.introscope.agent.AgentFactoryThread");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz3)) {
            return sNoOpParameterizedTracer;
        }
        ProbeInformation probeInfo = this.getProbeInformation(probeHashCode, probeClassName, probeMethodName, probeMethodDescriptor, tracedObject, tracerEncoding);
        InvocationData externalTracer = this.getExternalTracer(probeInfo, tracedObject);
        externalTracer.allocateSpaceForParameters(this.getClassFileMethodDescriptor(probeMethodDescriptor));
        if (this.fIntelligentInstrumentationService != null) {
            externalTracer.setIntelligentInstrumentationService(this.fIntelligentInstrumentationService, probeHashCode);
        }
        return externalTracer;
    }

    private String getRuntimeFullClassName(String probeClassName, Object tracedObject) {
        if (tracedObject != null && !(tracedObject instanceof IRemoteTracedObject)) {
            return NameUtilities.getFullClassName(tracedObject);
        }
        return probeClassName;
    }

    private ProbeInformation getProbeInformation(int probeHashCode, String probeClassName, String probeMethodName, String probeMethodDescriptor, Object tracedObject, String tracerEncoding) {
        String runtimeFullClassName = this.getRuntimeFullClassName(probeClassName, tracedObject);
        return this.fProbeLookup.getProbeInformation(probeHashCode, probeClassName, probeMethodName, probeMethodDescriptor, runtimeFullClassName, tracedObject, tracerEncoding);
    }

    private ProbeInformation createProbeInformation(String probeClassName, String probeMethodName, String probeMethodDescriptor, String runtimeFullClassName, Object tracedObject, String tracerEncoding) {
        ProbeIdentification identification = new ProbeIdentification(probeClassName, probeMethodName, probeMethodDescriptor, runtimeFullClassName);
        ITracerFactory[] tracerFactories = this.createTracerFactories(tracerEncoding, identification, tracedObject);
        return new ProbeInformation(this.fAgent, identification, tracerFactories);
    }

    private ITracerFactory[] createTracerFactories(String tracerEncoding, ProbeIdentification identification, Object tracedObject) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(tracerEncoding, ",");
            Assertion.wilyAssert(false);
            int tokenCount = tokenizer.countTokens();
            Assertion.wilyAssert(false);
            ITracerFactory[] tracerFactories = new ITracerFactory[tokenCount / 2];
            IMetricNameFormatListener[] tracerFactoriesListeners = null;
            boolean hasListeners = false;
            int i = 0;
            while (i < tracerFactories.length) {
                String factoryClassName = tokenizer.nextToken();
                String parameters = tokenizer.nextToken();
                tracerFactories[i] = this.fTracerFactoryLoader.createTracerFactory(factoryClassName, parameters, identification, tracedObject);
                if (tracerFactories[i] != null && tracerFactories[i] instanceof IMetricNameFormatListener) {
                    hasListeners = true;
                    if (tracerFactoriesListeners == null) {
                        tracerFactoriesListeners = new IMetricNameFormatListener[tokenCount / 2];
                    }
                    tracerFactoriesListeners[i] = (IMetricNameFormatListener)((Object)tracerFactories[i]);
                }
                ++i;
            }
            if (hasListeners) {
                i = 0;
                while (i < tracerFactoriesListeners.length) {
                    if (tracerFactoriesListeners[i] != null) {
                        int j = 0;
                        while (j < tracerFactories.length) {
                            if (j != i) {
                                tracerFactories[j].ITracerFactory_addMetricNameFormatListener((IMetricNameFormatListener)tracerFactoriesListeners[i]);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            return tracerFactories;
        }
        catch (Exception e) {
            this.getModuleFeedback().verbose(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Tracer_Factory_Creation_Error_Message", tracerEncoding));
            this.getModuleFeedback().verbose(e);
            e.printStackTrace();
            return kTracerFactoryEmptyArray;
        }
    }

    private InvocationData getExternalTracer(ProbeInformation probeInfo, Object tracedObject) {
        return probeInfo.getExternalTracer(this.getAgent(), tracedObject, this.fComponentTracer.isAgentOldMode());
    }

    private InvocationData getExternalTracer(ProbeInformation probeInfo, Object tracedObject, IWallClockDelegate delegateClock) {
        InvocationData result = new InvocationData(this.getAgent(), probeInfo, tracedObject, false, delegateClock);
        result.setContainsFrontendTracer(false);
        result.initializeForTransactionElements(this.getAgent().IAgent_getComponentTracer().isAgentOldMode(), probeInfo.hasSandwich());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IMethodSignature getClassFileMethodDescriptor(String probeMethodDescriptor) {
        IMethodSignature result = (IMethodSignature)this.fMethodDescriptorCache.get(probeMethodDescriptor);
        if (result == null) {
            Map map = this.fMethodDescriptorCache;
            synchronized (map) {
                result = (IMethodSignature)this.fMethodDescriptorCache.get(probeMethodDescriptor);
                if (result == null) {
                    try {
                        result = NativeClassSchemaPolicy.getNativeClassSchemaPolicy().getMethodSignature(probeMethodDescriptor);
                        this.fMethodDescriptorCache.put(probeMethodDescriptor, result);
                    }
                    catch (InvalidMethodDescriptorException invalidMethodDescriptorException) {
                        Assertion.wilyFail("Tracing invalid descriptor: " + probeMethodDescriptor);
                    }
                }
            }
        }
        return result;
    }

    public void setService(ISustainabilityService sustainabilityService) {
        this.fService = sustainabilityService;
    }

    public void setIntelligentInstrumentationService(IIntelligentInstrumentationTracerHelper service) {
        this.fIntelligentInstrumentationService = service;
    }

    public IIntelligentInstrumentationTracerHelper getIntelligentInstrumentationService() {
        return this.fIntelligentInstrumentationService;
    }

    private static final class NoOpInvocationHandler
    implements InvocationHandler {
        private NoOpInvocationHandler() {
        }

        public Object invoke(Object proxy, Method method, Object[] args) {
            return null;
        }
    }

    private final class ProbeInformationCreator
    implements IProbeInformationCreator {
        private ProbeInformationCreator() {
        }

        public ProbeInformation IProbeInformationCreator_createProbeInformation(String probeClassName, String probeMethodName, String probeMethodDescriptor, String runtimeFullClassName, Object tracedObject, String tracerEncoding) {
            return TracerAdministrator.this.createProbeInformation(probeClassName, probeMethodName, probeMethodDescriptor, runtimeFullClassName, tracedObject, tracerEncoding);
        }
    }
}

