/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.transformer.dynamic;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.transformer.dynamic.IClassRedefinitionCallback;
import com.wily.introscope.agent.transformer.dynamic.IDeepInheritanceHelper;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationDelegate;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationService;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.introscope.agent.transformer.dynamic.IRedefinitionCallback;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.DynamicDirectivesResult;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.DynamicInstrumentationResult;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.GroupInstrumentationInfoResult;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.IDynamicInstrumentationListener;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.InstrumentationInfo;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.InstrumentationInfoResult;
import com.wily.introscope.spec.agent.beans.dynamicinstrumentation.MethodCallsResult;
import com.wily.introscope.spec.server.beans.dynamicinstrumentationtrace.UnsupportedDIOperationException;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.java.ClassName;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.io.ByteArrayInputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ADynamicInstrumentationService
implements IDynamicInstrumentationService {
    private static final String kDefaultVerboseCause = "Dynamic instrumentation extension is not loaded in agent";
    private static final String kModulename = "ADynamicInstrumentationService";
    private static final String kRemoteAgentDynamicInstrumentationEnabledKey = "introscope.agent.remoteagentdynamicinstrumentation.enabled";
    private IDynamicInstrumentationDelegate fServiceDelegate;
    private IDynamicInstrumentationTransformer fTransformer;
    private IAgent fAgent;
    private IModuleFeedbackChannel fLog;
    private Module kModule = new Module("ADynamicInstrumentationService");
    private boolean isInitialized = false;
    private boolean fIsBusy = false;
    private boolean fCanRun = true;
    private int fDIStatus = -1;
    private boolean fForceBroadcast;
    private String fDatabaseName;
    private IDeepInheritanceHelper fDeepInheritanceHelper;

    private synchronized boolean checkInitialized() {
        if (this.fServiceDelegate == null || !this.fCanRun) {
            return false;
        }
        if (!this.isInitialized) {
            this.isInitialized = this.fServiceDelegate.initialize(this.fTransformer);
            if (this.isInitialized) {
                this.resetStatus();
            }
        }
        return this.isInitialized;
    }

    private synchronized boolean checkBusy(boolean toggleBusy) {
        boolean result = this.fIsBusy;
        if (toggleBusy) {
            this.fLog.trace(this.kModule, "Setting status busy");
            this.fIsBusy = true;
            this.fForceBroadcast = true;
            this.resetStatus();
        }
        return result;
    }

    private synchronized void unBusy() {
        this.fLog.info(this.kModule, "Setting status unbusy");
        this.fIsBusy = false;
        this.fForceBroadcast = true;
        this.resetStatus();
    }

    public ADynamicInstrumentationService(IAgent agent, IDynamicInstrumentationTransformer transformer, IModuleFeedbackChannel log) {
        this.fAgent = agent;
        this.fTransformer = transformer;
        this.fLog = log;
    }

    public DynamicInstrumentationResult getMethodCalls(String metric) {
        if (this.checkInitialized()) {
            return this.fServiceDelegate.getMethodCalls(metric);
        }
        return this.getNotAvailableDynamicInstrumentationResult();
    }

    public IDynamicInstrumentationService getDynamicInstrumentationService() {
        return this;
    }

    public DynamicDirectivesResult getDynamicDirectiveCollection() {
        if (this.checkInitialized()) {
            return this.fServiceDelegate.getDynamicDirectiveCollection();
        }
        return this.getNotAvailableDynamicDirectivesResult();
    }

    public DynamicDirectivesResult getDynamicDirectiveCollectionByLabel(String label) {
        if (this.checkInitialized()) {
            return this.fServiceDelegate.getDynamicDirectiveCollectionByLabel(label);
        }
        return this.getNotAvailableDynamicDirectivesResult();
    }

    public DynamicDirectivesResult getDynamicDirectiveById(int id) {
        if (this.checkInitialized()) {
            return this.fServiceDelegate.getDynamicDirectiveById(id);
        }
        return this.getNotAvailableDynamicDirectivesResult();
    }

    private DynamicDirectivesResult getNotAvailableDynamicDirectivesResult() {
        DynamicDirectivesResult result = new DynamicDirectivesResult();
        result.setStatus(106);
        result.setVerboseCause(kDefaultVerboseCause);
        return result;
    }

    public DynamicDirectivesResult setDynamicDirectiveStatus(int id, int status) {
        if (this.checkInitialized()) {
            return this.fServiceDelegate.setDynamicDirectiveStatus(id, status);
        }
        return this.getNotAvailableDynamicDirectivesResult();
    }

    public InstrumentationInfoResult getInstrumentationInfo(IClassName classPattern, IMethodName methodPattern, boolean alsoInactive) {
        if (this.checkInitialized()) {
            return this.fServiceDelegate.getInstrumentationInfo(classPattern, methodPattern, alsoInactive);
        }
        return this.getNotAvailableInstrumentationInfoResult();
    }

    public InstrumentationInfoResult getInstrumentationInfo(boolean alsoInactive) {
        if (this.checkInitialized()) {
            return this.fServiceDelegate.getInstrumentationInfo(alsoInactive);
        }
        return this.getNotAvailableInstrumentationInfoResult();
    }

    public InstrumentationInfoResult getInstrumentationInfoByGroup(String group, boolean alsoInactive) {
        if (this.checkInitialized()) {
            return this.fServiceDelegate.getInstrumentationInfoByGroup(group, alsoInactive);
        }
        return this.getNotAvailableInstrumentationInfoResult();
    }

    public InstrumentationInfoResult getInstrumentationInfoByLabel(String label, boolean alsoInactive) {
        if (this.checkInitialized()) {
            return this.fServiceDelegate.getInstrumentationInfoByLabel(label, alsoInactive);
        }
        return this.getNotAvailableInstrumentationInfoResult();
    }

    private boolean redefineClass(IClassName className, IClassRedefinitionCallback callback, boolean redefineTree) {
        if (redefineTree) {
            boolean result = this.fTransformer.redefineClassTree(className, callback, true);
            this.fLog.info(this.kModule, "Dynamic instrumentation of class tree rooted on " + className + " done successfully: " + result);
            return result;
        }
        boolean result = this.fTransformer.redefineClass(className, callback);
        this.fLog.info(this.kModule, "Dynamic instrumentation of class " + className + " done successfully: " + result);
        return result;
    }

    private boolean redefineGroup(final String groupName) {
        boolean result = this.fTransformer.redefineGroup(new IRedefinitionCallback(){

            public void executeOnComplete(boolean success) {
                if (success) {
                    ADynamicInstrumentationService.this.fLog.debug(ADynamicInstrumentationService.this.kModule, "Dynamic instrumentation of group " + groupName + " done successfully");
                } else {
                    ADynamicInstrumentationService.this.fLog.warn(ADynamicInstrumentationService.this.kModule, "Could not dynamically instrumentat group " + groupName);
                }
                ADynamicInstrumentationService.this.unBusy();
            }
        }, groupName, this.fServiceDelegate);
        return result;
    }

    public void addServiceDelegate(IDynamicInstrumentationDelegate service) {
        this.fServiceDelegate = service;
    }

    public DynamicInstrumentationResult cleanTransientData(IClassName className, IMethodName methodName) {
        if (this.checkInitialized()) {
            return this.fServiceDelegate.cleanTransientData(className, methodName);
        }
        return this.getNotAvailableDynamicInstrumentationResult();
    }

    public DynamicInstrumentationResult cleanTransientClassData(IClassName className) {
        if (this.checkInitialized()) {
            return this.fServiceDelegate.cleanTransientClassData(className);
        }
        return this.getNotAvailableDynamicInstrumentationResult();
    }

    private DynamicInstrumentationResult getNotAvailableDynamicInstrumentationResult() {
        return new DynamicInstrumentationResult(106).setVerboseCause(kDefaultVerboseCause);
    }

    private MethodCallsResult getNotAvailableMethodCallsResult() {
        MethodCallsResult result = new MethodCallsResult(106);
        result.setVerboseCause(kDefaultVerboseCause);
        return result;
    }

    public DynamicInstrumentationResult getAvailableTracers(IClassName className, IMethodName methodName) {
        return new DynamicInstrumentationResult(105);
    }

    public DynamicInstrumentationResult isActive() {
        if (this.checkInitialized()) {
            return this.fServiceDelegate.isActive();
        }
        return this.getNotAvailableDynamicInstrumentationResult();
    }

    public MethodCallsResult getMethodCalls(IClassName className, IMethodName methodName) {
        if (this.checkInitialized()) {
            return this.fServiceDelegate.getMethodCalls(className, methodName);
        }
        return this.getNotAvailableMethodCallsResult();
    }

    public InstrumentationInfoResult addInstrumentation(IClassName className, IMethodName methodName, String resourceName, String tracerType, String groupName, int status, int type, IClassName callingClassName, IMethodName callingMethodName) {
        return this.addInstrumentation(className, methodName, this.getTemporaryLabel(), resourceName, tracerType, groupName, status, type, callingClassName, callingMethodName);
    }

    private String getTemporaryLabel() {
        return "@Temporary Label Prefix@";
    }

    public InstrumentationInfoResult addInstrumentation(final IClassName className, final IMethodName methodName, final String labelName, final String resourceName, final String tracerType, final String groupName, final int status, int type, final IClassName callingClassName, final IMethodName callingMethodName) {
        if (this.checkInitialized()) {
            final InstrumentationInfoResult result = this.fServiceDelegate.addInstrumentation(className, methodName, labelName, resourceName, tracerType, groupName, status, type, callingClassName, callingMethodName);
            this.fLog.debug(this.kModule, "Adding dynamic instrumentation " + resourceName + " in class " + className + " and method " + methodName);
            if (!result.isError()) {
                boolean redefineTree;
                boolean bl = redefineTree = type == 3 || type == 5;
                if (type == 5 || type == 4) {
                    IClassRedefinitionCallback callbackOnCallingClassRedefinition = new IClassRedefinitionCallback(){

                        public void executeOnRedefinition(Class redefinedClass, ByteArrayInputStream stream) {
                            ADynamicInstrumentationService.this.fServiceDelegate.executeOnRedefinition(redefinedClass, stream);
                            ADynamicInstrumentationService.this.fLog.debug(ADynamicInstrumentationService.this.kModule, "Added conditional anchor in class " + callingClassName + " and method " + callingMethodName);
                        }

                        public void executeOnUnsupportedOperation(UnsupportedDIOperationException exception, Class candidate, ByteArrayInputStream stream) {
                            ADynamicInstrumentationService.this.fLog.debug(ADynamicInstrumentationService.this.kModule, "Unable to added conditional anchor in class " + callingClassName + " and method " + callingMethodName);
                            result.setStatus(117);
                            result.setException(exception);
                        }
                    };
                    this.redefine(callingClassName, callingMethodName, result, callbackOnCallingClassRedefinition, false);
                }
                if (!result.isError()) {
                    IClassRedefinitionCallback callback = new IClassRedefinitionCallback(){

                        public void executeOnRedefinition(Class redefinedClass, ByteArrayInputStream stream) {
                            ADynamicInstrumentationService.this.fServiceDelegate.executeOnRedefinition(redefinedClass, stream);
                            if (!redefinedClass.getName().equals(className.getReflectionFriendlyQualifiedNameString())) {
                                try {
                                    ClassName redefinedClassName = ClassName.getClassName(redefinedClass.getName());
                                    ADynamicInstrumentationService.this.fServiceDelegate.addInstrumentation(redefinedClassName, methodName, labelName, resourceName, tracerType, groupName, status, 2, callingClassName, callingMethodName);
                                    ADynamicInstrumentationService.this.fLog.debug(ADynamicInstrumentationService.this.kModule, "Added implicit dynamic instrumentation " + resourceName + " in class " + className + " and method " + methodName);
                                }
                                catch (InvalidClassNameException invalidClassNameException) {}
                            }
                        }

                        public void executeOnUnsupportedOperation(UnsupportedDIOperationException exception, Class candidate, ByteArrayInputStream stream) {
                            result.setStatus(117);
                            result.setException(exception);
                        }
                    };
                    this.redefine(className, methodName, result, callback, redefineTree);
                }
            }
            this.resetStatus();
            return result;
        }
        return this.getNotAvailableInstrumentationInfoResult();
    }

    private InstrumentationInfoResult getNotAvailableInstrumentationInfoResult() {
        InstrumentationInfoResult result = new InstrumentationInfoResult(106);
        result.setVerboseCause(kDefaultVerboseCause);
        return result;
    }

    private void resetStatus() {
        if (this.fCanRun && this.isInitialized && this.isEnabled()) {
            this.fLog.trace(this.kModule, "resetting status to -2");
            this.fDIStatus = -2;
        } else {
            this.fLog.trace(this.kModule, "resetting status to -1");
            this.fDIStatus = -1;
        }
    }

    public InstrumentationInfoResult removeInstrumentation(final IClassName className, final IMethodName methodName, final String resourceName, final String tracerType, final String groupName, final boolean redefineTree) {
        if (this.checkInitialized()) {
            final InstrumentationInfoResult result = this.fServiceDelegate.removeInstrumentation(className, methodName, resourceName, tracerType, groupName, redefineTree);
            this.fLog.debug(this.kModule, "Removed dynamic instrumentation " + resourceName + " in class " + className + " and method " + methodName);
            IClassRedefinitionCallback callback = new IClassRedefinitionCallback(){

                public void executeOnRedefinition(Class redefinedClass, ByteArrayInputStream stream) {
                    this.redefineAndCleanup(className, methodName, resourceName, tracerType, groupName, redefineTree, result, redefinedClass, stream);
                }

                public void executeOnUnsupportedOperation(UnsupportedDIOperationException exception, Class candidate, ByteArrayInputStream stream) {
                    this.redefineAndCleanup(className, methodName, resourceName, tracerType, groupName, redefineTree, result, candidate, stream);
                }

                private void redefineAndCleanup(IClassName className2, IMethodName methodName2, String resourceName2, String tracerType2, String groupName2, boolean redefineTree2, InstrumentationInfoResult result2, Class redefinedClass, ByteArrayInputStream stream) {
                    ADynamicInstrumentationService.this.fServiceDelegate.executeOnRedefinition(redefinedClass, stream);
                    try {
                        Map instrumentationInfos;
                        List infosForGroup;
                        ClassName redefinedClassName = ClassName.getClassName(redefinedClass.getName());
                        if (!redefinedClass.getName().equals(className2.getReflectionFriendlyQualifiedNameString())) {
                            ADynamicInstrumentationService.this.fServiceDelegate.removeInstrumentation(redefinedClassName, methodName2, resourceName2, tracerType2, groupName2, redefineTree2);
                            ADynamicInstrumentationService.this.fLog.debug(ADynamicInstrumentationService.this.kModule, "Removed dynamic instrumentation " + resourceName2 + " in class " + className2 + " and method " + methodName2);
                        }
                        if ((infosForGroup = (List)(instrumentationInfos = result2.getIntrumentationInfo()).get(groupName2)) != null) {
                            Iterator i = infosForGroup.iterator();
                            while (i.hasNext()) {
                                InstrumentationInfo info = (InstrumentationInfo)i.next();
                                if (!info.getClassName().equals(redefinedClassName.getContainerAndPackageAndNameString()) || !info.getMethodName().equals(methodName2.getNameAndSignatureString()) || !info.getResourceName().equals(resourceName2) || !info.getTracerType().equals(tracerType2) || !info.isPermanent()) continue;
                                ADynamicInstrumentationService.this.fLog.debug("Marking instrumentation for class " + info.getClassName() + " and method " + info.getMethodName() + " and resource " + info.getResourceName() + " not permanent");
                                info.setPermanent(false);
                            }
                        }
                    }
                    catch (InvalidClassNameException invalidClassNameException) {}
                }
            };
            this.redefine(className, methodName, result, callback, redefineTree);
            this.resetStatus();
            return result;
        }
        return this.getNotAvailableInstrumentationInfoResult();
    }

    private void redefine(IClassName className, IMethodName methodName, InstrumentationInfoResult result, IClassRedefinitionCallback callback, boolean redefineTree) {
        InstrumentationInfo info = null;
        try {
            info = (InstrumentationInfo)result.getInstrumentationInfos().get(0);
        }
        catch (Exception exception) {}
        this.redefine(className, methodName, result, info, callback, redefineTree);
    }

    private void redefine(IClassName className, IMethodName methodName, InstrumentationInfoResult result, InstrumentationInfo info, IClassRedefinitionCallback callback, boolean redefineTree) {
        DynamicInstrumentationResult resultOfCleanup = null;
        if (!result.isError()) {
            resultOfCleanup = this.fServiceDelegate.cleanTransientData(className, methodName);
            if (!resultOfCleanup.isError()) {
                if (!this.redefineClass(className, callback, redefineTree)) {
                    int status = result.getStatus();
                    if (status != 117) {
                        result.setStatus(104);
                    }
                    if (info != null) {
                        try {
                            int lineNumber = info.getLineNumber();
                            this.fServiceDelegate.setDynamicDirectiveInactive(lineNumber);
                        }
                        catch (Exception exception) {}
                    }
                }
            } else {
                result.importAll(resultOfCleanup);
            }
        }
    }

    public void setNotInitialized() {
        if (this.fServiceDelegate != null) {
            this.fServiceDelegate.setNotInitialized();
        }
        this.fCanRun = false;
        this.fDIStatus = 0;
        this.forceBroadcast();
    }

    public int getDynamicInstrumentationStatusCode(boolean refresh) {
        if (!refresh) {
            return this.fDIStatus;
        }
        this.fDIStatus = this.fCanRun && this.isInitialized && this.isEnabled() ? this.fServiceDelegate.getDynamicInstrumentationStatusCode(refresh) : (!this.fCanRun || !this.isEnabled() ? 0 : -1);
        if (this.checkBusy(false)) {
            this.fDIStatus |= 0x100;
        }
        return this.fDIStatus;
    }

    public void setRepositoryName(String name) {
        this.fDatabaseName = name;
    }

    public String getRepositoryName() {
        return this.safeName(this.fDatabaseName);
    }

    public void getDynamicInstrumentationPBD(IDynamicInstrumentationListener listener, String label, boolean permanentOnly) {
        if (this.checkInitialized()) {
            this.fTransformer.getDynamicInstrumentationPBD(listener, label, permanentOnly);
        } else {
            listener.deliverResult(this.getNotAvailableDynamicDirectivesResult());
        }
    }

    public InstrumentationInfoResult makePermanent(String labelName) {
        if (this.checkInitialized()) {
            InstrumentationInfoResult makePermResult = this.fServiceDelegate.makePermanent(labelName);
            Iterator i = makePermResult.getInstrumentationInfos().iterator();
            while (i.hasNext()) {
                InstrumentationInfo info = (InstrumentationInfo)i.next();
                IClassName classToRedefine = this.fServiceDelegate.getClassName(info.getClassName());
                IMethodName methodToRedefine = this.fServiceDelegate.getMethodName(info.getMethodName());
                if (classToRedefine != null && methodToRedefine != null) {
                    this.redefine(classToRedefine, methodToRedefine, makePermResult, this.fServiceDelegate, info.isAffectingClassTree());
                } else {
                    makePermResult.setStatus(108);
                    makePermResult.setVerboseCause(info.getClassName());
                }
                if (makePermResult.isError()) break;
            }
            return makePermResult;
        }
        return this.getNotAvailableInstrumentationInfoResult();
    }

    public InstrumentationInfoResult assignLabel(IClassName className, IMethodName methodName, String labelName, String resourceName, String tracerType, String groupName) {
        if (this.checkInitialized()) {
            InstrumentationInfoResult assignLabelResult = this.fServiceDelegate.assignLabel(className, methodName, labelName, resourceName, tracerType, groupName);
            if (!assignLabelResult.isError()) {
                Iterator i = assignLabelResult.getInstrumentationInfos().iterator();
                while (i.hasNext()) {
                    InstrumentationInfo info = (InstrumentationInfo)i.next();
                    if (!info.isActive()) continue;
                    IClassName classToRedefine = this.fServiceDelegate.getClassName(info.getClassName());
                    IMethodName methodToRedefine = this.fServiceDelegate.getMethodName(info.getMethodName());
                    if (classToRedefine != null && methodToRedefine != null) {
                        this.redefine(classToRedefine, methodToRedefine, assignLabelResult, this.fServiceDelegate, info.isAffectingClassTree());
                    } else {
                        assignLabelResult.setStatus(108);
                        assignLabelResult.setVerboseCause(info.getClassName());
                    }
                    if (assignLabelResult.isError()) break;
                }
            }
            return assignLabelResult;
        }
        return this.getNotAvailableInstrumentationInfoResult();
    }

    public DynamicInstrumentationResult createPermanentDirective(IClassName className, IMethodName methodName, String labelName, String resourceName, String tracerType, String groupName, IClassName callingClassName, IMethodName callingMethodName) {
        if (this.fServiceDelegate != null) {
            return this.fServiceDelegate.createPermanentDirective(className, methodName, labelName, resourceName, tracerType, groupName, callingClassName, callingMethodName);
        }
        return this.getNotAvailableDynamicInstrumentationResult();
    }

    public InstrumentationInfoResult removeTemporaryInstrumentation(int lineNumber, IClassName className, IMethodName methodName) {
        if (this.fServiceDelegate != null) {
            InstrumentationInfoResult result = this.fServiceDelegate.removeTemporaryInstrumentation(lineNumber, className, methodName);
            if (!result.isError()) {
                this.redefine(className, methodName, result, this.fServiceDelegate, true);
                this.resetStatus();
            }
            return result;
        }
        return this.getNotAvailableInstrumentationInfoResult();
    }

    public boolean isEnabled() {
        boolean isEnabled = this.fAgent.IAgent_getIndexedProperties().safeGetBooleanProperty(kRemoteAgentDynamicInstrumentationEnabledKey, false, this.fAgent.IAgent_getModuleFeedback(), this.fAgent.IAgent_getStringLocalizer());
        return isEnabled;
    }

    public GroupInstrumentationInfoResult getGroupsDirectives() {
        if (this.checkInitialized()) {
            return this.fServiceDelegate.getGroupsDirectives();
        }
        return this.getNotAvailableGroupInstrumentationInfoResult();
    }

    public GroupInstrumentationInfoResult makePermanentGroupDirectives() {
        if (this.checkInitialized()) {
            return this.fServiceDelegate.makePermanentGroupDirectives();
        }
        return this.getNotAvailableGroupInstrumentationInfoResult();
    }

    public GroupInstrumentationInfoResult createPermanentGroupDirective(String groupName, boolean isActive) {
        if (this.fServiceDelegate != null) {
            return this.fServiceDelegate.setGroupDirective(groupName, isActive, 0);
        }
        return this.getNotAvailableGroupInstrumentationInfoResult();
    }

    private GroupInstrumentationInfoResult getNotAvailableGroupInstrumentationInfoResult() {
        GroupInstrumentationInfoResult result = new GroupInstrumentationInfoResult();
        result.setStatus(106);
        result.setVerboseCause(kDefaultVerboseCause);
        return result;
    }

    public GroupInstrumentationInfoResult setGroupDirective(String groupName, boolean turnOn, int status) {
        if (this.checkBusy(true)) {
            GroupInstrumentationInfoResult busyResult = new GroupInstrumentationInfoResult();
            busyResult.setStatus(115);
            return busyResult;
        }
        GroupInstrumentationInfoResult result = this.executeSetGroupDirective(groupName, turnOn, status);
        if (result.isError()) {
            this.unBusy();
        }
        return result;
    }

    public GroupInstrumentationInfoResult setGroupDirectiveWithoutBusy(String groupName, boolean turnOn, int status) {
        GroupInstrumentationInfoResult result = this.executeSetGroupDirective(groupName, turnOn, status);
        return result;
    }

    private GroupInstrumentationInfoResult executeSetGroupDirective(String groupName, boolean turnOn, int status) {
        GroupInstrumentationInfoResult result = null;
        if (this.checkInitialized()) {
            result = this.fServiceDelegate.setGroupDirective(groupName, turnOn, status);
            if (!result.isError() && !this.redefineGroup(groupName)) {
                result.setException(new Exception("Could not reinstrument group"));
                result.setStatus(104);
            }
        } else {
            result = this.getNotAvailableGroupInstrumentationInfoResult();
        }
        return result;
    }

    public synchronized boolean isForcedBroadcast() {
        this.fLog.trace(this.kModule, "Reading forceBroadcast");
        if (this.fForceBroadcast) {
            this.fForceBroadcast = false;
            this.fLog.trace(this.kModule, "Reading forceBroadcast: true; setting forceBroadcast to false");
            return true;
        }
        this.fLog.trace(this.kModule, "Reading forceBroadcast: false");
        return false;
    }

    public void forceBroadcast() {
        this.fLog.trace(this.kModule, "setting forceBroadcast to true");
        this.fForceBroadcast = true;
    }

    private String safeName(String databaseName) {
        String result = this.fDatabaseName;
        result = result.replaceAll("\\W", "_").replaceAll(" ", "_");
        return result;
    }

    public IDeepInheritanceHelper getDeepInheritanceHelper() {
        return this.fDeepInheritanceHelper;
    }

    public void setDeepInheritanceHelper(IDeepInheritanceHelper helper) {
        this.fDeepInheritanceHelper = helper;
    }
}

