/*
 * Decompiled with CFR 0.152.
 */
package com.wily.zos.common;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.service.ASimpleService;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.zos.common.Poller;
import java.util.Map;

public abstract class Service
extends ASimpleService {
    private IAgent agent;
    private IModuleFeedbackChannel feedback;

    public Service(String serviceName) {
        super(serviceName);
    }

    protected void doStartService(IAgent agent, Map parameters) {
        this.agent = agent;
        this.feedback = agent.IAgent_getModuleFeedback();
        if (!this.isEnabled()) {
            this.logWarn(String.valueOf(this.getName()) + " is disabled.");
            return;
        }
        agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)this.getPoller(), this.getName(), true, this.getHeartbeatIntervalInMillis(), false);
        this.logInfo(String.valueOf(this.getName()) + " has been started.");
    }

    protected boolean isEnabled() {
        return true;
    }

    protected IAgent getAgent() {
        return this.agent;
    }

    protected long getHeartbeatIntervalInMillis() {
        return 5000L;
    }

    protected abstract Poller getPoller();

    protected void logInfo(String message) {
        this.feedback.info(message);
    }

    protected void logWarn(String message) {
        this.feedback.warn(message);
    }

    protected void logError(String message) {
        this.feedback.error(message);
    }

    protected void logDebug(String message) {
        this.feedback.debug(message);
    }
}

