/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.leakhunter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.leakhunter.ATrackedLeakReference;
import com.wily.introscope.agent.leakhunter.LeakHunterLogFile;
import com.wily.introscope.agent.leakhunter.LeakHunterSettings;
import com.wily.introscope.agent.leakhunter.PotentialLeakIDFactory;
import com.wily.introscope.agent.leakhunter.PotentialLeakTracker;
import com.wily.util.INameChangeListener;

public final class LeakHunterController {
    private static LeakHunterController sController;
    private final LeakHunterSettings fSettings;
    private final LeakHunterLogFile fLogFile;
    private final PotentialLeakTracker fTracker;
    private final PotentialLeakIDFactory fIDFactory;
    private final IAgent fAgent;

    public static synchronized LeakHunterController getController(IAgent agent) {
        if (sController == null) {
            sController = new LeakHunterController(agent);
        }
        return sController;
    }

    public static LeakHunterController debug_getController(IAgent agent) {
        return new LeakHunterController(agent);
    }

    public static void debug_setController(LeakHunterController controller) {
        sController = controller;
        ATrackedLeakReference.setController(sController);
    }

    private LeakHunterController(IAgent agent) {
        ATrackedLeakReference.setController(this);
        this.fSettings = new LeakHunterSettings(agent.IAgent_getIndexedProperties(), agent.IAgent_getModuleFeedback(), agent.IAgent_getStringLocalizer(), agent.IAgent_getConfigurationResource());
        boolean enableLogFileAutoNaming = agent.IAgent_isLogFileAutoNamingEnabled();
        this.fLogFile = new LeakHunterLogFile(this.fSettings, enableLogFileAutoNaming);
        if (enableLogFileAutoNaming) {
            agent.IAgent_addNameChangeListener((INameChangeListener)this.fLogFile);
        }
        this.fTracker = new PotentialLeakTracker(agent, this.fSettings, this.fLogFile);
        this.fIDFactory = new PotentialLeakIDFactory();
        this.fAgent = agent;
    }

    IAgent getAgent() {
        return this.fAgent;
    }

    boolean isEnabled() {
        return this.fSettings.isEnabled();
    }

    boolean shouldTrackNewReferences() {
        return this.isEnabled() && this.getPotentialLeakTracker().isActive();
    }

    LeakHunterSettings getLeakHunterSettings() {
        return this.fSettings;
    }

    LeakHunterLogFile getLeakHunterLogFile() {
        return this.fLogFile;
    }

    PotentialLeakTracker getPotentialLeakTracker() {
        return this.fTracker;
    }

    PotentialLeakIDFactory getPotentialLeakIDFactory() {
        return this.fIDFactory;
    }

    public int debug_getTrackedLeakCount() {
        return this.getPotentialLeakTracker().debug_getTrackedLeakCount();
    }
}

