/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public final class LogFileUtilities {
    public static final char kIllegalCharReplacement = '_';
    public static final String kLogExtension = "log";
    public static final String kWellKnownLog4jAppenderPrefix = "log4j.appender";
    public static final String kWellKnownLog4jAppenderSuffix = "File";
    public static final String kWellKnownLog4jLogFilePropKey = "log4j.appender.logfile.File";
    public static final String kInheritanceLog4jLogFilePropKey = "log4j.appender.pbdlog.File";
    private static final String kTimestampFormatString = "yyyyMMdd-HHmmss";
    private static final SimpleDateFormat kTimestampFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
    public static final int kMaxRenameAppendFileLengthInBytes = 262144;
    private static final String kAppendFileTooLongSuffix = "old";

    private LogFileUtilities() {
    }

    public static String appendUniqueTimestampToLogFileName(String fileName) throws IOException {
        Calendar rightNow = Calendar.getInstance();
        String timestamp = kTimestampFormat.format(rightNow.getTime());
        fileName = LogFileUtilities.appendIdentifierToLogFileName(fileName, timestamp, false);
        fileName = LogFileUtilities.appendUniqueIdentifierToLogFile(fileName);
        return fileName;
    }

    public static String appendUniqueIdentifierToLogFile(String fileName) throws IOException {
        if (fileName == null) {
            return null;
        }
        File logFile = new File(fileName);
        int i = 1;
        boolean success;
        while (!(success = logFile.createNewFile())) {
            fileName = fileName.toLowerCase().endsWith(".log") ? String.valueOf(fileName.substring(0, fileName.lastIndexOf(46))) + '_' + i + '.' + kLogExtension : String.valueOf(fileName) + '_' + i;
            logFile = new File(fileName);
            ++i;
        }
        return fileName;
    }

    private static String appendIdentifierToLogFileName(String fileName, String identifier, boolean replaceIllegalChars) {
        if (fileName == null) {
            return null;
        }
        if (replaceIllegalChars) {
            identifier = StringUtils.replaceNonAlphaNumericCharacters(identifier, '_');
        }
        fileName = fileName.toLowerCase().endsWith(".log") ? String.valueOf(fileName.substring(0, fileName.lastIndexOf(46))) + '.' + identifier + '.' + kLogExtension : String.valueOf(fileName) + '.' + identifier + '.' + kLogExtension;
        return fileName;
    }

    public static String appendIdentifierToLogFileName(String fileName, String identifier) {
        return LogFileUtilities.appendIdentifierToLogFileName(fileName, identifier, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean renameLogFile(String oldFilename, String newFilename, boolean appendMode, int maxFileLengthInBytes) {
        boolean bl;
        File oldFile = new File(oldFilename);
        File newFile = new File(newFilename);
        FileOutputStream fos = null;
        FileInputStream fis = null;
        if (!oldFile.exists()) {
            return false;
        }
        try {
            try {
                boolean success;
                block21: {
                    block24: {
                        success = false;
                        if (!newFile.exists()) break block24;
                        if (appendMode) {
                            if (oldFile.length() > (long)maxFileLengthInBytes) {
                                String renamedNewFilename = LogFileUtilities.appendIdentifierToLogFileName(newFilename, kAppendFileTooLongSuffix);
                                renamedNewFilename = LogFileUtilities.appendUniqueIdentifierToLogFile(renamedNewFilename);
                                File renamedNewFile = new File(renamedNewFilename);
                                renamedNewFile.delete();
                                newFile.renameTo(renamedNewFile);
                                success = oldFile.renameTo(newFile);
                                break block21;
                            } else {
                                fos = new FileOutputStream(newFilename, true);
                                fis = new FileInputStream(oldFile);
                                byte[] bytes = new byte[(int)oldFile.length()];
                                fis.read(bytes);
                                fos.write(bytes);
                                fis.close();
                                fos.close();
                                oldFile.delete();
                                success = true;
                            }
                            break block21;
                        } else {
                            newFile.delete();
                            success = oldFile.renameTo(newFile);
                        }
                        break block21;
                    }
                    success = oldFile.renameTo(newFile);
                }
                bl = success;
                Object var11_13 = null;
            }
            catch (IOException iOException) {
                Object var11_14 = null;
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException iOException2) {}
                try {
                    if (fos == null) return false;
                    fos.close();
                    return false;
                }
                catch (IOException iOException3) {}
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            try {}
            catch (IOException iOException) {}
            if (fis != null) {
                fis.close();
            }
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            if (fos == null) throw throwable;
            fos.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (fis != null) {
            fis.close();
        }
        try {}
        catch (IOException iOException) {}
        if (fos == null) return bl;
        fos.close();
        return bl;
    }

    public static void ensureLogFilePath(String desiredPath) {
        LogFileUtilities.ensureLogFilePath(desiredPath, null);
    }

    public static void ensureLogFilePath(String desiredPath, IModuleFeedbackChannel feedback) {
        if (desiredPath != null) {
            try {
                File file = new File(desiredPath).getParentFile();
                if (file != null && !file.exists()) {
                    file.mkdirs();
                    if (feedback != null && feedback.isDebugEnabled()) {
                        feedback.debug("Making directories for path: " + file.getAbsolutePath());
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    public static List getAppendersBasedOnFile(Properties newProps) {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<?> enumeration = newProps.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propertyName = (String)enumeration.nextElement();
            if (!propertyName.startsWith(kWellKnownLog4jAppenderPrefix) || !propertyName.endsWith(kWellKnownLog4jAppenderSuffix)) continue;
            result.add(propertyName);
        }
        return result;
    }
}

