/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.properties.lockable;

import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.io.ExtendedFile;
import com.wily.util.properties.lockable.ILocker;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class Locker
implements ILocker {
    private final ExtendedFile fLockFile;
    private FileLock fLock = null;
    private boolean fLocked = false;
    private IModuleFeedbackChannel fFeedback;
    private final Object fInprocessLock = new Object();

    public Locker(ExtendedFile physicalLockFile, IModuleFeedbackChannel feedback) {
        this.fLockFile = physicalLockFile;
        this.fFeedback = feedback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean tryLock() {
        Object object = this.fInprocessLock;
        synchronized (object) {
            if (this.fLocked) return false;
            FileChannel channel = null;
            this.fLocked = true;
            try {
                try {
                    RandomAccessFile raf = new RandomAccessFile(this.fLockFile.getFile(), "rwd");
                    channel = raf.getChannel();
                    this.fLock = channel.tryLock();
                    this.fLocked = this.fLock != null;
                }
                catch (FileNotFoundException e) {
                    this.fLocked = false;
                    if (this.fFeedback != null && this.fFeedback.isDebugEnabled()) {
                        this.fFeedback.debug("Physical lock file not found", e);
                    }
                }
                catch (IOException e) {
                    this.fLocked = false;
                    if (this.fFeedback != null && this.fFeedback.isDebugEnabled()) {
                        this.fFeedback.debug("IO Error in locking physical lock file", e);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                if (this.fLock != null) throw throwable;
                if (channel == null) throw throwable;
                try {
                    channel.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var4_8 = null;
                if (this.fLock != null) return this.fLocked;
                if (channel == null) return this.fLocked;
            }
            try {}
            catch (IOException iOException) {}
            channel.close();
            return this.fLocked;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void release() {
        Object object = this.fInprocessLock;
        synchronized (object) {
            block14: {
                try {
                    block13: {
                        try {
                            if (this.fLock != null) {
                                this.fLock.release();
                            }
                            this.fLocked = false;
                        }
                        catch (IOException e) {
                            if (this.fFeedback == null || !this.fFeedback.isDebugEnabled()) break block13;
                            this.fFeedback.debug("IO Error in unlocking physical lock file", e);
                        }
                    }
                    Object var3_5 = null;
                    if (this.fLock == null) break block14;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    if (this.fLock != null) {
                        try {
                            this.fLock.channel().close();
                        }
                        catch (IOException iOException) {}
                        this.fLock = null;
                    }
                    this.fLocked = this.fLock != null;
                    throw throwable;
                }
                try {}
                catch (IOException iOException) {}
                this.fLock.channel().close();
                this.fLock = null;
            }
            this.fLocked = this.fLock != null;
            return;
        }
    }
}

