/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.text;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public abstract class Utf8ResourceBundle {
    public static final ResourceBundle getBundle(String baseName) {
        return Utf8ResourceBundle.createUtf8PropertyResourceBundle(ResourceBundle.getBundle(baseName));
    }

    public static final ResourceBundle getBundle(String baseName, Locale locale) {
        return Utf8ResourceBundle.createUtf8PropertyResourceBundle(ResourceBundle.getBundle(baseName, locale));
    }

    public static final ResourceBundle getBundle(String baseName, Locale locale, ClassLoader classLoader) {
        return Utf8ResourceBundle.createUtf8PropertyResourceBundle(ResourceBundle.getBundle(baseName, locale, classLoader));
    }

    private static ResourceBundle createUtf8PropertyResourceBundle(ResourceBundle bundle) {
        if (!(bundle instanceof PropertyResourceBundle)) {
            return bundle;
        }
        return new Utf8PropertyResourceBundle((PropertyResourceBundle)bundle);
    }

    private static class Utf8PropertyResourceBundle
    extends ResourceBundle {
        private final PropertyResourceBundle bundle;

        private Utf8PropertyResourceBundle(PropertyResourceBundle bundle) {
            this.bundle = bundle;
        }

        public Enumeration getKeys() {
            return this.bundle.getKeys();
        }

        protected Object handleGetObject(String key) {
            String value = this.bundle.getString(key);
            if (value == null) {
                return null;
            }
            try {
                return new String(value.getBytes("ISO-8859-1"), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Encoding not supported", e);
            }
        }
    }
}

