/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.introscope.upgrade;

import com.ca.apm.introscope.upgrade.InstallableUnit;
import java.io.File;

public class CreateInstallableUnit {
    public static final String kLine = System.getProperty("line.separator");
    public static final String kTab = "    ";
    public static final String kNameParam = "name";
    public static final String kProviderParam = "provider";
    public static final String kVersionParam = "version";
    public static final String kLocationParam = "location";

    private static void usage() {
        StringBuffer usageBuffer = new StringBuffer();
        usageBuffer.append(String.valueOf(kLine) + kLine + "Usage: java -jar CreateIU.jar name=<name> provider=<provider> version=<version> location=<location>");
        usageBuffer.append(String.valueOf(kLine) + kLine + "Where:").append(String.valueOf(kLine) + kTab + kTab + "name=<name>           informative description/name about the installable ").append(String.valueOf(kLine) + kTab + kTab + "                      unit that is being created").append(String.valueOf(kLine) + kTab + kTab + "provider=<provider>   provider of the upgrade").append(String.valueOf(kLine) + kTab + kTab + "version=<version>     upgrade version number").append(String.valueOf(kLine) + kTab + kTab + "location=<location>   location of the directory containing contents ").append(String.valueOf(kLine) + kTab + kTab + "                      including core/config and core/ext sub-directories");
        usageBuffer.append(String.valueOf(kLine) + kLine + "Example:").append(String.valueOf(kLine) + "java -jar CreateIU.jar name=\"Patch for Memory Leak\" provider=\"CA Tech\" version=1.0 location=\"C:/mydir\"");
        System.out.println(usageBuffer);
    }

    private static void create(String[] args) {
        File locationDir;
        String name = null;
        String provider = null;
        String version = null;
        String location = null;
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            String[] tokens = arg.split("=");
            if (tokens.length != 2) {
                System.out.println("Invalid parameter: " + arg);
                CreateInstallableUnit.usage();
                System.exit(0);
            }
            if (kNameParam.equalsIgnoreCase(tokens[0])) {
                name = tokens[1];
            } else if (kProviderParam.equalsIgnoreCase(tokens[0])) {
                provider = tokens[1];
            } else if (kVersionParam.equalsIgnoreCase(tokens[0])) {
                version = tokens[1];
            } else if (kLocationParam.equalsIgnoreCase(tokens[0])) {
                location = tokens[1];
            } else {
                System.out.println("Invalid parameter: " + arg);
                CreateInstallableUnit.usage();
                System.exit(0);
            }
            ++n2;
        }
        if (name == null) {
            System.out.println("Missing name");
            CreateInstallableUnit.usage();
            System.exit(0);
        }
        if (provider == null) {
            System.out.println("Missing provider");
            CreateInstallableUnit.usage();
            System.exit(0);
        }
        if (version == null) {
            System.out.println("Missing version");
            CreateInstallableUnit.usage();
            System.exit(0);
        }
        if (location == null) {
            System.out.println("Missing location");
            CreateInstallableUnit.usage();
            System.exit(0);
        }
        if (!(locationDir = new File(location)).exists() || !locationDir.isDirectory()) {
            System.out.println("Invalid location: " + location);
            CreateInstallableUnit.usage();
            System.exit(0);
        }
        InstallableUnit unit = new InstallableUnit();
        unit.create(name, provider, version, location);
    }

    public static void main(String[] args) {
        if (args.length == 0 || args[0] != null && args[0].equals("usage")) {
            CreateInstallableUnit.usage();
        } else {
            CreateInstallableUnit.create(args);
        }
    }
}

