/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.db;

import com.wily.diagnos.cmp.directives.FlagName;
import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.tracer.MethodTracer;
import com.wily.introscope.agent.db.ClassMethodId;
import com.wily.introscope.agent.db.CompilerLogDatabaseTransaction;
import com.wily.introscope.agent.db.ConnectionManager;
import com.wily.introscope.agent.db.DatabaseResult;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledMethod;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseStoreDelegate {
    public static DatabaseResult storeMethodsTraced(final List methodsToBeTraced) {
        DatabaseResult result = new CompilerLogDatabaseTransaction(ConnectionManager.Instance()){

            protected void defineTransaction() throws SQLException {
                for (IModeledMethod method : methodsToBeTraced) {
                    this.tryStoreClassAndMethod(method, null, 1, 1);
                }
            }
        }.executeTransaction();
        return result;
    }

    public static DatabaseResult storeMethodTraced(final boolean isTraced, final IModeledMethod method, final List methodCalls) {
        DatabaseResult result = new CompilerLogDatabaseTransaction(ConnectionManager.Instance()){

            protected void defineTransaction() throws SQLException {
                int methodTracedStatus = 1;
                if (!isTraced) {
                    methodTracedStatus = 2;
                }
                this.tryStoreClassAndMethod(method, methodCalls, 1, methodTracedStatus);
            }
        }.executeTransaction();
        return result;
    }

    public static DatabaseResult storeMethodsNotTraced(final List methodsToBeTraced) {
        DatabaseResult result = new CompilerLogDatabaseTransaction(ConnectionManager.Instance()){

            protected void defineTransaction() throws SQLException {
                Iterator i = methodsToBeTraced.iterator();
                while (i.hasNext()) {
                    IModeledMethod method = (IModeledMethod)i.next();
                    List methodCalls = (List)i.next();
                    this.tryStoreClassAndMethod(method, methodCalls, 1, 2);
                }
            }
        }.executeTransaction();
        return result;
    }

    public static DatabaseResult storeClassesTraced(final List<String> classToBeTraced) {
        DatabaseResult result = new CompilerLogDatabaseTransaction(ConnectionManager.Instance()){

            protected void defineTransaction() throws SQLException {
                for (String className : classToBeTraced) {
                    ClassMethodId id = this.tryStoreClass(className);
                    this.tryUpdateClass(className, 1, id);
                }
            }
        }.executeTransaction();
        return result;
    }

    public static DatabaseResult storeClassTraced(final boolean isTraced, final String className) {
        DatabaseResult result = new CompilerLogDatabaseTransaction(ConnectionManager.Instance()){

            protected void defineTransaction() throws SQLException {
                ClassMethodId id = this.tryStoreClass(className);
                if (isTraced) {
                    this.tryUpdateClass(className, 1, id);
                }
            }
        }.executeTransaction();
        return result;
    }

    public static DatabaseResult storeMethodsTracers(final List detailsToBeTraced) {
        DatabaseResult result = new CompilerLogDatabaseTransaction(ConnectionManager.Instance()){

            protected void defineTransaction() throws SQLException {
                Iterator i = detailsToBeTraced.iterator();
                while (i.hasNext()) {
                    FlagName name;
                    IModeledMethod method = (IModeledMethod)i.next();
                    MethodTracer tracer = (MethodTracer)i.next();
                    String tracerClass = tracer.getTracerClass().getContainerAndPackageAndNameString();
                    String tracerName = tracer.getTracerName().getName();
                    String tracerResource = tracer.getTracerResource();
                    String tracerParameters = tracer.getTracerParameters();
                    String tracerGroupNameBuffer = "";
                    TracerGroup group = tracer.getTracerGroup();
                    if (group != null && (name = group.getName()) != null) {
                        tracerGroupNameBuffer = name.getName();
                    }
                    String tracerGroupName = tracerGroupNameBuffer;
                    ClassMethodId methodIdInfo = this.getClassMethodId(method);
                    if (methodIdInfo == null) {
                        methodIdInfo = this.tryStoreClassAndMethod(method, null, 1, 1);
                    } else if (methodIdInfo.getMethodId() < 0) {
                        methodIdInfo = this.tryStoreClassAndMethod(method, null, 1, 1);
                    }
                    PreparedStatement s = this.getPreparedStatement("insert_method_tracer", "insert into method_trace values (?, ?, ?, ?, ?, ?, ?)");
                    s.setString(1, tracerName);
                    s.setString(2, tracerGroupName);
                    s.setInt(3, methodIdInfo.getClassId());
                    s.setInt(4, methodIdInfo.getMethodId());
                    s.setString(5, tracerParameters);
                    s.setString(6, tracerClass);
                    s.setString(7, tracerResource);
                    s.execute();
                }
            }
        }.executeTransaction();
        return result;
    }

    public static DatabaseResult storeSpecialMethodsTracers(final IClassName className, final String methodName, final String tracerName, final String tracerGroupName, final String tracerParameters, final String tracerClass, final String tracerResource) {
        DatabaseResult result = new CompilerLogDatabaseTransaction(ConnectionManager.Instance()){

            protected void defineTransaction() throws SQLException {
                ClassMethodId methodIdInfo = this.getClassMethodId(className.getContainerAndPackageAndNameString(), methodName);
                if (methodIdInfo == null) {
                    methodIdInfo = this.tryStoreClassAndMethod(className.getContainerAndPackageAndNameString(), methodName, null, 1, 1);
                } else if (methodIdInfo.getMethodId() < 0) {
                    methodIdInfo = this.tryStoreClassAndMethod(className.getContainerAndPackageAndNameString(), methodName, null, 1, 1);
                }
                PreparedStatement s = this.getPreparedStatement("insert_method_tracer", "insert into method_trace values (?, ?, ?, ?, ?, ?, ?)");
                s.setString(1, tracerName);
                s.setString(2, tracerGroupName);
                s.setInt(3, methodIdInfo.getClassId());
                s.setInt(4, methodIdInfo.getMethodId());
                s.setString(5, tracerParameters);
                s.setString(6, tracerClass);
                s.setString(7, tracerResource);
                s.execute();
            }
        }.executeTransaction();
        return result;
    }
}

