/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.autoprobe.dynamic;

import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.util.HashCodeUtils;
import com.wily.util.classfile.IClassName;

public class MethodMatcherInfo {
    private IMethodMatcher fMethodMatcher;
    private String fParams;
    private boolean fParamAccess;
    private IClassName fTracerClass;

    public MethodMatcherInfo(IMethodMatcher methodMatcher, String params, boolean paramAccess, IClassName tracerClass) {
        this.fMethodMatcher = methodMatcher;
        this.fParams = params;
        this.fParamAccess = paramAccess;
        this.fTracerClass = tracerClass;
    }

    public IMethodMatcher getMethodMatcher() {
        return this.fMethodMatcher;
    }

    public String getTracerParams() {
        return this.fParams;
    }

    public boolean getParamAccessFlag() {
        return this.fParamAccess;
    }

    public IClassName getTracerClass() {
        return this.fTracerClass;
    }

    public int hashCode() {
        int result = 17;
        result = HashCodeUtils.accumulateHashCode((int)result, (int)this.fMethodMatcher.hashCode());
        result = HashCodeUtils.accumulateHashCode((int)result, (Object)this.fParams);
        result = HashCodeUtils.accumulateHashCode((int)result, (boolean)this.fParamAccess);
        result = HashCodeUtils.accumulateHashCode((int)result, (Object)this.fTracerClass);
        return result;
    }

    public boolean equals(Object obj) {
        MethodMatcherInfo other = (MethodMatcherInfo)obj;
        if (!this.getMethodMatcher().equals(other.getMethodMatcher())) {
            return false;
        }
        if (this.getParamAccessFlag() != other.getParamAccessFlag()) {
            return false;
        }
        if (this.getTracerParams() != null && !this.getTracerParams().equals(other.getTracerParams())) {
            return false;
        }
        return this.getTracerClass().equals(other.getTracerClass());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Method Matcher Info :" + this.fMethodMatcher.toString());
        sb.append("\nTracer Params :" + this.fTracerClass);
        sb.append("\nNeeds Parameter Access :" + this.fParamAccess);
        sb.append("\nTracer Class :" + this.fTracerClass.getReflectionFriendlyQualifiedNameString());
        return sb.toString();
    }
}

