/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.bizdef.parameters;

import com.wily.introscope.agent.bizdef.IBizParameter;
import com.wily.introscope.agent.bizdef.IBizParameterType;
import com.wily.introscope.agent.bizdef.adt.CaseSensitiveMap;
import com.wily.introscope.agent.bizdef.types.BizDefType;

public class BizParameter
implements IBizParameter {
    private String fParameterName;
    private IBizParameterType fParameterType;
    private String fParameterResult;
    private CaseSensitiveMap fParameters;

    public BizParameter(String parameterName, String parameterValue, String type) {
        this(parameterName, parameterValue, (IBizParameterType)BizDefType.getInstance(type));
    }

    public BizParameter(String parameterName, CaseSensitiveMap parameterValues, String type) {
        this(parameterName, parameterValues, (IBizParameterType)BizDefType.getInstance(type));
    }

    public BizParameter(String parameterName, String parameterValue, IBizParameterType type) {
        this.fParameterName = parameterName;
        this.fParameterResult = parameterValue;
        this.fParameterType = type;
        this.fParameters = null;
    }

    public BizParameter(String parameterName, CaseSensitiveMap parameters, IBizParameterType type) {
        this.fParameterName = parameterName;
        this.fParameterType = type;
        this.fParameters = parameters;
        this.fParameterResult = null;
    }

    public String getName() {
        return this.fParameterName;
    }

    public final IBizParameterType getType() {
        return this.fParameterType;
    }

    public final String getValue() {
        return this.fParameterResult;
    }

    public String getValue(String key) {
        if (this.fParameters != null) {
            Object obj = this.fParameters.get(key);
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj instanceof String[]) {
                return ((String[])obj)[0];
            }
        }
        return null;
    }

    public final CaseSensitiveMap getValues() {
        return this.fParameters;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.fParameterName != null) {
            buffer.append("HttpParameterName=" + this.fParameterName + " ");
        }
        if (this.fParameterType != null) {
            buffer.append("HttpParameterType=" + this.fParameterType + " ");
        }
        if (this.fParameterResult != null) {
            buffer.append("HttpParameterValue=" + this.fParameterResult + " ");
        }
        if (this.fParameters != null) {
            buffer.append(this.fParameters.toString());
        }
        if (buffer.length() > 0) {
            return buffer.toString();
        }
        return null;
    }

    public boolean equals(Object arg0) {
        if (this.toString() != null && arg0 != null) {
            return this.toString().equals(arg0.toString());
        }
        return false;
    }

    public int hashCode() {
        String s = this.toString();
        if (s != null) {
            return s.hashCode();
        }
        return 0;
    }
}

