/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.entrypoint;

import com.wily.introscope.agent.intelligent.entrypoint.AutomaticBoundaryDetectionAdmin;
import com.wily.introscope.agent.intelligent.entrypoint.Logger;
import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;
import com.wily.introscope.agent.intelligent.entrypoint.apis.RuleEngine;
import com.wily.introscope.agent.intelligent.entrypoint.stacktrace.StackTraceRecordingController;
import com.wily.introscope.agent.intelligent.entrypoint.stacktrace.StackTraceRepository;
import com.wily.introscope.agent.trace.intelligent.SustainabilityMetricsHelper;
import com.wily.introscope.agent.trace.intelligent.frontend.FrontEndCandidateAnalyzer;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class CandidateFinder
implements Runnable {
    private static final int RUNS_INITIAL_VALUE = 1;
    private static AtomicInteger numberOfRuns = new AtomicInteger(1);

    @Override
    public void run() {
        try {
            numberOfRuns.getAndIncrement();
            this.doRun();
            if (StackTraceRepository.isEmpty()) {
                StackTraceRecordingController.resetRecordingsCounter();
            }
        }
        catch (Exception e) {
            Logger.logDebugMessage((String)"Error while finding initial candidates", (Throwable)e);
        }
    }

    protected void doRun() {
        Logger.logTraceMessage((String)"Initial Candidate Finder got scheduled.");
        SustainabilityMetricsHelper.reportStackQueueLength((int)StackTraceRepository.size());
        IndexAwareTraceElement[] trace = StackTraceRepository.pollWrappedTrace();
        int counter = 0;
        while (trace != null && trace.length > 0) {
            this.process(trace);
            ++counter;
            trace = StackTraceRepository.pollWrappedTrace();
        }
        Logger.logTraceMessage((String)("Initial Candidate Finder completed. Traces processed: " + counter));
        SustainabilityMetricsHelper.reportAnalyzedStacks((int)counter);
    }

    private void process(IndexAwareTraceElement[] trace) {
        Logger.logDebugMessage((String)"Started processing stack trace.");
        if (Logger.isTraceEnabled()) {
            Logger.logTraceMessage((String)("Stack Trace size : " + trace.length));
        }
        RuleEngine ruleEngine = AutomaticBoundaryDetectionAdmin.getInstance().getEntryPointDetectionRuleEngine();
        List candidates = ruleEngine.execute(ruleEngine.preExecute(trace));
        int size = 0;
        if (candidates != null) {
            size = candidates.size();
            Logger.logDebugMessage((String)("Number of initial candidates found: " + size));
            if (Logger.isTraceEnabled()) {
                Logger.logTraceMessage((String)("Initial Candidates: " + candidates));
            }
            if (FrontEndCandidateAnalyzer.isInitialized()) {
                for (IndexAwareTraceElement candidate : candidates) {
                    FrontEndCandidateAnalyzer.addInitialFrontEndCandidate((String)candidate.getClassName(), (String)candidate.getMethodName(), (String)FrontEndCandidateAnalyzer.NULL_DESCRIPTOR);
                }
            }
        }
    }

    public static int currentRunNumber() {
        return numberOfRuns.get();
    }

    public static void resetRuns() {
        numberOfRuns.set(1);
    }
}

