/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.entrypoint;

import com.wily.introscope.agent.intelligent.entrypoint.CandidateFinder;
import com.wily.introscope.agent.intelligent.entrypoint.EntryPointDetectionConfiguration;
import com.wily.introscope.agent.intelligent.entrypoint.Logger;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class CandidateIdentificationExecutor {
    private static final int NTHREADS = 1;
    private static ScheduledExecutorService schedulor;
    private static final long INITIAL_DELAY = 15L;
    private static volatile boolean started;

    static {
        started = false;
    }

    public static void init() {
        if (!started) {
            schedulor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = Executors.defaultThreadFactory().newThread(r);
                    thread.setDaemon(true);
                    return thread;
                }
            });
            Logger.logDebugMessage((String)"Initial Candidate identification executor initiated.");
            schedulor.scheduleAtFixedRate(new CandidateFinder(), 15L, EntryPointDetectionConfiguration.getCandidateFinderInterval(), TimeUnit.SECONDS);
            started = true;
        }
    }
}

