/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.entrypoint.stacktrace;

import com.wily.introscope.agent.TraceRecorder;
import com.wily.introscope.agent.intelligent.entrypoint.EntryPointDetectionConfiguration;
import com.wily.introscope.agent.intelligent.entrypoint.Logger;
import com.wily.introscope.agent.intelligent.entrypoint.common.Utils;
import com.wily.introscope.agent.intelligent.entrypoint.stacktrace.StackTraceRecordingController;
import com.wily.introscope.agent.intelligent.entrypoint.stacktrace.StackTraceRepository;
import com.wily.util.feedback.SeverityLevel;
import java.util.concurrent.atomic.AtomicInteger;

public class StackTraceRecorder
implements TraceRecorder {
    private final int MAX_MESSAGES_TO_LOG = 10;
    private AtomicInteger loggedMsgsCounter = new AtomicInteger(0);

    private StackTraceRecorder() {
    }

    public boolean record() {
        block3: {
            try {
                if (StackTraceRecordingController.shouldRecordStackTrace()) {
                    this.recordTraceInternal();
                    StackTraceRecordingController.notifyRecordingListeners();
                    return true;
                }
            }
            catch (Exception e) {
                if (this.loggedMsgsCounter.getAndIncrement() >= 10) break block3;
                Logger.logMessage((String)"Error in StackTraceRecorder while recording stack trace", (SeverityLevel)SeverityLevel.ERROR);
                Logger.logDebugMessage((String)e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    private void recordTraceInternal() {
        Logger.logDebugMessage((String)"StackTraceRecorder: Recording trace in repository");
        StackTraceElement[] traceElements = Thread.currentThread().getStackTrace();
        StackTraceRepository.add(traceElements);
        this.logTraceIfEnabled(traceElements);
    }

    private void logTraceIfEnabled(StackTraceElement[] traceElements) {
        if (Logger.isTraceEnabled() && EntryPointDetectionConfiguration.shouldLogStackTraces()) {
            String traceAsString = Utils.getStringRepresentationOfTrace(traceElements);
            Logger.logTraceMessage((String)("Stack Trace: \n" + traceAsString));
        }
    }

    public static StackTraceRecorder getInstance() {
        return SingletonHolder.INSTANCE;
    }

    /* synthetic */ StackTraceRecorder(StackTraceRecorder stackTraceRecorder) {
        this();
    }

    private static class SingletonHolder {
        private static final StackTraceRecorder INSTANCE = new StackTraceRecorder(null);

        private SingletonHolder() {
        }
    }
}

