/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.probebuilder.intelligent.instrumentation;

import com.wily.introscope.probebuilder.intelligent.instrumentation.FilePersistenceHelper;
import com.wily.introscope.probebuilder.intelligent.instrumentation.IntelligentInstrumentationConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class FilePersistenceService {
    private static ConcurrentHashMap<String, String[]> toBePersisted = new ConcurrentHashMap();
    private static AtomicInteger pairsCount = new AtomicInteger(0);

    public static boolean persistInstrumentation(String className, String methodName, String signature, String directiveType) {
        boolean queueSizeClampHit;
        String key = String.valueOf(className) + "," + methodName + "," + signature + "," + directiveType;
        String[] str = new String[]{className, methodName, signature, directiveType};
        boolean traceDirectivesClampHit = FilePersistenceHelper.getInstrumentedMethodsCountInPbd() > IntelligentInstrumentationConfig.INSTANCE.getPersistenceTraceDirectivesClampSize();
        boolean bl = queueSizeClampHit = pairsCount.intValue() >= IntelligentInstrumentationConfig.INSTANCE.getPersistenceQueueClampSize();
        if (traceDirectivesClampHit || queueSizeClampHit && !toBePersisted.contains(key)) {
            return false;
        }
        if (toBePersisted.putIfAbsent(key, str) == null) {
            pairsCount.getAndIncrement();
        }
        return true;
    }

    public static void remove(String key) {
        if (toBePersisted.remove(key) != null) {
            pairsCount.getAndDecrement();
        }
    }

    public static String[] getValue(String key) {
        return toBePersisted.get(key);
    }

    public static Set<String> getAllKeys() {
        return toBePersisted.keySet();
    }

    public static void clearEntries(ArrayList<String> keysToDelete) {
        Iterator<String> itr = keysToDelete.iterator();
        while (itr.hasNext()) {
            if (toBePersisted.remove(itr.next()) == null) continue;
            pairsCount.getAndDecrement();
        }
    }

    public static int getQueueSize() {
        return pairsCount.intValue();
    }
}

