/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.io;

import com.wily.util.io.FastArrayCopy;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class NonSyncBufferedOutputStream
extends FilterOutputStream {
    private static int kDefaultBufferSize = 32768;
    private byte[] fBuffer;
    private int fPosition;

    public NonSyncBufferedOutputStream(OutputStream output) {
        this(output, kDefaultBufferSize);
    }

    public NonSyncBufferedOutputStream(OutputStream output, int size) {
        super(output);
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.fBuffer = new byte[size];
        this.fPosition = 0;
    }

    private void writeBufferedData() throws IOException {
        if (this.fPosition > 0) {
            this.out.write(this.fBuffer, 0, this.fPosition);
            this.fPosition = 0;
        }
    }

    public void flush() throws IOException {
        this.writeBufferedData();
        this.out.flush();
        super.flush();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int capacity = this.fBuffer.length - this.fPosition;
        if (capacity > len) {
            FastArrayCopy.copy(b, off, this.fBuffer, this.fPosition, len);
            this.fPosition += len;
        } else {
            this.writeBufferedData();
            super.write(b, off, len);
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public final void write(int b) throws IOException {
        this.fBuffer[this.fPosition++] = (byte)b;
        if (this.fPosition == this.fBuffer.length) {
            this.writeBufferedData();
        }
    }

    public Writer getWriter(boolean supportDoubleByte) {
        return new WriterAdapter(supportDoubleByte);
    }

    private class WriterAdapter
    extends Writer {
        private final boolean fSupportDoubleByte;

        public WriterAdapter(boolean supportDoubleByte) {
            this.fSupportDoubleByte = supportDoubleByte;
        }

        public void write(int thechar) throws IOException {
            if (!this.fSupportDoubleByte && (thechar >>> 8 & 0xFF) != 0) {
                throw new IOException("Can't write double byte characters! Please run in double byte mode");
            }
            if (this.fSupportDoubleByte) {
                NonSyncBufferedOutputStream.this.write(thechar >>> 8 & 0xFF);
            }
            NonSyncBufferedOutputStream.this.write(thechar & 0xFF);
        }

        public void write(String str, int off, int len) throws IOException {
            for (int i = 0; i < len; ++i) {
                this.write(str.charAt(off++));
            }
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            while (len-- > 0) {
                char thechar = cbuf[off++];
                this.write(thechar);
            }
        }

        public void flush() throws IOException {
            NonSyncBufferedOutputStream.this.flush();
        }

        public void close() throws IOException {
            NonSyncBufferedOutputStream.this.flush();
        }
    }
}

