/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

import com.wily.util.ArrayUtilities;
import com.wily.util.Range;

public class TimestampedDataSet {
    private static final double[] kHiddenValues = new double[0];
    private static final double[] kHiddenTimestamps = kHiddenValues;
    private long fDataSetWindowStart;
    private final int fDataSetWindowLength;
    private boolean fDataSetWindowSynchronized;
    private final long fQuantum;
    private final double fHoleValue;
    private double[][] fTimestampedValues;
    private boolean[] fIsVisible;
    private double fMin;
    private double fMax;
    static /* synthetic */ Class class$0;

    private TimestampedDataSet() {
        this.fDataSetWindowLength = 0;
        this.fQuantum = 0L;
        this.fHoleValue = 0.0;
    }

    public TimestampedDataSet(long initialDataSetWindowStart, int dataSetWindowLength, long quantum, double holeValue) {
        this.fDataSetWindowStart = initialDataSetWindowStart;
        this.fDataSetWindowLength = dataSetWindowLength;
        this.fQuantum = quantum;
        this.fHoleValue = holeValue;
        this.setDataSetWindowSynchronized(false);
        this.initData();
    }

    public int getSeriesCount() {
        return this.fTimestampedValues.length;
    }

    public void addSeries() {
        double[] dArray = new double[]{};
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[D");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fTimestampedValues = (double[][])ArrayUtilities.addElementToObjectArray((Object[])this.fTimestampedValues, dArray, clazz);
        boolean[] temp = new boolean[this.fTimestampedValues.length];
        int i = 0;
        while (i < this.fIsVisible.length) {
            temp[i] = this.fIsVisible[i];
            ++i;
        }
        temp[this.fIsVisible.length] = true;
        this.fIsVisible = temp;
        int newSeriesIndex = this.getSeriesCount() - 1;
        this.fTimestampedValues[newSeriesIndex] = new double[this.getDataSetWindowLength()];
        int windowLength = this.getDataSetWindowLength();
        int i2 = 0;
        while (i2 < windowLength) {
            this.fTimestampedValues[newSeriesIndex][i2] = this.getHoleValue();
            ++i2;
        }
    }

    public void setNumSeries(int numSeries) {
        this.clearData();
        int i = 0;
        while (i < numSeries) {
            this.addSeries();
            ++i;
        }
    }

    public void addTimestampedDataPoint(int seriesIndex, long timestamp, double value) {
        if (!this.isDataSetWindowSynchronized()) {
            this.synchronizeDataSetWindow(timestamp);
            this.setDataSetWindowSynchronized(true);
        }
        this.adjustDataSetWindowToTimestamp(timestamp);
        this.adjustRange(value);
        this.fTimestampedValues[seriesIndex][this.getTimestampIndex((long)timestamp)] = value;
    }

    private final void adjustRange(double value) {
        if (value == this.getHoleValue()) {
            return;
        }
        if (this.fMin == this.getHoleValue() || value < this.fMin) {
            this.fMin = value;
        }
        if (this.fMax == this.getHoleValue() || value > this.fMax) {
            this.fMax = value;
        }
    }

    public void bringToFront(int index) {
        ArrayUtilities.moveElementToFront((Object[])this.fTimestampedValues, index);
        ArrayUtilities.moveElementToFront(this.fIsVisible, index);
    }

    public void sendToBack(int index) {
        ArrayUtilities.moveElementToBack((Object[])this.fTimestampedValues, index);
        ArrayUtilities.moveElementToBack(this.fIsVisible, index);
    }

    public void setVisible(int seriesIndex, boolean visible) {
        this.fIsVisible[seriesIndex] = visible;
    }

    public void setAllVisible(boolean visible) {
        int i = 0;
        while (i < this.fIsVisible.length) {
            this.fIsVisible[i] = visible;
            ++i;
        }
    }

    public double[] getVisibleSeriesValues(int seriesIndex) {
        if (this.fIsVisible[seriesIndex]) {
            return this.getSeriesValues(seriesIndex);
        }
        return kHiddenValues;
    }

    public double[] getSeriesValues(int seriesIndex) {
        return this.fTimestampedValues[seriesIndex];
    }

    public double[] getVisibleTimestamps(int seriesIndex) {
        if (this.fIsVisible[seriesIndex]) {
            return this.getTimestamps();
        }
        return kHiddenTimestamps;
    }

    public double[] getTimestamps() {
        double[] timestamps = new double[this.getDataSetWindowLength()];
        int i = 0;
        while (i < this.getDataSetWindowLength()) {
            timestamps[i] = this.getTimestampDataPointIndex(i);
            ++i;
        }
        return timestamps;
    }

    public Range getDataSetValueRange() {
        double maxValue = Double.NEGATIVE_INFINITY;
        double minValue = Double.POSITIVE_INFINITY;
        if (this.fMin != this.getHoleValue()) {
            minValue = this.fMin;
        }
        if (this.fMax != this.getHoleValue()) {
            maxValue = this.fMax;
        }
        if (minValue == Double.POSITIVE_INFINITY) {
            minValue = this.getHoleValue();
        }
        return new Range(minValue, maxValue);
    }

    private void rerange() {
        double newMin = this.getHoleValue();
        double newMax = this.getHoleValue();
        int i = 0;
        while (i < this.fTimestampedValues.length) {
            int j = 0;
            while (j < this.fTimestampedValues[i].length) {
                double val = this.fTimestampedValues[i][j];
                if (val != this.getHoleValue()) {
                    if (newMin == this.getHoleValue() || val < newMin) {
                        newMin = val;
                    }
                    if (newMax == this.getHoleValue() || val > newMax) {
                        newMax = val;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public double getDataPoint(int seriesIndex, int dataPointIndex) {
        return this.fTimestampedValues[seriesIndex][dataPointIndex];
    }

    public long getDataSetWindowStart() {
        return this.fDataSetWindowStart;
    }

    public long getDataSetWindowEnd() {
        return this.getDataSetWindowStart() + (long)this.getDataSetWindowLength() * this.getQuantum();
    }

    private void initData() {
        this.fTimestampedValues = new double[0][0];
        this.fIsVisible = new boolean[0];
        this.fMin = this.getHoleValue();
        this.fMax = this.getHoleValue();
    }

    private void clearData() {
        this.fMin = this.getHoleValue();
        this.fMax = this.getHoleValue();
        int i = 0;
        while (i < this.getSeriesCount()) {
            this.fIsVisible[i] = true;
            int j = 0;
            while (j < this.getDataSetWindowLength()) {
                this.fTimestampedValues[i][j] = this.getHoleValue();
                ++j;
            }
            ++i;
        }
    }

    private boolean isDataSetWindowSynchronized() {
        return this.fDataSetWindowSynchronized;
    }

    private void setDataSetWindowSynchronized(boolean dataSetWindowSynchronized) {
        this.fDataSetWindowSynchronized = dataSetWindowSynchronized;
    }

    private long getQuantum() {
        return this.fQuantum;
    }

    public double getTimestampDataPointIndex(int dataPointIndex) {
        return this.getDataSetWindowStart() + (long)dataPointIndex * this.getQuantum();
    }

    private void adjustDataSetWindowToTimestamp(long timestamp) {
        int timestampIndex = this.getTimestampIndex(timestamp);
        if (timestampIndex < 0) {
            this.scrollDataSetWindow(timestampIndex);
        }
        if (timestampIndex >= this.getDataSetWindowLength()) {
            this.scrollDataSetWindow(timestampIndex - (this.getDataSetWindowLength() - 1));
        }
    }

    private int getTimestampIndex(long timestamp) {
        long rawTimestampIndex = timestamp / this.getQuantum();
        long rawFirstTimestampIndex = this.getDataSetWindowStart() / this.getQuantum();
        return (int)(rawTimestampIndex - rawFirstTimestampIndex);
    }

    private void synchronizeDataSetWindow(long timestamp) {
        this.fDataSetWindowStart = timestamp - this.getQuantum() * (long)this.getDataSetWindowLength();
    }

    private int getDataSetWindowLength() {
        return this.fDataSetWindowLength;
    }

    private void setDataSetWindowStart(long newDataSetWindowStart) {
        this.fDataSetWindowStart = newDataSetWindowStart;
    }

    private void scrollDataSetWindow(int numUnitsToScroll) {
        if (numUnitsToScroll != 0) {
            if (Math.abs(numUnitsToScroll) >= this.getDataSetWindowLength()) {
                this.clearData();
            } else {
                boolean scrollRight = numUnitsToScroll > 0;
                int sourceIndex = scrollRight ? numUnitsToScroll : 0;
                int destIndex = scrollRight ? 0 : Math.abs(numUnitsToScroll);
                int lengthToCopy = this.getDataSetWindowLength() - Math.abs(numUnitsToScroll);
                boolean rerange = false;
                int i = 0;
                while (i < this.getSeriesCount()) {
                    int deadl = 0;
                    while (deadl < sourceIndex) {
                        if (this.fTimestampedValues[i][deadl] != this.getHoleValue() && (this.fTimestampedValues[i][deadl] <= this.fMin || this.fTimestampedValues[i][deadl] >= this.fMax)) {
                            rerange = true;
                        }
                        ++deadl;
                    }
                    int deadr = sourceIndex + lengthToCopy;
                    while (deadr < this.fTimestampedValues[i].length) {
                        if (this.fTimestampedValues[i][deadr] != this.getHoleValue() && (this.fTimestampedValues[i][deadr] <= this.fMin || this.fTimestampedValues[i][deadr] >= this.fMax)) {
                            rerange = true;
                        }
                        ++deadr;
                    }
                    System.arraycopy(this.fTimestampedValues[i], sourceIndex, this.fTimestampedValues[i], destIndex, lengthToCopy);
                    int newValsStartIndex = scrollRight ? lengthToCopy : 0;
                    int newValsStopIndex = scrollRight ? this.getDataSetWindowLength() : Math.abs(numUnitsToScroll);
                    int j = newValsStartIndex;
                    while (j < newValsStopIndex) {
                        this.fTimestampedValues[i][j] = this.getHoleValue();
                        ++j;
                    }
                    ++i;
                }
                if (rerange) {
                    this.rerange();
                }
            }
        }
        this.setDataSetWindowStart(this.getDataSetWindowStart() + (long)numUnitsToScroll * this.getQuantum());
    }

    protected final double getHoleValue() {
        return this.fHoleValue;
    }
}

