/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.JCAConnectionPool;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.runtime.CustomService;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.jmx.IJMXCustomizer;
import com.wily.introscope.agent.jmx.IMBeanServerLocator;
import com.wily.introscope.agent.service.IAgentService;
import com.wily.introscope.agent.service.ServiceAdministrator;
import com.wily.introscope.agent.transactiontrace.IPlatformCrossProcessDataHelper;
import com.wily.introscope.agent.transactiontrace.websphere.WebSpherePlatformCrossProcessDataHelper;
import com.wily.powerpack.websphereMQ.agent.JCAConnectionPool.jmx.JMXDelegatingService;
import com.wily.powerpack.websphereMQ.agent.JCAConnectionPool.jmx.StandardMBeanServerLocator;
import com.wily.powerpack.websphereMQ.agent.JCAConnectionPool.pmi.MQPMIDelegatingService;
import com.wily.powerpack.websphereMQ.agent.JCAConnectionPool.websphere.AdminServiceBean;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Properties;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public final class IntroscopeMQCustomService
implements CustomService {
    private static final String kJMXUsernamePropKey = "jmxusername";
    private static final String kJMXPasswordPropKey = "jmxpassword";
    private IAgent agent;
    private ServiceAdministrator serviceAdministrator;

    public void initialize(Properties configProperties) throws Exception {
        String password;
        this.agent = AgentShim.getAgentShim().IAgentShim_getAgent();
        String username = configProperties.getProperty(kJMXUsernamePropKey);
        AdminServiceNotificationListener listener = new AdminServiceNotificationListener(username, password = configProperties.getProperty(kJMXPasswordPropKey), configProperties, this.agent);
        if (!this.registerNotificationListener(listener)) {
            listener.handleNotification(null, null);
        } else {
            this.agent.IAgent_getModuleFeedback().debug("Successfully registered WebSphere appserver startup listener.");
        }
        this.serviceAdministrator = this.agent.IAgent_getServiceAdministrator();
        this.serviceAdministrator.registerServiceAsync(this.agent, "MQPMI", (IAgentService)new MQPMIDelegatingService(), new HashMap());
        boolean enableCrossJVMTracing = this.agent.IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.websphere.crossjvm");
        if (enableCrossJVMTracing) {
            WebSpherePlatformCrossProcessDataHelper helper = new WebSpherePlatformCrossProcessDataHelper(this.agent.IAgent_getModuleFeedback());
            this.agent.addCrossProcessDataHelper((IPlatformCrossProcessDataHelper)helper);
        }
    }

    public void shutdown() throws Exception {
    }

    private boolean registerNotificationListener(AdminServiceNotificationListener listener) {
        boolean result = false;
        String notificationType = this.getNotificationConstant();
        if (notificationType != null) {
            try {
                String queryString = "WebSphere:type=Server,process=" + AdminServiceBean.getAdminServiceProcessName() + ",*";
                ObjectName query = new ObjectName(queryString);
                NotificationFilterSupport filter = new NotificationFilterSupport();
                filter.enableType(notificationType);
                AdminService as = (AdminService)AdminServiceBean.getAdminService();
                as.addNotificationListenerExtended(query, (NotificationListener)listener, (NotificationFilter)filter, null);
                listener.setConfigured();
                result = true;
            }
            catch (Exception e) {
                this.agent.IAgent_getModuleFeedback().error("An error occurred while trying to register a notification listener in WebSphere");
                this.agent.IAgent_getModuleFeedback().debug((Throwable)e);
            }
        }
        return result;
    }

    private String getNotificationConstant() {
        String result = null;
        try {
            Class<?> c = Class.forName("com.ibm.websphere.management.NotificationConstants");
            Field f = c.getField("TYPE_J2EE_STATE_RUNNING");
            result = (String)f.get(null);
        }
        catch (Exception e) {
            this.agent.IAgent_getModuleFeedback().error((Throwable)e);
            result = null;
        }
        return result;
    }

    private class AdminServiceNotificationListener
    implements NotificationListener {
        private boolean isConfigured = false;
        private String username;
        private String password;
        private IAgent agent;
        private IModuleFeedbackChannel feedback;
        private Properties configProps;

        public AdminServiceNotificationListener(String username, String password, Properties configProps, IAgent agent) {
            this.username = username;
            this.password = password;
            this.agent = agent;
            this.feedback = agent.IAgent_getModuleFeedback();
            this.configProps = configProps;
        }

        public void setConfigured() {
            this.isConfigured = true;
        }

        public void handleNotification(Notification notUsedNot, Object notUsedHandle) {
            WebSphereJMXCustomizer customizer = new WebSphereJMXCustomizer();
            HashMap<Object, Object> serviceProps = new HashMap<Object, Object>();
            serviceProps.putAll(this.configProps);
            if (this.isConfigured) {
                Object shouldBeSubject = this.getSubjectFromLogin();
                serviceProps.put("com.wily.introscope.jmx.security.classname", "com.ibm.websphere.security.auth.WSSubject");
                serviceProps.put("com.wily.introscope.jmx.priveleged.methodname", "doAs");
                serviceProps.put("com.wily.introscope.jmx.securitysubject", shouldBeSubject);
            }
            serviceProps.put("IJMXCustomizer-Class", customizer);
            IntroscopeMQCustomService.this.serviceAdministrator.registerServiceAsync(this.agent, "JMX", (IAgentService)new JMXDelegatingService(), serviceProps);
        }

        public Object getSubjectFromLogin() {
            Object result = null;
            Module module = new Module("JMX.WebSphere");
            boolean debugOn = this.feedback.isDebugEnabled(module);
            if (this.username == null || this.password == null) {
                this.feedback.info(module, "No username or password configured for JMX, will try to get JMX metrics unauthenticated");
                return null;
            }
            try {
                Class<?> wsSecurityHelperCls;
                Method wsIsGlobalEnabledMethod;
                Object booleanResult;
                Boolean typedResult;
                Class.forName("javax.security.auth.Subject");
                if (debugOn) {
                    this.feedback.debug(module, "Will attempt to get Subject from login");
                }
                if ((typedResult = (Boolean)(booleanResult = (wsIsGlobalEnabledMethod = (wsSecurityHelperCls = Class.forName("com.ibm.websphere.security.WSSecurityHelper")).getDeclaredMethod("isGlobalSecurityEnabled", null)).invoke(null, null))).booleanValue()) {
                    Method getSubjMethod;
                    Object subjObj;
                    if (debugOn) {
                        this.feedback.debug(module, "Global security is enabled in WebSphere");
                    }
                    Class<?> cbhCls = Class.forName("com.ibm.websphere.security.auth.callback.WSCallbackHandlerImpl");
                    Class[] cbhArgTypes = new Class[]{String.class, String.class};
                    Constructor<?> cbhCtor = cbhCls.getConstructor(cbhArgTypes);
                    Object[] cbhCtorArgs = new Object[]{this.username, this.password};
                    Object handler = cbhCtor.newInstance(cbhCtorArgs);
                    Class<?> lcCls = Class.forName("javax.security.auth.login.LoginContext");
                    Class<?> cbhJDKCls = Class.forName("javax.security.auth.callback.CallbackHandler");
                    Class[] lcCtorArgTypes = new Class[]{String.class, cbhJDKCls};
                    Constructor<?> lcCtor = lcCls.getConstructor(lcCtorArgTypes);
                    Object[] lcCtorArgs = new Object[]{"WSLogin", handler};
                    Object loginCtx = lcCtor.newInstance(lcCtorArgs);
                    Method loginMethod = loginCtx.getClass().getMethod("login", null);
                    loginMethod.invoke(loginCtx, null);
                    if (debugOn) {
                        this.feedback.debug(module, "Successfully logged in with provided credentials");
                    }
                    if ((subjObj = (getSubjMethod = loginCtx.getClass().getMethod("getSubject", null)).invoke(loginCtx, null)) != null) {
                        if (debugOn) {
                            this.feedback.debug(module, "Got a Subject, will attempt to access JMX metrics with provided credentials.");
                        }
                        result = subjObj;
                    }
                }
            }
            catch (Exception e) {
                this.feedback.debug((Throwable)e);
            }
            return result;
        }
    }

    private class WebSphereJMXCustomizer
    implements IJMXCustomizer {
        private final IMBeanServerLocator[] locators = new IMBeanServerLocator[]{new StandardMBeanServerLocator()};

        public IMBeanServerLocator[] getMBeanServerLocators(IAgent agent) {
            return this.locators;
        }

        public String[] modifyFilters(IAgent agent, String[] filterKeys) {
            return filterKeys;
        }
    }
}

