/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.action;

import com.wily.ui.action.AExtendedActionWrapper;
import com.wily.ui.action.ExtendedActionException;
import com.wily.ui.action.ExtendedActionMonitor;
import com.wily.ui.action.IExtendedAction;
import com.wily.wilyassert.Assertion;
import java.awt.event.ActionEvent;

public class LinkedExtendedActionWrapper
extends AExtendedActionWrapper {
    private static final long serialVersionUID = -2360280619969021451L;
    private ExtendedActionMonitor fActionMonitor;
    private LinkedExtendedActionWrapper fPeerLinkedExtendedActionWrapper;

    public LinkedExtendedActionWrapper(IExtendedAction action, ExtendedActionMonitor actionMonitor) {
        super(action);
        this.fActionMonitor = actionMonitor;
    }

    public void doTriggerAction(ActionEvent actionEvent) throws ExtendedActionException {
        super.doTriggerAction(actionEvent);
        if (!this.IExtendedAction_wasCancelled()) {
            this.addSelfToActionMonitor();
        }
    }

    public void doUndoAction() throws ExtendedActionException {
        super.doUndoAction();
        this.undoPeerActionIfAppropriate();
    }

    public void doRedoAction() throws ExtendedActionException {
        super.doRedoAction();
        this.redoPeerActionIfAppropriate();
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Can't clone LinkedExtendedActionWrappers");
    }

    public void addSelfToActionMonitor() {
        this.fActionMonitor.addExtendedAction(this);
    }

    private void undoPeerActionIfAppropriate() {
        if (this.fPeerLinkedExtendedActionWrapper != null) {
            try {
                this.fPeerLinkedExtendedActionWrapper.undoSelfForLinkIfAppropriate();
            }
            catch (ExtendedActionException ae) {
                Assertion.wilyAssert(false, "linked undo failed for unkown reason");
            }
        }
    }

    private void redoPeerActionIfAppropriate() {
        if (this.fPeerLinkedExtendedActionWrapper != null) {
            try {
                this.fPeerLinkedExtendedActionWrapper.redoSelfForLinkIfAppropriate();
            }
            catch (ExtendedActionException ae) {
                Assertion.wilyAssert(false, "linked redo failed for unkown reason");
            }
        }
    }

    private void undoSelfForLinkIfAppropriate() throws ExtendedActionException {
        if (this.fActionMonitor.peekNextUndo() == this) {
            this.fActionMonitor.undo();
        }
    }

    private void redoSelfForLinkIfAppropriate() throws ExtendedActionException {
        if (this.fActionMonitor.peekNextRedo() == this) {
            this.fActionMonitor.redo();
        }
    }

    public void setPeerLinkedExtendedAction(LinkedExtendedActionWrapper peerLinkedExtendedActionWrapper) {
        this.fPeerLinkedExtendedActionWrapper = peerLinkedExtendedActionWrapper;
    }
}

