/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.processes.tracer.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.trace.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.soaextension.tibcobw.KConstants;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.soaextension.tibcobw.TibcoMBBSUtil;
import com.wily.soaextension.tibcobw.TibcoTracerUtil;
import com.wily.util.properties.AttributeListing;

public class JobErrorTracer
extends ASingleMetricTracerFactory
implements KConstants {
    private static final String tracerName = "JobErrorTracer";

    public JobErrorTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    protected final IDataAccumulator createDataAccumulator(String formattedMetricName) {
        return null;
    }

    public void ITracer_finishTrace(int i, InvocationData data) {
    }

    public void ITracer_startTrace(int i, InvocationData data) {
        ProbeIdentification probIdentification = data.getProbeInformation().getProbeIdentification();
        boolean threw = false;
        boolean handleerror = false;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        if (data.hasInvocationThrownException()) {
            threw = true;
        }
        if (probIdentification.getProbeMethodName().equalsIgnoreCase("handleError")) {
            handleerror = true;
        }
        if (threw || handleerror) {
            Throwable error = null;
            error = threw ? data.getInvocationThrownException() : (Throwable)data.getInvocationParameterAsObject(2);
            String component = this.formatParameterizedResource(data);
            String errorMessage = String.valueOf(component) + ": " + error.getMessage();
            IStackElement topElement = VirtualStack.peek();
            if (topElement != null) {
                ErrorFeature.constructAndSendErrorSnapshotToServerWithOtherStackElementOnTop((InvocationData)data, (String)errorMessage, (IAgent)this.getAgent(), (IStackElement)topElement);
                ErrorFeature.decorateTransactionsWithErrorOnOtherStackElement((InvocationData)data, (String)errorMessage, (IStackElement)topElement);
            }
            if (data.getCursor() != null) {
                ErrorFeature.incrementErrorMetric((IStackElement)data);
            } else {
                IRepository errorsRepository = TibcoTracerUtil.createErrorsRespository(component, this.getDataAccumulatorFactory());
                TibcoTracerUtil.updateErrorMetric(errorsRepository, data);
            }
            if (TibcoBWUtils.isMBBSEnabled()) {
                String correlationId = this.getComponentTracer().getCrossProcessDataCache().getCorrelationID();
                WilyTransactionElement frontendNode = (WilyTransactionElement)TibcoMBBSUtil.getFrontend(correlationId);
                if (frontendNode != null) {
                    ErrorFeature.incrementErrorMetric((WilyTransactionElement)frontendNode, (IStackElement)data);
                } else {
                    TibcoBWUtils.getLogger().warn("No Frontend available for BP: " + component + " This is either a spawned process or subprocess of a spawned process.");
                }
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug(tracerName + errorMessage);
            }
        }
    }
}

