/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.jmx;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.jmx.IJMXDataView;
import com.wily.introscope.agent.jmx.JMXDataUnavailableException;
import com.wily.introscope.agent.stat.AccumulatorAlreadyExistsException;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public abstract class AJMXDataView
implements IJMXDataView {
    private String fSourceAttribute;
    private ObjectName fSourceObjectName;
    private MBeanServer fServer;
    private int fNumConsecutiveExceptionsEncountered;
    private IAgent fAgent;
    static final int kMaxAllowableExceptionCount = 2;

    protected AJMXDataView(IAgent agent, ObjectName on, MBeanServer server, String attributeName) {
        this.fAgent = agent;
        this.fSourceAttribute = attributeName;
        this.fServer = server;
        this.fSourceObjectName = on;
        this.fNumConsecutiveExceptionsEncountered = 0;
    }

    protected ObjectName getSourceObjectName() {
        return this.fSourceObjectName;
    }

    protected MBeanServer getSourceServer() {
        return this.fServer;
    }

    protected String getSourceAttribute() {
        return this.fSourceAttribute;
    }

    protected IAgent getAgent() {
        return this.fAgent;
    }

    protected void clearExceptionCount() {
        this.fNumConsecutiveExceptionsEncountered = 0;
    }

    protected void incrementExceptionCount() {
        ++this.fNumConsecutiveExceptionsEncountered;
    }

    protected void throwIfExceptionCountIsExcessive() throws JMXDataUnavailableException {
        if (this.fNumConsecutiveExceptionsEncountered >= 2) {
            throw new JMXDataUnavailableException(this.fSourceObjectName, this.fSourceAttribute);
        }
    }

    public final void IJMXDataView_destroy() {
        this.fSourceAttribute = null;
        this.fServer = null;
        this.fSourceObjectName = null;
        this.doDestroy();
    }

    public final void IJMXDataView_clear() {
        this.doDestroy();
    }

    public boolean IJMXDataView_update() throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        IDataAccumulator accum = this.getAccumulator();
        if (!this.isVirtual() && accum != null && this.fAgent.IAgent_isMetricShutOff(accum.IDataAccumulator_getMetric())) {
            return true;
        }
        Object objectValue = null;
        if (this.getSourceServer() != null && this.getSourceObjectName() != null && this.getSourceAttribute() != null) {
            objectValue = this.getSourceServer().getAttribute(this.getSourceObjectName(), this.getSourceAttribute());
        }
        if (objectValue != null) {
            this.doUpdate(objectValue);
        }
        return objectValue != null;
    }

    protected boolean isVirtual() {
        return false;
    }

    protected abstract void doDestroy();

    protected IDataAccumulator getAccumulator() throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        return this.getAccumulator(false);
    }

    protected abstract IDataAccumulator getAccumulator(boolean var1) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException;

    protected abstract void doUpdate(Object var1) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException;

    public String toString() {
        String fullClassName = this.getClass().getName();
        int lastDotIndex = fullClassName.lastIndexOf(46);
        String simpleName = fullClassName.substring(lastDotIndex + 1);
        return "[" + simpleName + ": attr=" + this.fSourceAttribute.toString() + "]";
    }
}

