/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.jmx;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.jmx.AJMXDataView;
import com.wily.introscope.agent.jmx.ANameConverter;
import com.wily.introscope.agent.jmx.AllSortedKeysNameConverter;
import com.wily.introscope.agent.jmx.DataViewFactory;
import com.wily.introscope.agent.jmx.Filter;
import com.wily.introscope.agent.jmx.IJMXCustomizer;
import com.wily.introscope.agent.jmx.IJMXDataView;
import com.wily.introscope.agent.jmx.IMBeanNameConverter;
import com.wily.introscope.agent.jmx.IMBeanServerLocator;
import com.wily.introscope.agent.jmx.IntroscopeProtocolAdaptorMBean;
import com.wily.introscope.agent.jmx.JMXDelegatingService;
import com.wily.introscope.agent.jmx.JSR77NameConverter;
import com.wily.introscope.agent.jmx.MBeanInterpreterJMXDataView;
import com.wily.introscope.agent.jmx.MBeanInterpreterJSR77;
import com.wily.introscope.agent.jmx.PrimaryKeysNameConverter;
import com.wily.introscope.agent.jmx.StandardMBeanServerLocator;
import com.wily.introscope.agent.jmx.WebLogicMBeanServerLocator;
import com.wily.introscope.agent.stat.AccumulatorAlreadyExistsException;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.task.ASimpleExecutableItem;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.security.auth.Subject;

public final class IntroscopeProtocolAdaptor
implements IntroscopeProtocolAdaptorMBean {
    private static final Module sModule = new Module("JMX Service");
    public static final String kProtocolAdaptorDomain = "com.wily.introscope.agent";
    public static final String kProtocolAdaptorNameKey = "name";
    public static final String kProtocolAdaptorNameValue = "IntroscopeProtocolAdaptor";
    public static boolean kNoSubStringMatch = false;
    private static final String kExcludeStringMetricsPropKey = "introscope.agent.jmx.excludeStringMetrics";
    public static MBeanInterpreterJSR77 interpreterJSR77 = new MBeanInterpreterJSR77();
    public static final String kRateCounterExtension = "_rate (per interval)";
    private static final String kDescription = "Introscope JMX Agent Protocol Adaptor";
    private static final String kJMXBehaviorName = "Introscope JMX Protocol Adaptor";
    private static final String kMBeanServerDelegateName = "JMImplementation:type=MBeanServerDelegate";
    private static IAgent fAgent;
    private ObjectName fDelegateObjectName;
    private IMBeanNameConverter fPrimaryNameConverter;
    private IMBeanNameConverter fSecondaryNameConverter;
    private final IMBeanServerLocator[] fServerLocators;
    private Filter[] fFilters;
    private Filter[] fRateCounterFilters;
    private HashSet fIgnoreAttributes;
    private HashMap fViewsHashMap;
    private HashSet fServersHashSet;
    private final IntroscopeNotificationListener fNotificationListener;
    private final IntroscopeProtocolAdaptorHeartbeatBehavior fBehavior;
    private final ClassLoader fContextClassLoader;
    private IJMXCustomizer fJMXCustomizer = null;
    private static Object fSubject;
    private final FindServersAndPollViewsAction fFindServersAndPollViewsAction;
    private AccessControlContext fAccessControlContext;
    private boolean allowLegacyJSR77 = false;
    private boolean fExcludeStringMetrics;
    private String fSecurityClassName;
    private String fPrivelegedMethodName;
    private Method fPrivelegedMethod;
    private static final String kSyncWithAllMbeanServersForcibly = "com.wily.introcope.agent.jmx.syncWithAllMbeanServersForcibly";
    private static boolean fSyncWithAllMbeanServersForcibly;
    private static boolean fCanRunForcedDiscovery;
    static /* synthetic */ Class class$0;

    static {
        fSyncWithAllMbeanServersForcibly = false;
        fCanRunForcedDiscovery = false;
    }

    public IntroscopeProtocolAdaptor(IAgent agent) {
        this(agent, null);
    }

    public IntroscopeProtocolAdaptor(IAgent agent, IJMXCustomizer customizer) {
        this(agent, customizer, null, null, null, null);
    }

    public IntroscopeProtocolAdaptor(IAgent agent, IJMXCustomizer customizer, Object shouldBeSubject, String securityClassName, String privelegedMethodName, AccessControlContext acc) {
        this.fJMXCustomizer = customizer;
        fAgent = agent;
        this.fNotificationListener = new IntroscopeNotificationListener();
        fSubject = (Subject)shouldBeSubject;
        this.fSecurityClassName = securityClassName;
        this.fPrivelegedMethodName = privelegedMethodName;
        this.fAccessControlContext = acc;
        this.fServerLocators = this.fJMXCustomizer != null ? this.fJMXCustomizer.getMBeanServerLocators(fAgent) : new IMBeanServerLocator[]{new WebLogicMBeanServerLocator(agent), new StandardMBeanServerLocator()};
        try {
            this.fDelegateObjectName = new ObjectName(kMBeanServerDelegateName);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            Assertion.wilyAssert(false);
        }
        this.parseConfigProperties(agent.IAgent_getIndexedProperties());
        Assertion.wilyAssert(false);
        Assertion.wilyAssert(false);
        Assertion.wilyAssert(false);
        Assertion.wilyAssert(false);
        this.fViewsHashMap = new HashMap();
        this.fServersHashSet = new HashSet();
        try {
            fAgent.IAgent_getConfigurationManager().add(new MBeanForcedPollingEnabledProperty(fAgent), false);
        }
        catch (Exception exception) {}
        this.fBehavior = new IntroscopeProtocolAdaptorHeartbeatBehavior();
        this.fContextClassLoader = this.getClass().getClassLoader();
        this.fFindServersAndPollViewsAction = new FindServersAndPollViewsAction();
        this.fExcludeStringMetrics = agent.IAgent_getIndexedProperties().getBooleanProperty(kExcludeStringMetricsPropKey, true);
        this.fExcludeStringMetrics = agent.IAgent_getIndexedProperties().getBooleanProperty(kExcludeStringMetricsPropKey, true);
        MBeanForcedDiscoveryControllingService mbeanForcedDiscoveryControllingBehavior = new MBeanForcedDiscoveryControllingService();
        agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)mbeanForcedDiscoveryControllingBehavior, "MBean Forced Discovery Controlling Behaviour", true, 300000L, false);
    }

    private void parseConfigProperties(IndexedProperties props) {
        String[] defaultVal;
        String[] filterKeys = defaultVal = new String[0];
        String[] rateCounterFilterKeys = defaultVal;
        this.fIgnoreAttributes = new HashSet();
        String[] primaryKeys = defaultVal;
        String filterMessage = "";
        String primaryKeysMessage = "";
        boolean useJsr77Formatter = false;
        IModuleFeedbackChannel feedback = fAgent.IAgent_getModuleFeedback();
        IStringLocalizer localizer = fAgent.IAgent_getStringLocalizer();
        if (props != null) {
            useJsr77Formatter = !props.getBooleanProperty("introscope.agent.jmx.name.jsr77.disable", true);
            this.allowLegacyJSR77 = props.getBooleanProperty("introscope.agent.jmx.name.jsr77.legacy.enable", true);
            MBeanInterpreterJSR77.setEnabled(useJsr77Formatter);
            String[] ignoreAttributes = props.safeGetSeparatedProperty("introscope.agent.jmx.ignore.attributes", ",", defaultVal);
            int i = 0;
            while (i < ignoreAttributes.length) {
                this.fIgnoreAttributes.add(ignoreAttributes[i]);
                feedback.debug("Ignoring MBean attribute: " + ignoreAttributes[i]);
                ++i;
            }
            filterKeys = props.safeGetSeparatedProperty("introscope.agent.jmx.name.filter", ",", defaultVal);
            rateCounterFilterKeys = props.safeGetSeparatedProperty("introscope.agent.jmx.ratecounter.name.filter", ",", defaultVal);
            primaryKeys = props.safeGetSeparatedProperty("introscope.agent.jmx.name.primarykeys", ",", defaultVal);
            kNoSubStringMatch = props.getBooleanProperty("introscope.agent.jmx.filter.nosubstringmatch", false);
            primaryKeysMessage = props.getTrimmedProperty("introscope.agent.jmx.name.primarykeys", "");
            filterMessage = props.getTrimmedProperty("introscope.agent.jmx.name.filter", "");
            fSyncWithAllMbeanServersForcibly = props.getBooleanProperty(kSyncWithAllMbeanServersForcibly);
        }
        if (this.fJMXCustomizer != null) {
            filterKeys = this.fJMXCustomizer.modifyFilters(fAgent, filterKeys);
            rateCounterFilterKeys = this.fJMXCustomizer.modifyFilters(fAgent, rateCounterFilterKeys);
        }
        this.fFilters = new Filter[filterKeys.length];
        int i = 0;
        while (i < filterKeys.length) {
            this.fFilters[i] = new Filter(filterKeys[i]);
            ++i;
        }
        this.fRateCounterFilters = new Filter[rateCounterFilterKeys.length];
        i = 0;
        while (i < rateCounterFilterKeys.length) {
            this.fRateCounterFilters[i] = new Filter(rateCounterFilterKeys[i]);
            ++i;
        }
        if (useJsr77Formatter) {
            this.fPrimaryNameConverter = new JSR77NameConverter(primaryKeys);
        } else {
            this.fPrimaryNameConverter = new PrimaryKeysNameConverter(primaryKeys);
            String localizedPrimaryKeysMessage = localizer.IStringLocalizer_getFormattedLocalizedString("Agent_JMX_Primary_Keys_Info_Message", primaryKeysMessage);
            feedback.info(localizedPrimaryKeysMessage);
        }
        this.fSecondaryNameConverter = new AllSortedKeysNameConverter();
        String localizedFilterMessage = localizer.IStringLocalizer_getFormattedLocalizedString("Agent_JMX_Filter_Info_Message", filterMessage);
        feedback.info(localizedFilterMessage);
    }

    void registerHeartbeatBehavior(IntervalHeartbeat heartbeat) {
        Assertion.wilyAssert(false);
        if (JMXDelegatingService.sIsJMXMaxPollDurationEnabled) {
            heartbeat.addBehavior((ITimestampedRunnable)this.fBehavior, kJMXBehaviorName, true, 15000L, false);
        } else {
            heartbeat.addBehavior((ITimestampedRunnable)this.fBehavior, kJMXBehaviorName, true, 7500L, false);
        }
    }

    public String getDescription() {
        return kDescription;
    }

    public static String getIntroscopeProtocolAdaptorDomain() {
        return kProtocolAdaptorDomain;
    }

    public static ObjectName getIntroscopeProtocolAdaptorMBeanName() {
        try {
            return new ObjectName(kProtocolAdaptorDomain, kProtocolAdaptorNameKey, kProtocolAdaptorNameValue);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            Assertion.wilyAssert(false, "Protocol Adaptor name is malformed");
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setContextAndPoll() {
        Thread currentThread = Thread.currentThread();
        ClassLoader savedContext = currentThread.getContextClassLoader();
        try {
            block14: {
                currentThread.setContextClassLoader(this.fContextClassLoader);
                if (this.fAccessControlContext != null) {
                    AccessController.doPrivileged(this.fFindServersAndPollViewsAction, this.fAccessControlContext);
                } else if (fSubject == null) {
                    this.findServersAndPollViews();
                } else {
                    try {
                        Class<?> subjectClass = null;
                        subjectClass = Class.forName("javax.security.auth.Subject");
                        if (subjectClass.isInstance(fSubject)) {
                            if (this.fSecurityClassName == null || this.fPrivelegedMethodName == null) break block14;
                            fAgent.IAgent_getModuleFeedback().debug(sModule, "Found Subject = " + fSubject);
                            Class<?> securityClass = Class.forName(this.fSecurityClassName);
                            if (this.fPrivelegedMethod == null) {
                                Class[] classArray = new Class[2];
                                classArray[0] = subjectClass;
                                Class<?> clazz = class$0;
                                if (clazz == null) {
                                    try {
                                        clazz = class$0 = Class.forName("java.security.PrivilegedAction");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                classArray[1] = clazz;
                                this.fPrivelegedMethod = securityClass.getMethod(this.fPrivelegedMethodName, classArray);
                            }
                            this.fPrivelegedMethod.invoke(null, fSubject, this.fFindServersAndPollViewsAction);
                            break block14;
                        }
                        fAgent.IAgent_getModuleFeedback().error(sModule, "Got a Subject not an instance of javax.security.auth.Subject");
                    }
                    catch (Throwable t) {
                        fAgent.IAgent_getModuleFeedback().debug(sModule, "Unable to determine credentials, caught Throwable: ", t);
                    }
                }
            }
            Object var5_8 = null;
            currentThread.setContextClassLoader(savedContext);
            return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            currentThread.setContextClassLoader(savedContext);
            throw throwable;
        }
    }

    private synchronized void findServersAndPollViews() {
        try {
            int locatorIndex = 0;
            while (locatorIndex < this.fServerLocators.length) {
                MBeanServer[] servers = this.fServerLocators[locatorIndex].IMBeanServerLocator_locate();
                this.findAndAddMBeans(servers);
                ++locatorIndex;
            }
            this.pollViews();
        }
        catch (Exception e) {
            fAgent.IAgent_getModuleFeedback().error("An error occurred polling JMX data.");
            fAgent.IAgent_getModuleFeedback().verbose(e);
        }
    }

    private void findAndAddMBeans(MBeanServer[] servers) {
        int serverII = 0;
        while (serverII < servers.length) {
            MBeanServer currentServer = servers[serverII];
            boolean newServer = false;
            if (!this.fServersHashSet.contains(currentServer)) {
                this.fServersHashSet.add(currentServer);
                try {
                    currentServer.addNotificationListener(this.fDelegateObjectName, this.fNotificationListener, null, (Object)currentServer);
                    newServer = true;
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    Assertion.wilyAssert(false);
                }
            }
            if (newServer || fSyncWithAllMbeanServersForcibly && fCanRunForcedDiscovery) {
                fCanRunForcedDiscovery = false;
                Set<Object> objectNames = new HashSet();
                try {
                    objectNames = currentServer.queryNames(null, null);
                }
                catch (Exception e) {
                    fAgent.IAgent_getModuleFeedback().debug("Error querying the m bean server" + currentServer, e);
                }
                try {
                    Iterator<Object> iterator = objectNames.iterator();
                    while (iterator.hasNext()) {
                        this.addMBean((ObjectName)iterator.next(), currentServer);
                    }
                }
                catch (Exception exception) {}
            }
            ++serverII;
        }
    }

    private void pollViews() {
        Iterator objectNameItr = this.fViewsHashMap.keySet().iterator();
        while (objectNameItr.hasNext()) {
            Object objName = objectNameItr.next();
            Set viewsHash = (Set)this.fViewsHashMap.get(objName);
            Iterator iterator = viewsHash.iterator();
            while (iterator.hasNext()) {
                IJMXDataView view = (IJMXDataView)iterator.next();
                try {
                    if (view.IJMXDataView_update()) continue;
                    if (fAgent.IAgent_getModuleFeedback().isDebugEnabled(sModule)) {
                        fAgent.IAgent_getModuleFeedback().debug(sModule, "JMX data unavailable for " + view.getFullMetricName() + ", this may be a transient failure");
                    }
                    view.IJMXDataView_clear();
                }
                catch (Throwable t) {
                    fAgent.IAgent_getModuleFeedback().debug(sModule, "Error getting MBean info, this may be a transient failure");
                    fAgent.IAgent_getModuleFeedback().trace(sModule, view.getFullMetricName(), t);
                    view.IJMXDataView_destroy();
                    iterator.remove();
                    break;
                }
            }
            if (!viewsHash.isEmpty()) continue;
            objectNameItr.remove();
        }
    }

    private void addMBean2(ObjectName objectName, MBeanServer server) {
        block11: {
            if (this.fAccessControlContext != null) {
                AccessController.doPrivileged(new AddMBeanAction(objectName, server), this.fAccessControlContext);
            } else if (fSubject == null) {
                this.addMBean(objectName, server);
            } else {
                try {
                    Class<?> subjectClass = null;
                    subjectClass = Class.forName("javax.security.auth.Subject");
                    if (subjectClass.isInstance(fSubject)) {
                        if (this.fSecurityClassName == null || this.fPrivelegedMethodName == null) break block11;
                        fAgent.IAgent_getModuleFeedback().info(sModule, "Found Subject = " + fSubject);
                        Class<?> securityClass = Class.forName(this.fSecurityClassName);
                        if (this.fPrivelegedMethod == null) {
                            Class[] classArray = new Class[2];
                            classArray[0] = subjectClass;
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = class$0 = Class.forName("java.security.PrivilegedAction");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            classArray[1] = clazz;
                            this.fPrivelegedMethod = securityClass.getMethod(this.fPrivelegedMethodName, classArray);
                        }
                        this.fPrivelegedMethod.invoke(null, fSubject, new AddMBeanAction(objectName, server));
                        fAgent.IAgent_getModuleFeedback().debug("Successfully invoked javax.security.auth.Subject.doAs(subject, AddMBeanAction)");
                        break block11;
                    }
                    fAgent.IAgent_getModuleFeedback().info(sModule, "Got a Subject not an instance of javax.security.auth.Subject");
                }
                catch (Throwable t) {
                    fAgent.IAgent_getModuleFeedback().info(sModule, "Unable to determine credentials, caught Throwable: ", t);
                }
            }
        }
    }

    private void removeMBean2(ObjectName objectName, MBeanServer server) {
        block11: {
            if (this.fAccessControlContext != null) {
                AccessController.doPrivileged(new RemoveMBeanAction(objectName, server), this.fAccessControlContext);
            } else if (fSubject == null) {
                this.removeMBean(objectName, server);
            } else {
                try {
                    Class<?> subjectClass = null;
                    subjectClass = Class.forName("javax.security.auth.Subject");
                    if (subjectClass.isInstance(fSubject)) {
                        if (this.fSecurityClassName == null || this.fPrivelegedMethodName == null) break block11;
                        fAgent.IAgent_getModuleFeedback().info(sModule, "Found Subject = " + fSubject);
                        Class<?> securityClass = Class.forName(this.fSecurityClassName);
                        if (this.fPrivelegedMethod == null) {
                            Class[] classArray = new Class[2];
                            classArray[0] = subjectClass;
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = class$0 = Class.forName("java.security.PrivilegedAction");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            classArray[1] = clazz;
                            this.fPrivelegedMethod = securityClass.getMethod(this.fPrivelegedMethodName, classArray);
                        }
                        this.fPrivelegedMethod.invoke(null, fSubject, new RemoveMBeanAction(objectName, server));
                        fAgent.IAgent_getModuleFeedback().debug("Successfully invoked javax.security.auth.Subject.doAs(subject, RemoveMBeanAction)");
                        break block11;
                    }
                    fAgent.IAgent_getModuleFeedback().info(sModule, "Got a Subject not an instance of javax.security.auth.Subject");
                }
                catch (Throwable t) {
                    fAgent.IAgent_getModuleFeedback().info(sModule, "Unable to determine credentials, caught Throwable: ", t);
                }
            }
        }
    }

    private synchronized void addMBean(ObjectName objectName, MBeanServer server) {
        String domain = objectName.getDomain();
        if (domain != null && IntroscopeProtocolAdaptor.getIntroscopeProtocolAdaptorDomain().equals(domain)) {
            return;
        }
        if (objectName.isPattern()) {
            return;
        }
        if (objectName.equals(this.fDelegateObjectName)) {
            return;
        }
        if (this.haveAlreadySeenObjectName(objectName)) {
            return;
        }
        String resourceName = this.getIntroscopeResourceName(objectName);
        MBeanInfo beanInfo = null;
        try {
            beanInfo = server.getMBeanInfo(objectName);
        }
        catch (Exception e) {
            fAgent.IAgent_getModuleFeedback().debug(sModule, "Error getting MBeanInfo", e);
            return;
        }
        if (beanInfo == null) {
            return;
        }
        MBeanAttributeInfo[] attInfo = beanInfo.getAttributes();
        if (attInfo == null) {
            return;
        }
        HashSet<AJMXDataView> viewsSet = new HashSet<AJMXDataView>();
        int attributeII = 0;
        while (attributeII < attInfo.length) {
            block24: {
                if (attInfo[attributeII].isReadable()) {
                    String attName = attInfo[attributeII].getName();
                    String attType = attInfo[attributeII].getType();
                    if (attName != null && attType != null) {
                        StringBuffer tmpName = new StringBuffer(resourceName);
                        tmpName.append(':');
                        tmpName.append(attName);
                        ANameConverter.replaceTrailingWhitespace(tmpName);
                        String fullIntroscopeMetricName = tmpName.toString();
                        if (this.shouldPollMetric(fullIntroscopeMetricName, attName) || this.shouldPollRateCounterMetric(fullIntroscopeMetricName, attName)) {
                            try {
                                boolean isLegacyJSR77;
                                if (interpreterJSR77.isAvailable() && interpreterJSR77.isQualified(attType)) {
                                    int colonPos = fullIntroscopeMetricName.lastIndexOf(":");
                                    String rootIntroscopeMetricName = colonPos < 0 ? fullIntroscopeMetricName : fullIntroscopeMetricName.substring(0, colonPos);
                                    MBeanInterpreterJMXDataView view = null;
                                    if (!this.haveAlreadySeenObjectName(objectName)) {
                                        if (this.shouldPollMetric(fullIntroscopeMetricName, attName) && (view = new MBeanInterpreterJMXDataView(fAgent, objectName, server, attName, rootIntroscopeMetricName, interpreterJSR77, false)) != null) {
                                            viewsSet.add(view);
                                        }
                                        if (this.shouldPollRateCounterMetric(fullIntroscopeMetricName, attName) && (view = new MBeanInterpreterJMXDataView(fAgent, objectName, server, attName, rootIntroscopeMetricName = String.valueOf(rootIntroscopeMetricName) + kRateCounterExtension, interpreterJSR77, true)) != null) {
                                            viewsSet.add(view);
                                        }
                                    }
                                    break block24;
                                }
                                boolean bl = isLegacyJSR77 = fullIntroscopeMetricName.indexOf("|JSR77|") >= 0;
                                if (!this.allowLegacyJSR77 && isLegacyJSR77) break block24;
                                AJMXDataView view = null;
                                if (this.haveAlreadySeenObjectName(objectName)) break block24;
                                try {
                                    if (this.shouldPollMetric(fullIntroscopeMetricName, attName)) {
                                        view = DataViewFactory.createView(fAgent, objectName, attType, attName, server, fullIntroscopeMetricName, this.fExcludeStringMetrics, false);
                                    }
                                    if (view != null) {
                                        viewsSet.add(view);
                                    }
                                    if (this.shouldPollRateCounterMetric(fullIntroscopeMetricName, attName)) {
                                        fullIntroscopeMetricName = String.valueOf(fullIntroscopeMetricName) + kRateCounterExtension;
                                        view = DataViewFactory.createView(fAgent, objectName, attType, attName, server, fullIntroscopeMetricName, this.fExcludeStringMetrics, true);
                                    }
                                    if (view != null) {
                                        viewsSet.add(view);
                                    }
                                }
                                catch (AccumulatorAlreadyExistsException ae) {
                                    fAgent.IAgent_getModuleFeedback().debug(ae.getLocalizedMessage());
                                }
                            }
                            catch (Exception e) {
                                IStringLocalizer localizer = fAgent.IAgent_getStringLocalizer();
                                String message = localizer.IStringLocalizer_getFormattedLocalizedString("Agent_JMX_Could_Not_Create_View_Message", fullIntroscopeMetricName, String.valueOf(objectName.toString()) + " " + attName + " " + attType);
                                fAgent.IAgent_safeReportError(message, (Throwable)e);
                            }
                        }
                    }
                }
            }
            ++attributeII;
        }
        this.addViews(objectName, viewsSet);
    }

    private boolean shouldPollMetric(String metricName, String attName) {
        Assertion.wilyAssert(false);
        Assertion.wilyAssert(false);
        if (this.fIgnoreAttributes.contains(attName)) {
            return false;
        }
        if (this.fFilters.length == 0) {
            return true;
        }
        int i = 0;
        while (i < this.fFilters.length) {
            Filter filter = this.fFilters[i];
            if (filter.matches(metricName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean shouldPollRateCounterMetric(String metricName, String attName) {
        Assertion.wilyAssert(false);
        if (!JMXDelegatingService.sIsJMXRateCounterEnabled) {
            return false;
        }
        if (this.fRateCounterFilters.length == 0) {
            return this.shouldPollMetric(metricName, attName);
        }
        int i = 0;
        while (i < this.fRateCounterFilters.length) {
            Filter filter = this.fRateCounterFilters[i];
            if (filter.matches(metricName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getIntroscopeResourceName(ObjectName on) {
        String result = null;
        if (this.fPrimaryNameConverter.IMBeanNameConverter_canConvert(on)) {
            result = this.fPrimaryNameConverter.IMBeanNameConverter_convert(on);
        } else {
            Assertion.wilyAssert(false);
            result = this.fSecondaryNameConverter.IMBeanNameConverter_convert(on);
        }
        return result;
    }

    private synchronized void addViews(ObjectName on, Set viewsSet) {
        if (!this.haveAlreadySeenObjectName(on)) {
            Assertion.wilyAssert(false);
            this.fViewsHashMap.put(on, viewsSet);
        }
    }

    private synchronized HashSet removeViews(ObjectName on) {
        Assertion.wilyAssert(false);
        return (HashSet)this.fViewsHashMap.remove(on);
    }

    private synchronized boolean haveAlreadySeenObjectName(ObjectName on) {
        return this.fViewsHashMap.containsKey(on);
    }

    private synchronized void removeMBean(ObjectName on, MBeanServer server) {
        HashSet views = this.removeViews(on);
        if (views == null) {
            return;
        }
        Iterator iterator = views.iterator();
        while (iterator.hasNext()) {
            ((IJMXDataView)iterator.next()).IJMXDataView_destroy();
        }
    }

    IMBeanNameConverter debug_getSecondaryNameConverter() {
        return this.fSecondaryNameConverter;
    }

    int debug_getNumberOfMBeans() {
        return this.fViewsHashMap.size();
    }

    int debug_getNumberOfViewsForMBean(ObjectName on, MBeanServer server) {
        HashSet views = (HashSet)this.fViewsHashMap.get(on);
        return views.size();
    }

    boolean debug_locatedMBeanServer(MBeanServer server) {
        return this.fServersHashSet.contains(server);
    }

    int debug_getNumberLocatedMBeanServers() {
        return this.fServersHashSet.size();
    }

    void debug_parseConfigProperties(IndexedProperties props) {
        this.parseConfigProperties(props);
    }

    boolean debug_shouldPollMetric(String fullIntroscopeMetricName) {
        return this.shouldPollMetric(fullIntroscopeMetricName, null);
    }

    void debug_findServersAndPollViews() {
        this.setContextAndPoll();
    }

    static /* synthetic */ void access$6(IntroscopeProtocolAdaptor introscopeProtocolAdaptor, ObjectName objectName, MBeanServer mBeanServer) {
        introscopeProtocolAdaptor.addMBean2(objectName, mBeanServer);
    }

    static /* synthetic */ void access$7(IntroscopeProtocolAdaptor introscopeProtocolAdaptor, ObjectName objectName, MBeanServer mBeanServer) {
        introscopeProtocolAdaptor.removeMBean2(objectName, mBeanServer);
    }

    private class AddMBeanAction
    implements PrivilegedAction {
        final ObjectName fObjectName;
        final MBeanServer fMBeanServer;

        private AddMBeanAction(ObjectName objectName, MBeanServer server) {
            this.fObjectName = objectName;
            this.fMBeanServer = server;
        }

        public Object run() {
            IntroscopeProtocolAdaptor.this.addMBean(this.fObjectName, this.fMBeanServer);
            return null;
        }
    }

    private class FindServersAndPollViewsAction
    implements PrivilegedAction {
        private FindServersAndPollViewsAction() {
        }

        public Object run() {
            IntroscopeProtocolAdaptor.this.findServersAndPollViews();
            return null;
        }
    }

    private final class IntroscopeNotificationListener
    implements NotificationListener {
        private IntroscopeNotificationListener() {
        }

        public void handleNotification(Notification notification, Object server) {
            try {
                Assertion.wilyAssert(false);
                Assertion.wilyAssert(false);
                if (notification instanceof MBeanServerNotification) {
                    MBeanServerNotification mbsn = (MBeanServerNotification)notification;
                    if (mbsn.getType().equals("JMX.mbean.registered")) {
                        fAgent.IAgent_getSharedAsyncQueue().IExecutionQueue_addExecutableItem(new ASimpleExecutableItem(this, mbsn, server){
                            final /* synthetic */ IntroscopeNotificationListener this$1;
                            private final /* synthetic */ MBeanServerNotification val$mbsn;
                            private final /* synthetic */ Object val$server;
                            {
                                this.this$1 = introscopeNotificationListener;
                                this.val$mbsn = mBeanServerNotification;
                                this.val$server = object;
                            }

                            public void IExecutableItem_execute() {
                                IntroscopeProtocolAdaptor.access$6(IntroscopeNotificationListener.access$1(this.this$1), this.val$mbsn.getMBeanName(), (MBeanServer)this.val$server);
                            }
                        });
                    } else if (notification.getType().equals("JMX.mbean.unregistered")) {
                        fAgent.IAgent_getSharedAsyncQueue().IExecutionQueue_addExecutableItem(new ASimpleExecutableItem(this, mbsn, server){
                            final /* synthetic */ IntroscopeNotificationListener this$1;
                            private final /* synthetic */ MBeanServerNotification val$mbsn;
                            private final /* synthetic */ Object val$server;
                            {
                                this.this$1 = introscopeNotificationListener;
                                this.val$mbsn = mBeanServerNotification;
                                this.val$server = object;
                            }

                            public void IExecutableItem_execute() {
                                IntroscopeProtocolAdaptor.access$7(IntroscopeNotificationListener.access$1(this.this$1), this.val$mbsn.getMBeanName(), (MBeanServer)this.val$server);
                            }
                        });
                    }
                }
            }
            catch (Throwable t) {
                try {
                    fAgent.IAgent_safeReportError(fAgent.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_JMX_Error_Handling_Notification_Message"), t);
                }
                catch (Throwable throwable) {}
            }
        }

        static /* synthetic */ IntroscopeProtocolAdaptor access$1(IntroscopeNotificationListener introscopeNotificationListener) {
            return introscopeNotificationListener.IntroscopeProtocolAdaptor.this;
        }
    }

    private final class IntroscopeProtocolAdaptorHeartbeatBehavior
    implements ITimestampedRunnable {
        private IntroscopeProtocolAdaptorHeartbeatBehavior() {
        }

        public void ITimestampedRunnable_execute(long nowInMillis) {
            IntroscopeProtocolAdaptor.this.setContextAndPoll();
        }
    }

    private final class MBeanForcedDiscoveryControllingService
    implements ITimestampedRunnable {
        private MBeanForcedDiscoveryControllingService() {
        }

        public void ITimestampedRunnable_execute(long nowInMillis) {
            fCanRunForcedDiscovery = true;
        }
    }

    static final class MBeanForcedPollingEnabledProperty
    extends BooleanConfigurationProperty {
        public MBeanForcedPollingEnabledProperty(IAgent agent) {
            super(IntroscopeProtocolAdaptor.kSyncWithAllMbeanServersForcibly, new Boolean(false), fAgent.IAgent_getModuleFeedback(), sModule, fAgent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            fSyncWithAllMbeanServersForcibly = (Boolean)newValue;
        }
    }

    private class RemoveMBeanAction
    implements PrivilegedAction {
        final ObjectName fObjectName;
        final MBeanServer fMBeanServer;

        private RemoveMBeanAction(ObjectName objectName, MBeanServer server) {
            this.fObjectName = objectName;
            this.fMBeanServer = server;
        }

        public Object run() {
            IntroscopeProtocolAdaptor.this.removeMBean(this.fObjectName, this.fMBeanServer);
            return null;
        }
    }
}

