/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.appmap.agent.trace.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.activation.IOSGiClassPlugin;
import com.wily.introscope.agent.blame.IAppMapStack;
import com.wily.introscope.agent.blame.IStackType;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.ICacheableInvocationDataTracerFactory;
import com.wily.introscope.agent.trace.IMetricNameFormatListener;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.hc2.HttpServletTracer;
import com.wily.introscope.agent.transactiontrace.CrossCorrelationStringParameterProvider;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.appmap.agent.AppMapService;
import com.wily.introscope.appmap.agent.trace.AppMapCrossProcessHelper;
import com.wily.introscope.appmap.agent.trace.AppMapNameHelperFactory;
import com.wily.introscope.appmap.agent.trace.IAppMapNameHelper;
import com.wily.introscope.appmap.agent.trace.hc2.AppMapApplicationNameFormatter;
import com.wily.introscope.appmap.agent.trace.hc2.IAppMapReplayerTracer;
import com.wily.introscope.spec.server.appmap.IAppMapOwner;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;

public class AppMapApplicationNameTracer
extends ASingleInstanceTracerFactory
implements ICacheableInvocationDataTracerFactory,
IOSGiClassPlugin,
IAppMapReplayerTracer,
CrossCorrelationStringParameterProvider {
    private static final String kName = "hc2.AppMapApplicationNameTracer";
    private static final Module kModule = new Module("hc2.AppMapApplicationNameTracer");
    public static final String kNewAppMapNameKey = "AppMap.NewName";
    private static final String kCharEncodingPropKey = "introscope.agent.charEncoding";
    protected boolean fTracingEnabled;
    private boolean fIsShutoff = false;
    private String fOwnerType;
    private String fEncoding;
    private IAppMapNameHelper fNameHelper = null;
    private boolean canUseStaticNameFormatter = false;
    static /* synthetic */ Class class$0;

    public AppMapApplicationNameTracer() {
    }

    public AppMapApplicationNameTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        try {
            this.fOwnerType = this.getParameter("ownerType");
            this.fIsShutoff = this.fOwnerType == null || !"Application".equals(this.fOwnerType) && !"BusinessTransactionComponent".equals(this.fOwnerType);
            this.fEncoding = this.getAgent().IAgent_getIndexedProperties().getProperty(kCharEncodingPropKey);
            this.fNameHelper = AppMapNameHelperFactory.getNameHelper(this.getAgent(), this.fOwnerType);
            this.fIsShutoff = false;
        }
        catch (Throwable t) {
            this.getAgent().IAgent_getModuleFeedback().warn(kModule, "Tracer failed initialization");
            this.getAgent().IAgent_getModuleFeedback().verbose(kModule, "Tracer failed initialization", t);
            this.fIsShutoff = true;
        }
        if (this.fIsShutoff) {
            this.getAgent().IAgent_getModuleFeedback().warn("Tracer " + this.getNameParameter() + " cannot execute because of wrong owner type parameter " + this.fOwnerType);
        } else {
            INameFormatter formatter = this.getCustomNameFormatter();
            if (formatter != null && formatter instanceof AppMapApplicationNameFormatter) {
                this.canUseStaticNameFormatter = true;
            }
        }
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (!this.fTracingEnabled) {
            return;
        }
        if (!this.isCrossProcessSupportRequired()) {
            return;
        }
        String componentName = data.getComponentNameAt(tracerIndex);
        if (componentName != null) {
            IAppMapOwner owner = this.getNameHelper().getOwnerFromData(componentName, data, false);
            this.getNameHelper().popCurrentOwnerNameForCrossProcess(data.getSharedCrossProcessData(), owner);
        }
    }

    protected boolean isCrossProcessSupportRequired() {
        return AppMapService.isCrossProcessSupportRequired() || this.fOwnerType.equals("BusinessTransactionComponent");
    }

    protected IAppMapNameHelper getNameHelper() {
        return this.fNameHelper;
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        String name;
        boolean bl = this.fTracingEnabled = !this.ITracerFactory_isShutoff();
        if (!this.fTracingEnabled) {
            return;
        }
        if (!this.isCrossProcessSupportRequired()) {
            return;
        }
        if (data.isTransactionAborted()) {
            return;
        }
        if (!data.hasServletSupport() && !data.hasFrontBoundary()) {
            HttpServletTracer.setServletSupport((String)this.fEncoding, (IAgent)this.getAgent(), (InvocationData)data);
        }
        data.ensureCrossProcessCache();
        String string = name = this.canUseStaticNameFormatter ? AppMapApplicationNameFormatter.quickGetComponentName(this.getAgent(), this.getModuleFeedback(), data) : super.formatParameterizedName(data);
        if (name == null) {
            name = this.getParameter("applicationName");
        }
        data.setComponentNameAt(name, tracerIndex);
        IAppMapOwner owner = this.getNameHelper().getOwnerFromData(name, data, true);
        SharedCrossProcessData cache = data.getSharedCrossProcessData();
        this.getNameHelper().pushCurrentOwnerNameForCrossProcess(cache, owner);
        AppMapApplicationNameTracer.pushAgentTriplet(this.getAgent(), cache);
    }

    public static void pushAgentTriplet(IAgent agent, SharedCrossProcessData cache) {
        String[] triplet = agent.IAgent_getHostProcessAgentTriplet();
        if (triplet.length == 3) {
            AppMapCrossProcessHelper.setCallingHost(cache, triplet[0]);
            AppMapCrossProcessHelper.setCallingProcess(cache, triplet[1]);
            AppMapCrossProcessHelper.setCallingAgent(cache, triplet[2]);
        }
    }

    protected IAppMapOwner getOwner(InvocationData data) {
        IAppMapOwner owner = this.getOwnerFromInvocationObject(data);
        if (!owner.isNullInstance()) {
            return owner;
        }
        owner = this.getOwnerFromConfiguration();
        if (owner != null && !owner.isNullInstance()) {
            return owner;
        }
        return null;
    }

    protected IAppMapOwner getOwnerFromInvocationObject(InvocationData data) {
        String nameFromData = super.formatParameterizedName(data);
        if (nameFromData != null) {
            IAppMapOwner owner = this.getNameHelper().getOwnerFromData(nameFromData, data, true);
            return owner;
        }
        return this.getNameHelper().getNullOwner();
    }

    protected IAppMapOwner getOwnerFromConfiguration() {
        String applicationName = this.getParameter("applicationName");
        if (applicationName != null) {
            IAppMapOwner owner = this.getNameHelper().getOwnerFromData(applicationName, null, true);
            return owner;
        }
        return this.getNameHelper().getNullOwner();
    }

    protected IAppMapOwner getOwnerFromParent() {
        IAppMapOwner owner = this.getNameHelper().peekCurrentOwnerName();
        return owner;
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return this.fIsShutoff || !AppMapService.hasStarted() || !AppMapService.isAppMapEnabled();
    }

    public void ITracerFactory_addMetricNameFormatListener(IMetricNameFormatListener metricNameFormatListener) {
    }

    public Class getPluginClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.wily.introscope.appmap.agent.trace.hc2.AppMapApplicationNameTracer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public String getName() {
        return this.getPluginClass().getName();
    }

    public void replay_crossProcess(InvocationData data, SharedCrossProcessData cache) {
        String name;
        if (!AppMapService.isRequiresReplayedAtCrossProcessExit()) {
            return;
        }
        String string = name = this.canUseStaticNameFormatter ? AppMapApplicationNameFormatter.quickGetComponentName(this.getAgent(), this.getModuleFeedback(), data) : super.formatParameterizedName(data);
        if (name == null) {
            name = this.getParameter("applicationName");
        }
        IAppMapOwner owner = this.getNameHelper().getOwnerFromData(name, data, true);
        this.getNameHelper().pushCurrentOwnerNameForCrossProcess(data.getSharedCrossProcessData(), owner);
        VirtualStack.TransactionCache cacheTransaction = VirtualStack.getTransactionCache();
        cacheTransaction.fHasAlreadyCheckedAppMapLazyName = true;
    }

    public boolean replay_startTrace(int tracerIndex, InvocationData data, IAppMapStack stack) {
        boolean bl = this.fTracingEnabled = !this.ITracerFactory_isShutoff();
        if (!this.fTracingEnabled) {
            return true;
        }
        IAppMapOwner currentOwner = this.getNameHelper().peekCurrentOwnerName();
        IAppMapOwner owner = this.getOwner(data);
        if (owner != null) {
            if (currentOwner == null || !currentOwner.equals(owner)) {
                data.put(kNewAppMapNameKey, (Object)Boolean.TRUE);
            }
            this.getNameHelper().pushCurrentOwnerName(null, owner);
        }
        return true;
    }

    public boolean replay_finishTrace(int tracerIndex, InvocationData data, IAppMapStack stack) {
        if (!this.fTracingEnabled) {
            return true;
        }
        this.getNameHelper().popCurrentOwnerName(null);
        return true;
    }

    public boolean actsOnStack(IStackType type) {
        if (this.fOwnerType.equals("Application")) {
            return true;
        }
        return type == AppMapService.kStackTypeClassBT || type == AppMapService.kStackTypeClassMethodBT;
    }

    public boolean replay_shutdown(int tracerIndex, InvocationData data, IAppMapStack stack) {
        return this.getNameHelper().reset();
    }

    public boolean isAppMapNameTracer() {
        return true;
    }

    public boolean canCacheInvocationData() {
        return true;
    }

    public boolean canCacheTracerInstances() {
        return false;
    }

    public boolean canCacheComponentNames() {
        return false;
    }

    public String getParam(String key) {
        return null;
    }
}

