/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.AccumulatorAlreadyExistsException;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import com.wily.introscope.spec.server.transactiontrace.KTransactionTraceConstants;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.IntegerConfigurationProperty;
import com.wily.util.properties.hot.LongConfigurationProperty;
import java.util.HashMap;

public final class BTThreadLocalAdministrator {
    private IAgent fAgent;
    private static final Module kModule = new Module("BRTM");
    public static final String kSustainabilityBaseMetricName = "Agent Stats|Sustainability|BRTM Business Transaction";
    private static final String kBRTMURLListSeparator = ",";
    private static volatile boolean fBRTMFeatureOn = false;
    private static volatile boolean fBRTMSnippetInsertionEnabled = true;
    private static String fBRTMSnippetLocation = null;
    private static String fBRTMJSExtensionLocation = null;
    private static boolean fSustainabilityMetricsOn = false;
    public static int fMaxErrorMessageCountPerDurationTime = 20;
    private static int fErrorMessageResetTimeInSeconds = 3600;
    private static int fErrorMessageCounter = 0;
    private static int fBRTMURLMetricLimit = 50;
    private static int fBRTMURLMetricCounter = 0;
    private static boolean fBRTMURLMetricOff = false;
    private static String fBRTMWilyURL = null;
    private static int fBRTMThrottleResponseLimit = 1000;
    private static boolean fBRTMAJAXEnabled = true;
    private static int fBRTMAJAXThreshold = 10;
    private static boolean fBRTMJSFunctionEnabled = false;
    private static int fBRTMJSFunctionThreshold = 10;
    private static boolean fBRTMPageLoadEnabled = true;
    private static int fBRTMPageLoadThreshold = 10;
    private static boolean fBRTMBrowserLogging = false;
    private static boolean fBRTMGeoEnabled = false;
    private static int fBRTMGeoMaxAge = 10000;
    private static int fBRTMGeoTimeout = 5000;
    private static boolean fBRTMGeoHghAccur = false;
    private static int fBRTMMetricFreq = 0;
    private static volatile boolean fBRTMHeadFilterPresenceCheckEnabled = true;
    private static volatile boolean fBRTMTailFilterPresenceCheckEnabled = true;
    private static long fMaxResponseContentLengthForSearching = 8192L;
    private static int fBRTMSearchingMethodHierarchyMaxDepth = 3;
    private static String fBRTMIncludeURLList = null;
    private static String fBRTMExcludeURLList = null;
    private static String[] fBRTMExcludeURLListMap = null;
    private static String[] fBRTMIncludeURLListMap = null;
    private static String fBRTMBrowserIncludeURLList = null;
    private static String fBRTMBrowserExcludeURLList = null;
    private static String fBRTMExcludePattern = null;
    private static String[] fBRTMExcludePatternList = null;
    private static String[] fBRTMBrowserExcludeList = null;
    private static boolean metricsCreated = false;
    public static boolean sJavaScriptConfigReset = true;
    private static int sErrorMessageCounter;
    private IRegisteredBehavior fBRTMResetErrorMessageCounterBehavior;
    private ThreadLocal stackData = new ThreadLocal(){

        public Object initialValue() {
            return new HashMap();
        }
    };

    private BTThreadLocalAdministrator() {
        try {
            this.fAgent = AgentShim.getAgent();
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            return;
        }
        boolean isUsingOldConfig = this.fAgent.IAgent_getComponentTracer().isAgentOldMode();
        if (!isUsingOldConfig) {
            this.initializeProperties();
        }
    }

    public static BTThreadLocalAdministrator getInstance() {
        return BTThreadLocalAdministratorInstance.kInstance;
    }

    public Object get(String key) {
        HashMap dataInstance = (HashMap)this.stackData.get();
        return dataInstance.get(key);
    }

    public void insert(String key, Object value) {
        if (key != null && value != null) {
            HashMap dataInstance = (HashMap)this.stackData.get();
            dataInstance.put(key, value);
        }
    }

    public void remove(String key) {
        if (key != null) {
            HashMap dataInstance = (HashMap)this.stackData.get();
            dataInstance.remove(key);
        }
    }

    public void flush() {
        HashMap dataInstance = (HashMap)this.stackData.get();
        dataInstance.clear();
    }

    public boolean isBRTMEnabled() {
        return fBRTMFeatureOn;
    }

    public boolean isBRTMSustEnabled() {
        return fSustainabilityMetricsOn;
    }

    public boolean isSnippetInsertionEnabled() {
        return fBRTMSnippetInsertionEnabled;
    }

    public String getSnippetLocation() {
        return fBRTMSnippetLocation;
    }

    public String getJSExtensionLocation() {
        return fBRTMJSExtensionLocation;
    }

    public String getIncludeURLPattern() {
        return fBRTMIncludeURLList;
    }

    public String getExcludeURLPattern() {
        return fBRTMExcludeURLList;
    }

    public String[] getIncludeURLList() {
        if (fBRTMIncludeURLListMap != null && fBRTMIncludeURLListMap.length > 0) {
            return fBRTMIncludeURLListMap;
        }
        if (fBRTMIncludeURLList == null) {
            return null;
        }
        if ((fBRTMIncludeURLList = fBRTMIncludeURLList.trim()).indexOf("[") == 0 && fBRTMIncludeURLList.indexOf("]") > 0) {
            fBRTMIncludeURLListMap = fBRTMIncludeURLList.substring(1, fBRTMIncludeURLList.length() - 1).split(kBRTMURLListSeparator);
            int i = 0;
            while (i < fBRTMIncludeURLListMap.length) {
                BTThreadLocalAdministrator.fBRTMIncludeURLListMap[i] = fBRTMIncludeURLListMap[i].trim();
                if (fBRTMIncludeURLListMap[i].indexOf(34) != 0 || fBRTMIncludeURLListMap[i].lastIndexOf(34) <= 0) {
                    this.logDebugMessages("BRTM Include List Property " + "introscope.agent.brtm.includeURLList" + " not in the correct format.  Please follow the correct documentation");
                    return null;
                }
                BTThreadLocalAdministrator.fBRTMIncludeURLListMap[i] = fBRTMIncludeURLListMap[i].substring(1, fBRTMIncludeURLListMap[i].length() - 1);
                ++i;
            }
        } else {
            this.logDebugMessages("BRTM Include List Property " + "introscope.agent.brtm.includeURLList" + " not in the correct format.  Please follow the correct documentation");
            return null;
        }
        return fBRTMIncludeURLListMap;
    }

    public String[] getExcludeURLList() {
        if (fBRTMExcludeURLListMap != null && fBRTMExcludeURLListMap.length > 0) {
            return fBRTMExcludeURLListMap;
        }
        if (fBRTMExcludeURLList == null) {
            return null;
        }
        if ((fBRTMExcludeURLList = fBRTMExcludeURLList.trim()).indexOf("[") == 0 && fBRTMExcludeURLList.indexOf("]") > 0) {
            fBRTMExcludeURLListMap = fBRTMExcludeURLList.substring(1, fBRTMExcludeURLList.length() - 1).split(kBRTMURLListSeparator);
            int i = 0;
            while (i < fBRTMExcludeURLListMap.length) {
                BTThreadLocalAdministrator.fBRTMExcludeURLListMap[i] = fBRTMExcludeURLListMap[i].trim();
                if (fBRTMExcludeURLListMap[i].indexOf(34) != 0 || fBRTMExcludeURLListMap[i].lastIndexOf(34) <= 0) {
                    this.logDebugMessages("BRTM Exlude List Property " + "introscope.agent.brtm.excludeURLList" + " not in the correct format.  Please follow the correct documentation");
                    return null;
                }
                BTThreadLocalAdministrator.fBRTMExcludeURLListMap[i] = fBRTMExcludeURLListMap[i].substring(1, fBRTMExcludeURLListMap[i].length() - 1);
                ++i;
            }
        } else {
            this.logDebugMessages("BRTM Exlude List Property " + "introscope.agent.brtm.excludeURLList" + " not in the correct format.  Please follow the correct documentation");
            return null;
        }
        return fBRTMExcludeURLListMap;
    }

    public String[] getExcludePatternList() {
        if (fBRTMExcludePatternList != null && fBRTMExcludePatternList.length > 0) {
            return fBRTMExcludePatternList;
        }
        if (fBRTMExcludePattern == null) {
            return null;
        }
        fBRTMExcludePatternList = fBRTMExcludePattern.split(kBRTMURLListSeparator);
        return fBRTMExcludePatternList;
    }

    public int getThrottleLimit() {
        return fBRTMThrottleResponseLimit;
    }

    public int getSearchingMethodHierarchyMaxDepth() {
        return fBRTMSearchingMethodHierarchyMaxDepth;
    }

    public boolean isAJAXEnabled() {
        return fBRTMAJAXEnabled;
    }

    public int getAJAXThreshold() {
        return fBRTMAJAXThreshold;
    }

    public boolean isPageLoadEnabled() {
        return fBRTMPageLoadEnabled;
    }

    public int getPageLoadThreshold() {
        return fBRTMPageLoadThreshold;
    }

    public boolean isJSFunctionEnabled() {
        return fBRTMJSFunctionEnabled;
    }

    public int getJSFunctionThreshold() {
        return fBRTMJSFunctionThreshold;
    }

    public long getMaxResponseContentLengthForSearching() {
        return fMaxResponseContentLengthForSearching;
    }

    public boolean isGeoLocationEnabled() {
        return fBRTMGeoEnabled;
    }

    public boolean getGeoHghAccur() {
        return fBRTMGeoHghAccur;
    }

    public int getGeoMaxAge() {
        return fBRTMGeoMaxAge;
    }

    public int getGeoTimeout() {
        return fBRTMGeoTimeout;
    }

    public String getWilyURL() {
        return fBRTMWilyURL;
    }

    public boolean isURLMetricOff() {
        return fBRTMURLMetricOff;
    }

    public int getMetricFreq() {
        return fBRTMMetricFreq;
    }

    public boolean isBrowserLogging() {
        return fBRTMBrowserLogging;
    }

    public boolean shouldCheckForHeadFilterPresence() {
        return fBRTMHeadFilterPresenceCheckEnabled;
    }

    public void setHeadFilterPresenceCheckEnabled(boolean status) {
        fBRTMHeadFilterPresenceCheckEnabled = status;
    }

    public boolean shouldCheckForTailFilterPresence() {
        return fBRTMTailFilterPresenceCheckEnabled;
    }

    public void setTailFilterPresenceCheckEnabled(boolean status) {
        fBRTMTailFilterPresenceCheckEnabled = status;
    }

    public void startMetricsReporting() {
        try {
            if (!metricsCreated && fBRTMFeatureOn) {
                if (fBRTMFeatureOn) {
                    this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:introscope.agent.brtm.enabled").IIntegerCounterDataAccumulator_setValue(1);
                } else {
                    this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:introscope.agent.brtm.enabled").IIntegerCounterDataAccumulator_setValue(0);
                }
                if (fBRTMSnippetInsertionEnabled) {
                    this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:introscope.agent.brtm.snippetInsertionEnabled").IIntegerCounterDataAccumulator_setValue(1);
                } else {
                    this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:introscope.agent.brtm.snippetInsertionEnabled").IIntegerCounterDataAccumulator_setValue(0);
                }
                this.fAgent.IAgent_getDataAccumulatorFactory().createIntegerConstantDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:introscope.agent.brtm.urlMetricLimit", fBRTMURLMetricLimit);
                this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMURLMetricCounter).IIntegerCounterDataAccumulator_setValue(fBRTMURLMetricCounter);
                if (fBRTMURLMetricOff) {
                    this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMURLMetricOff).IIntegerCounterDataAccumulator_setValue(1);
                } else {
                    this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMURLMetricOff).IIntegerCounterDataAccumulator_setValue(0);
                }
                this.fAgent.IAgent_getDataAccumulatorFactory().createIntegerConstantDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMThrottleResponseLimit, fBRTMThrottleResponseLimit);
                if (fBRTMAJAXEnabled) {
                    this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMAJAXEnabled).IIntegerCounterDataAccumulator_setValue(1);
                } else {
                    this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMAJAXEnabled).IIntegerCounterDataAccumulator_setValue(0);
                }
                this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMAJAXThreshold).IIntegerCounterDataAccumulator_setValue(fBRTMAJAXThreshold);
                if (fBRTMJSFunctionEnabled) {
                    this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMJSFunctionEnabled).IIntegerCounterDataAccumulator_setValue(1);
                } else {
                    this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMJSFunctionEnabled).IIntegerCounterDataAccumulator_setValue(0);
                }
                if (fBRTMBrowserLogging) {
                    this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMBrowserLogging).IIntegerCounterDataAccumulator_setValue(1);
                } else {
                    this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMBrowserLogging).IIntegerCounterDataAccumulator_setValue(0);
                }
                if (fBRTMGeoEnabled) {
                    this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMGeoEnabled).IIntegerCounterDataAccumulator_setValue(1);
                } else {
                    this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMGeoEnabled).IIntegerCounterDataAccumulator_setValue(0);
                }
                this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMGeoMaxAge).IIntegerCounterDataAccumulator_setValue(fBRTMGeoMaxAge);
                this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMGeoTimeout).IIntegerCounterDataAccumulator_setValue(fBRTMGeoTimeout);
                if (fBRTMGeoHghAccur) {
                    this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMGeoHghAccur).IIntegerCounterDataAccumulator_setValue(1);
                } else {
                    this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMGeoHghAccur).IIntegerCounterDataAccumulator_setValue(0);
                }
                this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMMetricFreq).IIntegerCounterDataAccumulator_setValue(fBRTMMetricFreq);
                if (fBRTMWilyURL == null || fBRTMWilyURL.trim().length() == 0) {
                    this.fAgent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:introscope.agent.brtm.wilyURL").IStringEveryEventDataAccumulator_addString("Default Agent URL");
                } else {
                    this.fAgent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:introscope.agent.brtm.wilyURL").IStringEveryEventDataAccumulator_addString(fBRTMWilyURL);
                }
                this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMPageLoadThreshold).IIntegerCounterDataAccumulator_setValue(fBRTMPageLoadThreshold);
                this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMJSFunctionThreshold).IIntegerCounterDataAccumulator_setValue(fBRTMJSFunctionThreshold);
                if (fBRTMPageLoadEnabled) {
                    this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMPageLoadEnabled).IIntegerCounterDataAccumulator_setValue(1);
                } else {
                    this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMPageLoadEnabled).IIntegerCounterDataAccumulator_setValue(0);
                }
                metricsCreated = true;
            }
            this.fBRTMResetErrorMessageCounterBehavior = this.fAgent.IAgent_getCommonHeartbeat().addBehavior(new ITimestampedRunnable(){

                public void ITimestampedRunnable_execute(long nowInMillis) {
                    fErrorMessageCounter = 0;
                }
            }, "BRTMBizDefBTLogging", true, (long)fErrorMessageResetTimeInSeconds, false);
        }
        catch (AccumulatorAlreadyExistsException aae) {
            this.logErrorMessages("Accumulator Exists: " + aae.getMessage());
        }
        catch (ConflictingTypesException cte) {
            this.logErrorMessages("Conflicting type exception: " + cte.getMessage());
        }
        catch (BadlyFormedNameException bfne) {
            this.logErrorMessages("Badly formed name: " + bfne.getMessage());
        }
    }

    public int getURLMetricLimit() {
        return fBRTMURLMetricLimit;
    }

    public int getErrorMessageCounter() {
        return fErrorMessageCounter;
    }

    public void incrementErrorMessageCounter() {
        ++fErrorMessageCounter;
    }

    public int getErrorMessageMaxLimit() {
        return fMaxErrorMessageCountPerDurationTime;
    }

    private void initializeProperties() {
        this.resetBRTM();
        fBRTMFeatureOn = this.fAgent.IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.brtm.enabled", false);
        if (fBRTMFeatureOn) {
            this.logInfoMessages("BRTM Feature is enabled");
            fBRTMSnippetInsertionEnabled = this.fAgent.IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.brtm.snippetInsertionEnabled", true);
            fBRTMSnippetLocation = this.fAgent.IAgent_getIndexedProperties().getProperty("introscope.agent.brtm.snippetLocation", null);
            fBRTMJSExtensionLocation = this.fAgent.IAgent_getIndexedProperties().getProperty("introscope.agent.brtm.jsExtensionLocation", null);
            fBRTMURLMetricLimit = this.fAgent.IAgent_getIndexedProperties().getIntProperty("introscope.agent.brtm.urlMetricLimit", 50);
            fBRTMBrowserIncludeURLList = fBRTMIncludeURLList = this.fAgent.IAgent_getIndexedProperties().getProperty("introscope.agent.brtm.includeURLList", null);
            fBRTMExcludeURLList = this.fAgent.IAgent_getIndexedProperties().getProperty("introscope.agent.brtm.excludeURLList", null);
            fBRTMExcludePattern = this.fAgent.IAgent_getIndexedProperties().getProperty("introscope.agent.brtm.excludePatterns", null);
            fBRTMBrowserExcludeURLList = fBRTMExcludeURLList;
            fBRTMURLMetricOff = this.fAgent.IAgent_getIndexedProperties().getBooleanProperty(KTransactionTraceConstants.kBRTMURLMetricOff, false);
            fMaxErrorMessageCountPerDurationTime = this.fAgent.IAgent_getIndexedProperties().getIntProperty("introscope.agent.brtm.errorMessages.max", 20);
            if (fMaxErrorMessageCountPerDurationTime <= 0) {
                fMaxErrorMessageCountPerDurationTime = 20;
            }
            fErrorMessageResetTimeInSeconds = this.fAgent.IAgent_getIndexedProperties().getIntProperty("introscope.agent.external.biz.bt.errormessage.resettime.inseconds", fErrorMessageResetTimeInSeconds);
            fBRTMWilyURL = this.fAgent.IAgent_getIndexedProperties().getProperty("introscope.agent.brtm.wilyURL");
            fBRTMThrottleResponseLimit = this.fAgent.IAgent_getIndexedProperties().getIntProperty(KTransactionTraceConstants.kBRTMThrottleResponseLimit, 1000);
            fBRTMAJAXEnabled = this.fAgent.IAgent_getIndexedProperties().getBooleanProperty(KTransactionTraceConstants.kBRTMAJAXEnabled, true);
            fBRTMAJAXThreshold = this.fAgent.IAgent_getIndexedProperties().getIntProperty(KTransactionTraceConstants.kBRTMAJAXThreshold, 10);
            fBRTMJSFunctionEnabled = this.fAgent.IAgent_getIndexedProperties().getBooleanProperty(KTransactionTraceConstants.kBRTMJSFunctionEnabled, false);
            fBRTMJSFunctionThreshold = this.fAgent.IAgent_getIndexedProperties().getIntProperty(KTransactionTraceConstants.kBRTMJSFunctionThreshold, 10);
            fBRTMPageLoadEnabled = this.fAgent.IAgent_getIndexedProperties().getBooleanProperty(KTransactionTraceConstants.kBRTMPageLoadEnabled, true);
            fBRTMPageLoadThreshold = this.fAgent.IAgent_getIndexedProperties().getIntProperty(KTransactionTraceConstants.kBRTMPageLoadThreshold, 10);
            fBRTMBrowserLogging = this.fAgent.IAgent_getIndexedProperties().getBooleanProperty(KTransactionTraceConstants.kBRTMBrowserLogging, false);
            fBRTMGeoEnabled = this.fAgent.IAgent_getIndexedProperties().getBooleanProperty(KTransactionTraceConstants.kBRTMGeoEnabled, false);
            fBRTMGeoMaxAge = this.fAgent.IAgent_getIndexedProperties().getIntProperty(KTransactionTraceConstants.kBRTMGeoMaxAge, 10000);
            fBRTMGeoTimeout = this.fAgent.IAgent_getIndexedProperties().getIntProperty(KTransactionTraceConstants.kBRTMGeoTimeout, 5000);
            fBRTMGeoHghAccur = this.fAgent.IAgent_getIndexedProperties().getBooleanProperty(KTransactionTraceConstants.kBRTMGeoHghAccur, false);
            fBRTMMetricFreq = this.fAgent.IAgent_getIndexedProperties().getIntProperty(KTransactionTraceConstants.kBRTMMetricFreq, 0);
            fSustainabilityMetricsOn = this.fAgent.IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.brtm.sustainabilityMetrics.enabled", false);
            if (fSustainabilityMetricsOn) {
                this.logDebugMessages("BRTM Sustainability Metrics is enabled");
                this.startMetricsReporting();
            } else {
                this.logDebugMessages("BRTM Sustainability Metrics is disabled");
            }
            fMaxResponseContentLengthForSearching = this.fAgent.IAgent_getIndexedProperties().getLongProperty("introscope.agent.brtm.snippet.maxSearchingLength", 8192L);
            fBRTMSearchingMethodHierarchyMaxDepth = this.fAgent.IAgent_getIndexedProperties().getIntProperty("introscope.agent.brtm.searchingmethodhierarchy.max.depth", 3);
        }
        if (fBRTMFeatureOn) {
            this.fAgent.IAgent_getConfigurationManager().add(new AJAXFeatureOnProperty(this.fAgent), true);
            this.fAgent.IAgent_getConfigurationManager().add(new JSFunctionFeatureOnProperty(this.fAgent), true);
            this.fAgent.IAgent_getConfigurationManager().add(new JSLoggingFeatureOnProperty(this.fAgent), true);
            this.fAgent.IAgent_getConfigurationManager().add(new GeoLocationFeatureOnProperty(this.fAgent), true);
            this.fAgent.IAgent_getConfigurationManager().add(new GeoHghAccurFeatureOnProperty(this.fAgent), true);
            this.fAgent.IAgent_getConfigurationManager().add(new URLMetricOffFeatureOnProperty(this.fAgent), true);
            this.fAgent.IAgent_getConfigurationManager().add(new AJAXThresholdConfigProperty(this.fAgent), true);
            this.fAgent.IAgent_getConfigurationManager().add(new MetricFrequencyConfigProperty(this.fAgent), true);
            this.fAgent.IAgent_getConfigurationManager().add(new GeoMaxAgeConfigProperty(this.fAgent), true);
            this.fAgent.IAgent_getConfigurationManager().add(new GeoTimeoutConfigProperty(this.fAgent), true);
            this.fAgent.IAgent_getConfigurationManager().add(new BRTMWilyURLConfigProperty(this.fAgent), true);
            this.fAgent.IAgent_getConfigurationManager().add(new PageLoadFeatureOnProperty(this.fAgent), true);
            this.fAgent.IAgent_getConfigurationManager().add(new PageLoadThresholdConfigProperty(this.fAgent), true);
            this.fAgent.IAgent_getConfigurationManager().add(new JSFunctionThresholdConfigProperty(this.fAgent), true);
            this.fAgent.IAgent_getConfigurationManager().add(new HeadFilterPresenceCheckProperty(this.fAgent), true);
            this.fAgent.IAgent_getConfigurationManager().add(new TailFilterPresenceCheckProperty(this.fAgent), true);
            this.fAgent.IAgent_getConfigurationManager().add(new MaxResponseContentLengthForSearchingProperty(this.fAgent), true);
            this.fAgent.IAgent_getConfigurationManager().add(new SearchingMethodHierarchyMaxDepthProperty(this.fAgent), true);
        }
    }

    private void resetBRTM() {
    }

    private void logErrorMessages(String message) {
        if (fErrorMessageCounter < fMaxErrorMessageCountPerDurationTime) {
            this.fAgent.IAgent_getModuleFeedback().error(kModule, message);
            ++fErrorMessageCounter;
        } else if (this.fAgent.IAgent_getModuleFeedback().isDebugEnabled()) {
            this.fAgent.IAgent_getModuleFeedback().debug(kModule, message);
        }
    }

    private void logInfoMessages(String message) {
        if (this.fAgent.IAgent_getModuleFeedback().isInfoEnabled(kModule)) {
            this.fAgent.IAgent_getModuleFeedback().info(kModule, message);
        }
    }

    private void logDebugMessages(String message) {
        if (this.fAgent.IAgent_getModuleFeedback().isDebugEnabled(kModule)) {
            this.fAgent.IAgent_getModuleFeedback().debug(kModule, message);
        }
    }

    /* synthetic */ BTThreadLocalAdministrator(BTThreadLocalAdministrator bTThreadLocalAdministrator) {
        this();
    }

    final class AJAXFeatureOnProperty
    extends BooleanConfigurationProperty {
        private AJAXFeatureOnProperty(IAgent agent) {
            super(KTransactionTraceConstants.kBRTMAJAXEnabled, new Boolean(fBRTMAJAXEnabled), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            sJavaScriptConfigReset = true;
            fBRTMAJAXEnabled = (Boolean)newValue;
            if (fSustainabilityMetricsOn) {
                if (fBRTMAJAXEnabled) {
                    BTThreadLocalAdministrator.this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMAJAXEnabled).IIntegerCounterDataAccumulator_setValue(1);
                } else {
                    BTThreadLocalAdministrator.this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMAJAXEnabled).IIntegerCounterDataAccumulator_setValue(0);
                }
            }
            if (fBRTMAJAXEnabled) {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM AJAX Monitoring is enabled");
            } else {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM AJAX Monitoring is disabled");
            }
        }
    }

    final class AJAXThresholdConfigProperty
    extends IntegerConfigurationProperty {
        private AJAXThresholdConfigProperty(IAgent agent) {
            super(KTransactionTraceConstants.kBRTMAJAXThreshold, new Integer(fBRTMAJAXThreshold), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            fBRTMAJAXThreshold = (Integer)newValue;
            if (fBRTMAJAXThreshold >= 0) {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM AJAX Threshold Monitoring is set to " + fBRTMAJAXThreshold);
            } else {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM AJAX Threshold Monitoring cannot be set to a negative value " + fBRTMAJAXThreshold + ", AJAX Threshold will be set to the default value " + KTransactionTraceConstants.kBRTMAJAXThreshold);
                fBRTMAJAXThreshold = 10;
            }
            if (fSustainabilityMetricsOn) {
                fBRTMAJAXThreshold = (Integer)newValue;
                BTThreadLocalAdministrator.this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMAJAXThreshold).IIntegerCounterDataAccumulator_setValue(fBRTMAJAXThreshold);
            }
            sJavaScriptConfigReset = true;
        }
    }

    final class BRTMFeatureOnProperty
    extends BooleanConfigurationProperty {
        private BRTMFeatureOnProperty(IAgent agent) {
            super("introscope.agent.brtm.enabled", new Boolean(fBRTMFeatureOn), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            fBRTMFeatureOn = (Boolean)newValue;
            BTThreadLocalAdministrator.this.resetBRTM();
            if (fBRTMFeatureOn) {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM is enabled");
            } else {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM is disabled");
            }
        }
    }

    final class BRTMJSExcludeURLListFeatureOnProperty
    extends ConfigurationProperty {
        private BRTMJSExcludeURLListFeatureOnProperty(IAgent agent) {
            super("introscope.agent.brtm.excludeURLList", null, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            fBRTMBrowserExcludeURLList = (String)newValue;
            if (fBRTMBrowserExcludeURLList.length() > 0) {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM Browser ExcludeURL List is set to " + fBRTMBrowserExcludeURLList);
            } else {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM Browser ExcludeURL List is not set");
            }
            sJavaScriptConfigReset = true;
        }
    }

    final class BRTMJSIncludeURLListFeatureOnProperty
    extends ConfigurationProperty {
        private BRTMJSIncludeURLListFeatureOnProperty(IAgent agent) {
            super("introscope.agent.brtm.includeURLList", null, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            fBRTMBrowserIncludeURLList = (String)newValue;
            if (fBRTMBrowserIncludeURLList.length() > 0) {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM Browser IncludeURL List is set to " + fBRTMBrowserIncludeURLList);
            } else {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM Browser IncludeURL List is not set");
            }
            sJavaScriptConfigReset = true;
        }
    }

    final class BRTMSnippetInsertionProperty
    extends BooleanConfigurationProperty {
        private BRTMSnippetInsertionProperty(IAgent agent) {
            super("introscope.agent.brtm.snippetInsertionEnabled", new Boolean(fBRTMSnippetInsertionEnabled), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            fBRTMSnippetInsertionEnabled = (Boolean)newValue;
            if (fBRTMSnippetInsertionEnabled) {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM Snippet Insertion is enabled");
            } else {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM Snippet Insertion is disabled");
            }
        }
    }

    final class BRTMSustOnProperty
    extends BooleanConfigurationProperty {
        private BRTMSustOnProperty(IAgent agent) {
            super("introscope.agent.brtm.sustainabilityMetrics.enabled", new Boolean(fSustainabilityMetricsOn), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
        }
    }

    final class BRTMWilyURLConfigProperty
    extends ConfigurationProperty {
        private BRTMWilyURLConfigProperty(IAgent agent) {
            super("introscope.agent.brtm.wilyURL", new String(""), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            sJavaScriptConfigReset = true;
            fBRTMWilyURL = (String)newValue;
            if (fBRTMWilyURL.trim().length() > 0) {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM Wily URL is set to " + fBRTMWilyURL);
            } else {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM Wily URL cannot be set to an empty string " + ", Browser Metrics will be directed to the default agent ");
            }
            if (fSustainabilityMetricsOn) {
                if (fBRTMWilyURL == null || fBRTMWilyURL.trim().length() == 0) {
                    BTThreadLocalAdministrator.this.fAgent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:introscope.agent.brtm.wilyURL").IStringEveryEventDataAccumulator_addString("Default Agent URL");
                } else {
                    BTThreadLocalAdministrator.this.fAgent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:introscope.agent.brtm.wilyURL").IStringEveryEventDataAccumulator_addString(fBRTMWilyURL);
                }
            }
        }
    }

    private static final class BTThreadLocalAdministratorInstance {
        public static final BTThreadLocalAdministrator kInstance = new BTThreadLocalAdministrator(null);

        private BTThreadLocalAdministratorInstance() {
        }
    }

    final class GeoHghAccurFeatureOnProperty
    extends BooleanConfigurationProperty {
        private GeoHghAccurFeatureOnProperty(IAgent agent) {
            super(KTransactionTraceConstants.kBRTMGeoHghAccur, new Boolean(fBRTMGeoHghAccur), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            sJavaScriptConfigReset = true;
            fBRTMGeoHghAccur = (Boolean)newValue;
            if (fSustainabilityMetricsOn && fBRTMGeoHghAccur) {
                BTThreadLocalAdministrator.this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMGeoHghAccur).IIntegerCounterDataAccumulator_setValue(1);
            } else if (fSustainabilityMetricsOn) {
                BTThreadLocalAdministrator.this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMGeoHghAccur).IIntegerCounterDataAccumulator_setValue(0);
            }
            if (fBRTMGeoHghAccur) {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM Geolocation High Accurracy Monitoring is enabled");
            } else {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM Geolocation High Accuracy Monitoring is disabled");
            }
        }
    }

    final class GeoLocationFeatureOnProperty
    extends BooleanConfigurationProperty {
        private GeoLocationFeatureOnProperty(IAgent agent) {
            super(KTransactionTraceConstants.kBRTMGeoEnabled, new Boolean(false), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            sJavaScriptConfigReset = true;
            fBRTMGeoEnabled = (Boolean)newValue;
            if (fSustainabilityMetricsOn && fBRTMGeoEnabled) {
                BTThreadLocalAdministrator.this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMGeoEnabled).IIntegerCounterDataAccumulator_setValue(1);
            } else if (fSustainabilityMetricsOn) {
                BTThreadLocalAdministrator.this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMGeoEnabled).IIntegerCounterDataAccumulator_setValue(0);
            }
            if (fBRTMGeoEnabled) {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM Geolocation Monitoring is enabled");
            } else {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM Geolocation Monitoring is disabled");
            }
        }
    }

    final class GeoMaxAgeConfigProperty
    extends IntegerConfigurationProperty {
        private GeoMaxAgeConfigProperty(IAgent agent) {
            super(KTransactionTraceConstants.kBRTMGeoMaxAge, new Integer(fBRTMGeoMaxAge), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            sJavaScriptConfigReset = true;
            fBRTMGeoMaxAge = (Integer)newValue;
            if (fBRTMGeoMaxAge >= 0) {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM Geo Max Age is set to " + fBRTMGeoMaxAge);
            } else {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM Geo Max Age cannot be set to a negative value " + fBRTMGeoMaxAge + ", Geo Max Age will be set to the default value " + KTransactionTraceConstants.kBRTMGeoMaxAge);
                fBRTMGeoMaxAge = 10000;
            }
            if (fSustainabilityMetricsOn) {
                BTThreadLocalAdministrator.this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMGeoMaxAge).IIntegerCounterDataAccumulator_setValue(fBRTMGeoMaxAge);
            }
        }
    }

    final class GeoTimeoutConfigProperty
    extends IntegerConfigurationProperty {
        private GeoTimeoutConfigProperty(IAgent agent) {
            super(KTransactionTraceConstants.kBRTMGeoTimeout, new Integer(fBRTMGeoTimeout), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            sJavaScriptConfigReset = true;
            fBRTMGeoTimeout = (Integer)newValue;
            if (fBRTMGeoTimeout >= 0) {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM Geo Timeout is set to " + fBRTMGeoTimeout);
            } else {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM Geo Timeout cannot be set to a negative value " + fBRTMGeoTimeout + ", Geo Timeout will be set to the default value " + KTransactionTraceConstants.kBRTMGeoTimeout);
                fBRTMGeoTimeout = 5000;
            }
            if (fSustainabilityMetricsOn) {
                BTThreadLocalAdministrator.this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMGeoTimeout).IIntegerCounterDataAccumulator_setValue(fBRTMGeoTimeout);
            }
        }
    }

    final class HeadFilterPresenceCheckProperty
    extends BooleanConfigurationProperty {
        private HeadFilterPresenceCheckProperty(IAgent agent) {
            super("introscope.agent.brtm.checkHeadFilterPresence.enabled", new Boolean(true), "Enables/Disables head filter presence check for brtm", true, false, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            fBRTMHeadFilterPresenceCheckEnabled = (Boolean)newValue;
            if (fBRTMHeadFilterPresenceCheckEnabled) {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM Head Filter Presence Check is enabled");
            } else {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM Head Filter Presence Check is disabled");
            }
        }
    }

    final class JSFunctionFeatureOnProperty
    extends BooleanConfigurationProperty {
        private JSFunctionFeatureOnProperty(IAgent agent) {
            super("introscope.agent.brtm.jsFunctionMetricsEnabled", new Boolean(fBRTMJSFunctionEnabled), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            sJavaScriptConfigReset = true;
            fBRTMJSFunctionEnabled = (Boolean)newValue;
            if (fSustainabilityMetricsOn && fBRTMJSFunctionEnabled) {
                BTThreadLocalAdministrator.this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMJSFunctionEnabled).IIntegerCounterDataAccumulator_setValue(1);
            } else if (fSustainabilityMetricsOn) {
                BTThreadLocalAdministrator.this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMJSFunctionEnabled).IIntegerCounterDataAccumulator_setValue(0);
            }
            if (fBRTMJSFunctionEnabled) {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM JS Function Monitoring is enabled");
            } else {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM JS Function Monitoring is disabled");
            }
        }
    }

    final class JSFunctionThresholdConfigProperty
    extends IntegerConfigurationProperty {
        private JSFunctionThresholdConfigProperty(IAgent agent) {
            super(KTransactionTraceConstants.kBRTMJSFunctionThreshold, new Integer(fBRTMJSFunctionThreshold), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            sJavaScriptConfigReset = true;
            fBRTMJSFunctionThreshold = (Integer)newValue;
            if (fBRTMJSFunctionThreshold >= 0) {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM JS Function Threshold Monitoring is set to " + fBRTMJSFunctionThreshold);
            } else {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM JS Function Threshold Monitoring cannot be set to a negative value " + fBRTMJSFunctionThreshold + ", JS Function Threshold will be set to the default value " + KTransactionTraceConstants.kBRTMJSFunctionThreshold);
            }
            if (fSustainabilityMetricsOn) {
                BTThreadLocalAdministrator.this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMJSFunctionThreshold).IIntegerCounterDataAccumulator_setValue(fBRTMJSFunctionThreshold);
            }
        }
    }

    final class JSLoggingFeatureOnProperty
    extends BooleanConfigurationProperty {
        private JSLoggingFeatureOnProperty(IAgent agent) {
            super(KTransactionTraceConstants.kBRTMBrowserLogging, new Boolean(fBRTMBrowserLogging), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            sJavaScriptConfigReset = true;
            fBRTMBrowserLogging = (Boolean)newValue;
            if (fSustainabilityMetricsOn && fBRTMBrowserLogging) {
                BTThreadLocalAdministrator.this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMBrowserLogging).IIntegerCounterDataAccumulator_setValue(1);
            } else if (fSustainabilityMetricsOn) {
                BTThreadLocalAdministrator.this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMBrowserLogging).IIntegerCounterDataAccumulator_setValue(0);
            }
            if (fBRTMBrowserLogging) {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM Browser Logging is enabled");
            } else {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM Browser Logging is disabled");
            }
        }
    }

    final class MaxResponseContentLengthForSearchingProperty
    extends LongConfigurationProperty {
        private MaxResponseContentLengthForSearchingProperty(IAgent agent) {
            super("introscope.agent.brtm.snippet.maxSearchingLength", new Long(8192L), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            fMaxResponseContentLengthForSearching = (Long)newValue;
            if (fMaxResponseContentLengthForSearching >= 0L) {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM Max Response Content Length For Searching is set to " + fMaxResponseContentLengthForSearching);
            } else {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM Max Response Content Length For Searching cannot be set to a negative value " + fMaxResponseContentLengthForSearching + ", Max Response Content Length For Searching will be set to the default value " + 8192L);
            }
        }
    }

    final class MetricFrequencyConfigProperty
    extends IntegerConfigurationProperty {
        private MetricFrequencyConfigProperty(IAgent agent) {
            super(KTransactionTraceConstants.kBRTMMetricFreq, new Integer(fBRTMMetricFreq), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            sJavaScriptConfigReset = true;
            fBRTMMetricFreq = (Integer)newValue;
            if (fBRTMMetricFreq >= 0) {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM Browser Metric Frequency is set to " + fBRTMMetricFreq);
            } else {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM Browser Metric Frequency cannot be set to a negative value " + fBRTMMetricFreq + ", Browser Metric Frequency will be set to the default value " + KTransactionTraceConstants.kBRTMMetricFreq);
                fBRTMMetricFreq = 0;
            }
            if (fSustainabilityMetricsOn) {
                BTThreadLocalAdministrator.this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMMetricFreq).IIntegerCounterDataAccumulator_setValue(fBRTMMetricFreq);
            }
        }
    }

    final class PageLoadFeatureOnProperty
    extends BooleanConfigurationProperty {
        private PageLoadFeatureOnProperty(IAgent agent) {
            super(KTransactionTraceConstants.kBRTMPageLoadEnabled, new Boolean(fBRTMPageLoadEnabled), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            sJavaScriptConfigReset = true;
            fBRTMPageLoadEnabled = (Boolean)newValue;
            if (fSustainabilityMetricsOn) {
                if (fBRTMPageLoadEnabled) {
                    BTThreadLocalAdministrator.this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMPageLoadEnabled).IIntegerCounterDataAccumulator_setValue(1);
                } else {
                    BTThreadLocalAdministrator.this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMPageLoadEnabled).IIntegerCounterDataAccumulator_setValue(0);
                }
            }
            if (fBRTMPageLoadEnabled) {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM Page Load Monitoring is enabled");
            } else {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM Page Load Monitoring is disabled");
            }
        }
    }

    final class PageLoadThresholdConfigProperty
    extends IntegerConfigurationProperty {
        private PageLoadThresholdConfigProperty(IAgent agent) {
            super(KTransactionTraceConstants.kBRTMPageLoadThreshold, new Integer(fBRTMPageLoadThreshold), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            sJavaScriptConfigReset = true;
            fBRTMPageLoadThreshold = (Integer)newValue;
            if (fBRTMPageLoadThreshold >= 0) {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM PageLoad Threshold Monitoring is set to " + fBRTMPageLoadThreshold);
            } else {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM PageLoad Threshold Monitoring cannot be set to a negative value " + fBRTMPageLoadThreshold + ", PageLoad Threshold will be set to the default value " + KTransactionTraceConstants.kBRTMPageLoadThreshold);
                fBRTMPageLoadThreshold = 10;
            }
            if (fSustainabilityMetricsOn) {
                BTThreadLocalAdministrator.this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMPageLoadThreshold).IIntegerCounterDataAccumulator_setValue(fBRTMPageLoadThreshold);
            }
        }
    }

    final class SearchingMethodHierarchyMaxDepthProperty
    extends IntegerConfigurationProperty {
        private SearchingMethodHierarchyMaxDepthProperty(IAgent agent) {
            super("introscope.agent.brtm.searchingmethodhierarchy.max.depth", new Integer(3), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            fBRTMSearchingMethodHierarchyMaxDepth = (Integer)newValue;
            if (fBRTMSearchingMethodHierarchyMaxDepth >= 0) {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM SearchingMethodHierarchyMaxDepth is set to " + fBRTMSearchingMethodHierarchyMaxDepth);
            } else {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM SearchingMethodHierarchyMaxDepth cannot be set to a negative value " + fBRTMSearchingMethodHierarchyMaxDepth + ", SearchingMethodHierarchyMaxDepth property will be set to the default value " + 3);
            }
        }
    }

    final class TailFilterPresenceCheckProperty
    extends BooleanConfigurationProperty {
        private TailFilterPresenceCheckProperty(IAgent agent) {
            super("introscope.agent.brtm.checkTailFilterPresence.enabled", new Boolean(true), "Enables/Disables tail filter presence check for brtm", true, false, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            fBRTMTailFilterPresenceCheckEnabled = (Boolean)newValue;
            if (fBRTMTailFilterPresenceCheckEnabled) {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM Tail Filter Presence Check is enabled");
            } else {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM Tail Filter Presence Check is disabled");
            }
        }
    }

    final class URLMetricOffFeatureOnProperty
    extends BooleanConfigurationProperty {
        private URLMetricOffFeatureOnProperty(IAgent agent) {
            super(KTransactionTraceConstants.kBRTMURLMetricOff, new Boolean(fBRTMURLMetricOff), agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            sJavaScriptConfigReset = true;
            fBRTMURLMetricOff = (Boolean)newValue;
            if (fSustainabilityMetricsOn && fBRTMURLMetricOff) {
                BTThreadLocalAdministrator.this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMURLMetricOff).IIntegerCounterDataAccumulator_setValue(1);
            } else if (fSustainabilityMetricsOn) {
                BTThreadLocalAdministrator.this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|BRTM Business Transaction:" + KTransactionTraceConstants.kBRTMURLMetricOff).IIntegerCounterDataAccumulator_setValue(0);
            }
            if (fBRTMURLMetricOff) {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM URL Monitoring is disabled");
            } else {
                BTThreadLocalAdministrator.this.logDebugMessages("BRTM URL Monitoring is enabled");
            }
        }
    }
}

