/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.nio;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.trace.ABundledTracerFactory;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.properties.AttributeListing;

public abstract class ChannelConcurrentInvocationCounter
extends ABundledTracerFactory
implements ITracer {
    private final ReentrancyLevel fReentrancyLevel = this.calculateReentrancyLevel(ReentrancyLevel.kNone);

    public ChannelConcurrentInvocationCounter(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    protected final IIntegerFluctuatingCounterDataAccumulator createDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(formattedMetricName);
    }

    @Override
    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReentrancyLevel;
    }

    @Override
    public final boolean ITracerFactory_isShutoff() {
        return false;
    }

    protected final ITracer allocateTracer(InvocationData data, String formattedName) {
        IIntegerFluctuatingCounterDataAccumulator counter = this.createDataAccumulator(formattedName);
        if (data.storeConcurrentInovocationCounter(counter)) {
            return this;
        }
        return new Counter(counter);
    }

    @Override
    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
        IIntegerFluctuatingCounterDataAccumulator counter = data.retrieveConcurrentInvocationCounter();
        counter.IIntegerFluctuatingCounterDataAccumulator_increment();
    }

    @Override
    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        IIntegerFluctuatingCounterDataAccumulator counter = data.retrieveConcurrentInvocationCounter();
        counter.IIntegerFluctuatingCounterDataAccumulator_decrement();
    }

    @Override
    public final void ITracerFactory_releaseTracer(int tracerIndex, ITracer tracer) {
    }

    private static final class Counter
    implements ITracer {
        private final IIntegerFluctuatingCounterDataAccumulator fAccumulator;

        public Counter(IIntegerFluctuatingCounterDataAccumulator accumulator) {
            this.fAccumulator = accumulator;
        }

        @Override
        public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
            this.fAccumulator.IIntegerFluctuatingCounterDataAccumulator_increment();
        }

        @Override
        public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
            this.fAccumulator.IIntegerFluctuatingCounterDataAccumulator_decrement();
        }
    }
}

