/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.transformer.dynamic;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.transformer.dynamic.IClassRedefinitionDelegate;
import com.wily.introscope.agent.transformer.dynamic.IDeepInheritanceHelper;
import com.wily.util.adt.IAgedMap;
import com.wily.util.classfile.IClassName;

public class ThreadLocalClassHelper {
    private static ThreadLocal threadTransformClass = new ThreadLocal();
    private static ThreadLocal kInstrumentationHandle = new ThreadLocal();
    private static ThreadLocal threadTransformClassloader = new ThreadLocal();
    private static ThreadLocal kDeepInheritanceHelper = new ThreadLocal();

    public static Class getClass(IClassName className) {
        Class localClass = (Class)threadTransformClass.get();
        if (localClass != null && localClass.getName().equals(className.getReflectionFriendlyQualifiedNameString())) {
            return localClass;
        }
        return null;
    }

    public static void setInstrumentedClass(Class c, ClassLoader cl) {
        IAgedMap ch;
        threadTransformClass.set(c);
        threadTransformClassloader.set(cl);
        if (c != null && (ch = ThreadLocalClassHelper.getCache()) != null) {
            ch.addAged(String.valueOf(ThreadLocalClassHelper.getLoaderIdentifier(cl)) + c.getName(), c);
        }
    }

    public static void unsetInstrumentedClass() {
        threadTransformClass.set(null);
        threadTransformClassloader.set(null);
    }

    public static void setInstrumentationHelper(IClassRedefinitionDelegate delegate) {
        kInstrumentationHandle.set(delegate);
    }

    private static IAgedMap getCache() {
        IDeepInheritanceHelper helper = ThreadLocalClassHelper.getDeepInheritanceHelper();
        if (helper != null) {
            return helper.getClassCache();
        }
        return null;
    }

    private static String getLoaderIdentifier(ClassLoader loader) {
        if (loader != null) {
            return String.valueOf(loader.toString()) + ";" + loader.hashCode();
        }
        return "nullLoader";
    }

    public static Class findClass(String className) {
        return ThreadLocalClassHelper.findClass(className, (ClassLoader)threadTransformClassloader.get());
    }

    public static Class findClass(String className, ClassLoader loader) {
        IAgedMap cache = ThreadLocalClassHelper.getCache();
        Object result = null;
        String loaderIdentifier = ThreadLocalClassHelper.getLoaderIdentifier(loader);
        if (cache != null) {
            result = cache.getAged(String.valueOf(loaderIdentifier) + className);
        }
        if (result == null) {
            Object o = kInstrumentationHandle.get();
            if (o != null && o instanceof IClassRedefinitionDelegate) {
                IClassRedefinitionDelegate delegate = (IClassRedefinitionDelegate)o;
                result = delegate.getInstrumentableClass(className, loader);
                if (result != null) {
                    if (cache != null) {
                        cache.addAged(String.valueOf(loaderIdentifier) + className, result);
                    }
                } else if (cache != null) {
                    cache.addAged(String.valueOf(loaderIdentifier) + className, Boolean.FALSE);
                }
            }
        } else if (result instanceof Boolean) {
            return null;
        }
        return (Class)result;
    }

    public static IDeepInheritanceHelper getDeepInheritanceHelper() {
        Object o = kDeepInheritanceHelper.get();
        if (o == null) {
            try {
                o = AgentShim.getAgent().IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer().getDynamicInstrumentationService().getDeepInheritanceHelper();
                kDeepInheritanceHelper.set(o);
            }
            catch (Throwable throwable) {}
        }
        if (o != null) {
            return (IDeepInheritanceHelper)o;
        }
        return null;
    }
}

