/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.metric;

import com.wily.introscope.spec.metric.AgentMetricPrefixParser;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.InternalException;
import com.wily.isengard.data.IIsengardReadResolve;
import com.wily.util.adt.CanonicalObjectPoolWithKey;
import com.wily.util.exception.UnexpectedExceptionError;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;

public final class AgentMetricPrefix
implements Externalizable,
IIsengardReadResolve,
CharSequence {
    public static final AgentMetricPrefix[] kEmptyAgentMetricPrefixArray = new AgentMetricPrefix[0];
    private static final long serialVersionUID = 6039670718848422688L;
    private AgentMetricPrefixParser fPathParser;
    private static CanonicalObjectPoolWithKey sPathCache = new CanonicalObjectPoolWithKey();

    public AgentMetricPrefix() {
    }

    private AgentMetricPrefix(String pathString) throws BadlyFormedNameException {
        this.fPathParser = new AgentMetricPrefixParser(pathString);
    }

    private AgentMetricPrefix(AgentMetricPrefixParser parser) throws BadlyFormedNameException {
        this.fPathParser = parser;
    }

    public boolean isEmpty() {
        return this.fPathParser.isEmpty();
    }

    public String getPathURL() {
        return this.fPathParser.getEntireString();
    }

    public String getSegment(int index) {
        return this.fPathParser.getSegment(index);
    }

    public String getLastSegment() {
        return this.getSegment(this.getSegmentCount() - 1);
    }

    public int getSegmentCount() {
        return this.fPathParser.getSegmentCount();
    }

    public String getPrefixStringIncludingSegmentN(int n) {
        return this.fPathParser.getPrefixIncludingSegmentN(n);
    }

    public String getPrefixStringStartingWithSegmentN(int start) {
        return this.fPathParser.getSubSegment(start);
    }

    public AgentMetricPrefix getPrefixPathIncludingSegmentN(int n) {
        try {
            return AgentMetricPrefix.getAgentMetricPrefix(this.getPrefixStringIncludingSegmentN(n));
        }
        catch (BadlyFormedNameException bfne) {
            throw new InternalException(bfne);
        }
    }

    protected AgentMetricPrefixParser getPathParser() {
        return this.fPathParser;
    }

    public String toString() {
        return this.getPathURL();
    }

    public boolean startsWith(AgentMetricPrefix agentMetricPrefix) {
        boolean match = this.getSegmentCount() >= agentMetricPrefix.getSegmentCount() && this.getPrefixStringIncludingSegmentN(agentMetricPrefix.getSegmentCount() - 1).equals(agentMetricPrefix.getPathURL());
        return match;
    }

    public Object readResolve() throws ObjectStreamException {
        return AgentMetricPrefix.getFromWireData(this.fPathParser);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.fPathParser.smartWriteExternal(out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fPathParser = AgentMetricPrefixParser.smartReadExternalESEPathParser(in);
    }

    static String computeAggregatePathString(AgentMetricPrefix prefixPath, AgentMetricPrefix suffixPath) {
        if (prefixPath.isEmpty()) {
            return suffixPath.getPathURL();
        }
        if (suffixPath.isEmpty()) {
            return prefixPath.getPathURL();
        }
        return String.valueOf(prefixPath.getPathURL()) + "|" + suffixPath.getPathURL();
    }

    static String computeAggregatePathString(AgentMetricPrefix prefixPath, String suffixString) {
        if (prefixPath.isEmpty()) {
            return suffixString;
        }
        if (suffixString == null || suffixString.length() == 0) {
            return prefixPath.getPathURL();
        }
        return String.valueOf(prefixPath.getPathURL()) + "|" + suffixString;
    }

    static String computeAggregatePathString(String prefixString, AgentMetricPrefix suffixPath) {
        if (prefixString == null || prefixString.length() == 0) {
            return suffixPath.getPathURL();
        }
        if (suffixPath.isEmpty()) {
            return prefixString;
        }
        return String.valueOf(prefixString) + "|" + suffixPath.getPathURL();
    }

    private static AgentMetricPrefix getFromWireData(AgentMetricPrefixParser parser) throws InvalidObjectException {
        try {
            return AgentMetricPrefix.getAgentMetricPrefix(parser);
        }
        catch (BadlyFormedNameException badlyFormedNameException) {
            throw new InvalidObjectException("Bad ESEPath name");
        }
    }

    private static AgentMetricPrefix lookupFromCacheNonSync(String pathURL) {
        return (AgentMetricPrefix)sPathCache.getCanonicalObject(pathURL);
    }

    private static AgentMetricPrefix lookupFromCacheNonSync(AgentMetricPrefixParser pathParser) {
        return AgentMetricPrefix.lookupFromCacheNonSync(pathParser.getEntireString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AgentMetricPrefix getFromCache(String pathURL) throws BadlyFormedNameException {
        CanonicalObjectPoolWithKey canonicalObjectPoolWithKey = sPathCache;
        synchronized (canonicalObjectPoolWithKey) {
            AgentMetricPrefix result = AgentMetricPrefix.lookupFromCacheNonSync(pathURL);
            if (result == null) {
                result = AgentMetricPrefix.addToCacheNonSync(pathURL);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static AgentMetricPrefix getFromCache(AgentMetricPrefixParser pathParser) throws BadlyFormedNameException {
        CanonicalObjectPoolWithKey canonicalObjectPoolWithKey = sPathCache;
        synchronized (canonicalObjectPoolWithKey) {
            AgentMetricPrefix result = AgentMetricPrefix.lookupFromCacheNonSync(pathParser);
            if (result == null) {
                result = AgentMetricPrefix.addToCacheNonSync(pathParser);
            }
            return result;
        }
    }

    private static AgentMetricPrefix addToCacheNonSync(String pathURL) throws BadlyFormedNameException {
        return (AgentMetricPrefix)sPathCache.getCanonicalObject(pathURL, new AgentMetricPrefix(pathURL));
    }

    private static AgentMetricPrefix addToCacheNonSync(AgentMetricPrefixParser pathParser) throws BadlyFormedNameException {
        return (AgentMetricPrefix)sPathCache.getCanonicalObject(pathParser.getEntireString(), new AgentMetricPrefix(pathParser));
    }

    public static AgentMetricPrefix getRootAgentMetricPrefix() {
        try {
            return AgentMetricPrefix.getFromCache("");
        }
        catch (BadlyFormedNameException badlyFormedNameException) {
            throw new UnexpectedExceptionError("Unable to get the root agent metric prefix");
        }
    }

    public static AgentMetricPrefix getAgentMetricPrefix(String pathString) throws BadlyFormedNameException {
        return AgentMetricPrefix.getFromCache(pathString);
    }

    public static AgentMetricPrefix getAgentMetricPrefix(String[] stringArray) throws BadlyFormedNameException {
        return AgentMetricPrefix.getAgentMetricPrefix(stringArray, 0, stringArray.length);
    }

    public static AgentMetricPrefix getAgentMetricPrefix(String[] stringArray, int startIndex, int count) throws BadlyFormedNameException {
        AgentMetricPrefixParser parser = new AgentMetricPrefixParser(stringArray, startIndex, count);
        return AgentMetricPrefix.getFromCache(parser);
    }

    public static AgentMetricPrefix getAgentMetricPrefix(AgentMetricPrefix path) {
        return path;
    }

    public static void verifyValidResource(String resourceName) throws BadlyFormedNameException {
        new AgentMetricPrefixParser(resourceName);
    }

    public static AgentMetricPrefix getAgentMetricPrefix(AgentMetricPrefix prefixPath, AgentMetricPrefix suffixPath) throws BadlyFormedNameException {
        AgentMetricPrefixParser parser = new AgentMetricPrefixParser(prefixPath, suffixPath);
        return AgentMetricPrefix.getFromCache(parser);
    }

    public static AgentMetricPrefix getAgentMetricPrefix(AgentMetricPrefix prefixPath, String suffixString) throws BadlyFormedNameException {
        AgentMetricPrefixParser parser = new AgentMetricPrefixParser(prefixPath, suffixString);
        return AgentMetricPrefix.getFromCache(parser);
    }

    private static AgentMetricPrefix getAgentMetricPrefix(AgentMetricPrefixParser parser) throws BadlyFormedNameException {
        return AgentMetricPrefix.getFromCache(parser);
    }

    public char charAt(int index) {
        return this.fPathParser.charAt(index);
    }

    public int length() {
        return this.fPathParser.length();
    }

    public CharSequence subSequence(int start, int end) {
        return this.fPathParser.subSequence(start, end);
    }
}

