/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.stat.gatherer;

import com.wily.introscope.spec.metric.IncompatibleTypesException;
import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.introscope.stat.gatherer.AEveryEventGatherer;
import com.wily.introscope.stat.timeslice.ATimeslicedValue;
import com.wily.introscope.stat.timeslice.StringTimeslicedValue;
import com.wily.wilyassert.Assertion;
import java.util.ArrayList;
import java.util.List;

public class StringEveryEventGatherer
extends AEveryEventGatherer {
    private List fAccumulatedStrings;
    private boolean fClearStringsOnNextInsert;
    public static final int kAccumulatedStringsLimit = 5;

    public StringEveryEventGatherer(int typeCookie, long startTimestamp) {
        super(typeCookie, startTimestamp);
        Assertion.wilyAssert(false);
        this.fAccumulatedStrings = new ArrayList(5);
    }

    public synchronized void addString(String newString) {
        this.clearOnInsert();
        this.fAccumulatedStrings.add(newString);
        this.noteDataIsPresent();
        this.newDataPointsReceived();
    }

    protected ATimeslicedValue[] doHarvestEveryEventArray(long when, BlameStackSnapshot blameStack) {
        ATimeslicedValue[] resultArray;
        if (this.isDataAbsent()) {
            resultArray = new ATimeslicedValue[]{new StringTimeslicedValue(this.getESETypeCookie(), this.getStartTimestampInMillis(), when, blameStack, true)};
        } else if (this.fAccumulatedStrings.size() == 0) {
            resultArray = new ATimeslicedValue[]{new StringTimeslicedValue(this.getESETypeCookie(), this.getStartTimestampInMillis(), when, blameStack, false)};
        } else {
            resultArray = new ATimeslicedValue[this.fAccumulatedStrings.size()];
            int x = 0;
            while (x < this.fAccumulatedStrings.size()) {
                resultArray[x] = new StringTimeslicedValue(this.getESETypeCookie(), this.getStartTimestampInMillis(), when, blameStack, (String)this.fAccumulatedStrings.get(x));
                ++x;
            }
        }
        return resultArray;
    }

    protected void doResetEveryEventGatherer(long when) {
        this.fClearStringsOnNextInsert = true;
    }

    protected void doReinitialize() {
    }

    private void clearOnInsert() {
        if (this.fClearStringsOnNextInsert) {
            this.fClearStringsOnNextInsert = false;
            this.fAccumulatedStrings.clear();
        } else if (this.fAccumulatedStrings.size() >= 5) {
            this.fAccumulatedStrings.remove(0);
        }
    }

    protected void doAcceptAggregateTimeslicedValue(IMetricDataValue value) throws IncompatibleTypesException {
        if (value.getDataPointCount() != 0L) {
            StringTimeslicedValue stringValue = StringTimeslicedValue.checkedCast(value);
            this.addString(stringValue.getString());
        }
    }
}

