/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub.link.http.client;

import com.wily.isengard.postofficehub.link.http.HttpTransportAdapter;
import com.wily.isengard.postofficehub.link.http.client.CommonsHttpTunnelingClient;
import com.wily.isengard.postofficehub.link.http.client.HTTPNotRunningException;
import com.wily.isengard.postofficehub.link.http.client.IHttpTunnelingClient;
import com.wily.isengard.postofficehub.link.http.client.ProxyConfiguration;
import com.wily.isengard.util.thread.AThreadedExecutable;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.io.IOException;
import javax.net.ssl.SSLContext;

public class HttpTunnelingClientLifecycleManager
extends AThreadedExecutable {
    private static final boolean kSetStatsOn = false;
    private static Module sModule = new Module("HttpTunnelingClient");
    private final HttpTransportAdapter fTransportAdapter;
    private final IHttpTunnelingClient fTunnelingClient;
    private final IModuleFeedbackChannel fFeedback;
    private long fTotalNumberOfServerPolls;
    private long fTotalNumberOfExplicitRequests;
    private long fCurrentNumberOfRequestBytes;
    private long fCurrentNumberOfResponseBytes;
    private long fTotalNumberOfExplicitRequestsEndingInAResponse;
    private long fTotalNumberOfServerPollsEndingInAResponse;
    private long fTotalNumberOfExplicitRequestsEndingInNoResponse;
    private long fTotalNumberOfServerPollsEndingInNoResponse;

    public HttpTunnelingClientLifecycleManager(HttpTransportAdapter transportAdapter, IModuleFeedbackChannel feedback) throws HTTPNotRunningException, IOException {
        this.fTransportAdapter = transportAdapter;
        this.fFeedback = feedback;
        String hostName = transportAdapter.getRemoteHostName();
        int port = transportAdapter.getRemotePort();
        int socketSendBufferSize = transportAdapter.getSocketSendBufferSize();
        int socketReceiveBufferSize = transportAdapter.getSocketReceiveBufferSize();
        SSLContext context = transportAdapter.getSSLContext();
        String[] cipherSuites = transportAdapter.getCipherSuites();
        this.fTunnelingClient = new CommonsHttpTunnelingClient(hostName, port, socketSendBufferSize, socketReceiveBufferSize, context, cipherSuites, feedback);
        ProxyConfiguration config = ProxyConfiguration.newInstance(transportAdapter.getSocketProperties(), this.getFeedbackChannel(), sModule);
        if (config != null) {
            try {
                this.getFeedbackChannel().verbose(sModule, "Pinging PROXY server " + config.getHostName() + " at port " + config.getPort());
                config.pingProxy();
            }
            catch (IOException iOException) {
                this.getFeedbackChannel().verbose(sModule, "Proxy server " + config.getHostName() + " cannot be reached");
                this.getFeedbackChannel().verbose(sModule, "Attempting a direction connection to " + hostName);
                config = null;
            }
        }
        if (config == null) {
            this.pingHost(hostName, port);
        }
        this.fTunnelingClient.connect(config);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doTask() {
        HttpTransportAdapter transportAdapter = this.fTransportAdapter;
        IHttpTunnelingClient tunnelingClient = this.fTunnelingClient;
        try {
            try {
                int counter = 0;
                while (this.isExecuting()) {
                    byte[] clientRequest = transportAdapter.retrieveOutgoingHttpPayloadFromTransport();
                    if (clientRequest.length > 0 || counter == 50) {
                        byte[] serverResponse = tunnelingClient.transfer(clientRequest);
                        transportAdapter.postHttpPayloadToTransport(serverResponse);
                        counter = 0;
                    }
                    Thread.sleep(20L);
                    ++counter;
                }
            }
            catch (Throwable e) {
                this.getFeedbackChannel().debug(sModule, "Client will disconnect from server due to error encountered while transfering data: ", e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                tunnelingClient.disconnect();
                this.getFeedbackChannel().debug(sModule, "Disconnecting http tunneling client.");
            }
            catch (Exception exception) {}
            transportAdapter.close();
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        try {}
        catch (Exception exception) {}
        tunnelingClient.disconnect();
        this.getFeedbackChannel().debug(sModule, "Disconnecting http tunneling client.");
        transportAdapter.close();
    }

    /*
     * Exception decompiling
     */
    private void pingHost(String hostName, int remotePort) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [3 : 116->120)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IModuleFeedbackChannel getFeedbackChannel() {
        return this.fFeedback;
    }

    private void updateClientRequestStats(byte[] clientRequest) {
        if (clientRequest.length > 0) {
            this.fCurrentNumberOfRequestBytes += (long)clientRequest.length;
            ++this.fTotalNumberOfExplicitRequests;
        } else {
            ++this.fTotalNumberOfServerPolls;
        }
    }

    private void updateServerResponseStats(byte[] clientRequest, byte[] serverResponse) {
        int requestSize = clientRequest.length;
        int responseSize = serverResponse.length;
        if (requestSize > 0) {
            if (responseSize > 0) {
                ++this.fTotalNumberOfExplicitRequestsEndingInAResponse;
            } else {
                ++this.fTotalNumberOfExplicitRequestsEndingInNoResponse;
            }
        } else if (responseSize > 0) {
            ++this.fTotalNumberOfServerPollsEndingInAResponse;
        } else {
            ++this.fTotalNumberOfServerPollsEndingInNoResponse;
        }
        this.fCurrentNumberOfResponseBytes += (long)responseSize;
    }
}

