/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import com.wily.util.adt.AConcurrentWeakBehaviorThreadLocalHashMap;
import com.wily.util.adt.ConcurrentAgingThreadLocalHashMap;
import com.wily.util.adt.ConcurrentHighPerformanceLRUHashMap;
import com.wily.util.adt.ConcurrentThreadLocalHashMap;
import com.wily.util.adt.ConcurrentWeakIdentityHighPerformanceLRUHashMap;
import com.wily.util.adt.ConcurrentWeakIdentityThreadLocalHashMap;
import com.wily.util.adt.ConcurrentWeakThreadLocalHashMap;
import com.wily.util.adt.DatedValue;
import com.wily.util.adt.IAgedMap;
import com.wily.util.adt.ICappedMap;
import com.wily.util.adt.IConcurrentMapFactory;
import com.wily.util.adt.IConcurrentMapFactory15;
import com.wily.util.adt.IConcurrentMapHealthStatus;
import com.wily.util.adt.IConcurrentMapHealthStatusProvider;
import com.wily.util.adt.IListenerOnAging;
import com.wily.util.adt.IWeakIdentityMap;
import com.wily.util.adt.IWeakMap;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.properties.IndexedProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentMapFactory
implements IConcurrentMapFactory,
IConcurrentMapFactory15,
IConcurrentMapHealthStatusProvider {
    private static HashMap<String, ConcurrentMapPolicy> mapStore = new HashMap();
    private static IndexedProperties fProperties;
    static int sAmcMaxHost;
    static int sAmcMaxPort;

    static {
        sAmcMaxHost = ConcurrentMapFactory.getSystemProperty("wily.SocketFormatterCache.AddressMetricCache.maxHost", 50);
        sAmcMaxPort = ConcurrentMapFactory.getSystemProperty("wily.SocketFormatterCache.AddressMetricCache.maxPort", 50);
    }

    static int getSystemProperty(String propertyName, int propertyDefaultValue) {
        int result = propertyDefaultValue;
        int propertyValue = 0;
        try {
            String propertyValueStr = System.getProperty(propertyName);
            if (propertyValueStr != null) {
                propertyValue = Integer.parseInt(propertyValueStr);
            }
        }
        catch (Exception exception) {}
        if (propertyValue > 0) {
            result = propertyValue;
        }
        return result;
    }

    private void loadPolicies() {
        mapStore.put("EjbBeanClassToInterfaceMap", new ConcurrentMapPolicy("EjbBeanClassToInterfaceMap", ConcurrentMapType.WeakIdentity, true, ThreadLocalOption.NoThreadLocal, 16, 500, 50, 0.75f, 30000, 0));
        mapStore.put("EjbBeanClassToContextMap", new ConcurrentMapPolicy("EjbBeanClassToContextMap", ConcurrentMapType.WeakIdentity, true, ThreadLocalOption.NoThreadLocal, 16, 500, 50, 0.75f, 30000, 0));
        mapStore.put("SocketMapCache", new ConcurrentMapPolicy("SocketMapCache", ConcurrentMapType.Weak, true, ThreadLocalOption.NoThreadLocal, 16, 1000, 11, 0.75f, 30000, 0));
        mapStore.put("StreamMapCache", new ConcurrentMapPolicy("StreamMapCache", ConcurrentMapType.Weak, true, ThreadLocalOption.NoThreadLocal, 16, 1000, 11, 0.75f, 30000, 0));
        mapStore.put("AddressMetricCache", new ConcurrentMapPolicy("AddressMetricCache", ConcurrentMapType.Capped, true, ThreadLocalOption.NoThreadLocal, 16, sAmcMaxHost, 11, 0.75f, 30000, 0));
        mapStore.put("AddressMetricCacheL2", new ConcurrentMapPolicy("AddressMetricCacheL2", ConcurrentMapType.Capped, false, ThreadLocalOption.NoThreadLocal, 16, sAmcMaxPort, 11, 0.75f, 30000, 0));
        mapStore.put("ServerAddressMetricCache", new ConcurrentMapPolicy("ServerAddressMetricCache", ConcurrentMapType.Simple, true, ThreadLocalOption.NoThreadLocal, 16, 1000, 11, 0.75f, 30000, 0));
        mapStore.put("SocketMetricCache", new ConcurrentMapPolicy("SocketMetricCache", ConcurrentMapType.Weak, true, ThreadLocalOption.NoThreadLocal, 16, 1000, 11, 0.75f, 30000, 0));
        mapStore.put("DatagramChannelMapCache", new ConcurrentMapPolicy("DatagramChannelMapCache", ConcurrentMapType.Weak, true, ThreadLocalOption.NoThreadLocal, 16, 11, 11, 0.75f, 30000, 0));
        mapStore.put("ChannelMapCache", new ConcurrentMapPolicy("ChannelMapCache", ConcurrentMapType.Weak, true, ThreadLocalOption.NoThreadLocal, 16, 11, 11, 0.75f, 30000, 0));
        mapStore.put("FeedbackChannelDebugCache", new ConcurrentMapPolicy("FeedbackChannelDebugCache", ConcurrentMapType.Aging, true, ThreadLocalOption.NoThreadLocal, 16, 500, 50, 0.75f, 30000, 30000));
        mapStore.put("FeedbackChannelTraceCache", new ConcurrentMapPolicy("FeedbackChannelDebugCache", ConcurrentMapType.Aging, true, ThreadLocalOption.NoThreadLocal, 16, 500, 50, 0.75f, 30000, 30000));
        mapStore.put("FeedbackChannelVerboseCache", new ConcurrentMapPolicy("FeedbackChannelDebugCache", ConcurrentMapType.Aging, true, ThreadLocalOption.NoThreadLocal, 16, 500, 50, 0.75f, 30000, 30000));
        mapStore.put("FeedbackChannelInfoCache", new ConcurrentMapPolicy("FeedbackChannelDebugCache", ConcurrentMapType.Aging, true, ThreadLocalOption.NoThreadLocal, 16, 500, 50, 0.75f, 30000, 30000));
        mapStore.put("FeedbackChannelWarnCache", new ConcurrentMapPolicy("FeedbackChannelDebugCache", ConcurrentMapType.Aging, true, ThreadLocalOption.NoThreadLocal, 16, 500, 50, 0.75f, 30000, 30000));
        mapStore.put("FeedbackChannelErrorCache", new ConcurrentMapPolicy("FeedbackChannelDebugCache", ConcurrentMapType.Aging, true, ThreadLocalOption.NoThreadLocal, 16, 500, 50, 0.75f, 30000, 30000));
        mapStore.put("ServletContextMapCache", new ConcurrentMapPolicy("ServletContextMapCache", ConcurrentMapType.Simple, true, ThreadLocalOption.NoThreadLocal, 16, 4, 0, 0.75f, 0, 0));
        mapStore.put("ObjectToBlameKeyMap", new ConcurrentMapPolicy("ObjectToBlameKeyMap", ConcurrentMapType.CappedWeakIdentity, true, ThreadLocalOption.NoThreadLocal, 16, 256, 0, 0.75f, 30000, 0));
        mapStore.put("StatementToBlameKeyMap", new ConcurrentMapPolicy("statementToBlameKey", ConcurrentMapType.CappedWeakIdentity, true, ThreadLocalOption.NoThreadLocal, 16, 50, 0, 0.75f, 3000, 0));
        mapStore.put("StatementToSQLMap", new ConcurrentMapPolicy("statementToSql", ConcurrentMapType.CappedWeakIdentity, true, ThreadLocalOption.NoThreadLocal, 16, 50, 0, 0.75f, 3000, 0));
        mapStore.put("rawToNormMap", new ConcurrentMapPolicy("rawToNormalized", ConcurrentMapType.Weak, true, ThreadLocalOption.NoThreadLocal, 16, 50, 0, 0.75f, 30000, 0));
        mapStore.put("connToNameMap", new ConcurrentMapPolicy("connectionToName", ConcurrentMapType.CappedWeakIdentity, true, ThreadLocalOption.NoThreadLocal, 16, 50, 0, 0.75f, 30000, 0));
        mapStore.put("connectionToURL", new ConcurrentMapPolicy("connectionToURL", ConcurrentMapType.CappedWeakIdentity, true, ThreadLocalOption.NoThreadLocal, 16, 300, 0, 0.75f, 1000, 0));
        mapStore.put("urlToFormatString", new ConcurrentMapPolicy("urlToFormatString", ConcurrentMapType.Capped, true, ThreadLocalOption.NoThreadLocal, 16, 500, 0, 0.75f, 30000, 0));
        mapStore.put("sustainabilityMetrics", new ConcurrentMapPolicy("sustainabilityMetrics", ConcurrentMapType.Aging, true, ThreadLocalOption.NoThreadLocal, 16, 128, 50, 0.75f, 60000, 120000));
        mapStore.put("AgentMetricPool", new ConcurrentMapPolicy("AgentMetricPool", ConcurrentMapType.Simple, true, ThreadLocalOption.NoThreadLocal, 16, 5000, 1000, 0.75f, 0, 0));
        mapStore.put("managedSocketInput", new ConcurrentMapPolicy("managedSocketInput", ConcurrentMapType.CappedWeakIdentity, true, ThreadLocalOption.NoThreadLocal, 16, 300, 0, 0.75f, 1000, 0));
        mapStore.put("managedSocketOutput", new ConcurrentMapPolicy("managedSocketOutput", ConcurrentMapType.CappedWeakIdentity, true, ThreadLocalOption.NoThreadLocal, 16, 300, 0, 0.75f, 1000, 0));
        mapStore.put("StalledThreads", new ConcurrentMapPolicy("StalledThreads", ConcurrentMapType.WeakIdentity, true, ThreadLocalOption.NoThreadLocal, 16, 50, 0, 0.75f, 1000, 0));
        mapStore.put("ReportedStalledThreads", new ConcurrentMapPolicy("ReportedStalledThreads", ConcurrentMapType.WeakIdentity, true, ThreadLocalOption.NoThreadLocal, 16, 50, 0, 0.75f, 1000, 0));
        mapStore.put("ReportingStallInvocationData", new ConcurrentMapPolicy("ReportingStallInvocationData", ConcurrentMapType.WeakIdentity, true, ThreadLocalOption.NoThreadLocal, 16, 50, 0, 0.75f, 1000, 0));
        mapStore.put("DeepStack", new ConcurrentMapPolicy("DeepStack", ConcurrentMapType.CappedWeakIdentity, true, ThreadLocalOption.NoThreadLocal, 16, 5000, 0, 0.75f, 1000, 0));
        mapStore.put("ProbeCollectorData", new ConcurrentMapPolicy("ProbeCollectorData", ConcurrentMapType.Capped, true, ThreadLocalOption.NoThreadLocal, 16, 500, 0, 0.75f, 10000, 0));
        mapStore.put("ProbeCollectorMethodCache", new ConcurrentMapPolicy("ProbeCollectorMethodCache", ConcurrentMapType.Capped, true, ThreadLocalOption.NoThreadLocal, 16, 500, 0, 0.75f, 100000, 0));
        mapStore.put("TracedSockets", new ConcurrentMapPolicy("TracedSockets", ConcurrentMapType.Simple, true, ThreadLocalOption.NoThreadLocal, 16, 100, 0, 0.75f, 0, 0));
        mapStore.put("EJBHelpers", new ConcurrentMapPolicy("EJBHelpers", ConcurrentMapType.CappedWeakIdentity, true, ThreadLocalOption.NoThreadLocal, 16, 100, 0, 0.75f, 1000, 0));
        mapStore.put("ServletHelpers", new ConcurrentMapPolicy("ServletHelpers", ConcurrentMapType.CappedWeakIdentity, true, ThreadLocalOption.NoThreadLocal, 16, 100, 0, 0.75f, 1000, 0));
        mapStore.put("ServletObjects", new ConcurrentMapPolicy("ServletObjects", ConcurrentMapType.CappedWeakIdentity, true, ThreadLocalOption.NoThreadLocal, 16, 100, 0, 0.75f, 1000, 0));
        mapStore.put("BrtmInvocationDataObjectToMethod", new ConcurrentMapPolicy("BrtmInvocationDataObjectToMethod", ConcurrentMapType.CappedWeakIdentity, true, ThreadLocalOption.NoThreadLocal, 16, 100, 0, 0.75f, 1000, 0));
        mapStore.put("BrtmClassLoaderHelpers", new ConcurrentMapPolicy("BrtmClassLoaderHelpers", ConcurrentMapType.CappedWeakIdentity, true, ThreadLocalOption.NoThreadLocal, 16, 100, 0, 0.75f, 1000, 0));
    }

    public ConcurrentMapFactory() {
        this.loadPolicies();
        this.createSingletonMaps();
    }

    public ConcurrentMapFactory(IModuleFeedbackChannel feedback, IndexedProperties properties) {
        this.loadPolicies();
        this.setProperties(properties, feedback);
        this.createSingletonMaps();
    }

    private void setProperties(IndexedProperties properties, IModuleFeedbackChannel feedback) {
        fProperties = properties;
        this.updatePolicies(feedback);
    }

    @Override
    public void startConcurrentMapFactory(IModuleFeedbackChannel feedback, IntervalHeartbeat beat) {
        for (Map.Entry<String, ConcurrentMapPolicy> e : mapStore.entrySet()) {
            ConcurrentMapPolicy p = e.getValue();
            if (!p.fIsSingleton) continue;
            this.startStaleCheckingOnConcurrentMap(p, feedback, beat);
        }
    }

    private void createSingletonMaps() {
        for (Map.Entry<String, ConcurrentMapPolicy> e : mapStore.entrySet()) {
            ConcurrentMapPolicy p = e.getValue();
            if (!p.fIsSingleton) continue;
            p.fMap = this.createNewConcurrentMap(p);
            p.fJava14Map = this.createNewJava14MapWrapper(p);
        }
    }

    private Map createNewConcurrentMap(ConcurrentMapPolicy p) {
        if (p.fType == ConcurrentMapType.Aging) {
            return new ConcurrentAgingThreadLocalHashMap(null, null, p.fThreadLocalOption != ThreadLocalOption.NoThreadLocal, p.fInitialSize, p.fInitialThreadLocalSize, p.fLoadFactor, p.fTimeToLive, p.fStaleCheckFrequency, p.fNumConcurrentThreads);
        }
        if (p.fType == ConcurrentMapType.WeakIdentity) {
            return new ConcurrentWeakIdentityThreadLocalHashMap(null, null, p.fThreadLocalOption != ThreadLocalOption.NoThreadLocal, p.fInitialSize, p.fInitialThreadLocalSize, p.fLoadFactor, p.fStaleCheckFrequency, p.fNumConcurrentThreads);
        }
        if (p.fType == ConcurrentMapType.Weak) {
            return new ConcurrentWeakThreadLocalHashMap(null, null, p.fThreadLocalOption != ThreadLocalOption.NoThreadLocal, p.fInitialSize, p.fInitialThreadLocalSize, p.fLoadFactor, p.fStaleCheckFrequency, p.fNumConcurrentThreads);
        }
        if (p.fType == ConcurrentMapType.Capped) {
            return new ConcurrentHighPerformanceLRUHashMap(p.fNumConcurrentThreads, p.fInitialSize);
        }
        if (p.fType == ConcurrentMapType.CappedWeakIdentity) {
            return new ConcurrentWeakIdentityHighPerformanceLRUHashMap(p.fNumConcurrentThreads, p.fInitialSize);
        }
        return new ConcurrentThreadLocalHashMap(null, p.fThreadLocalOption != ThreadLocalOption.NoThreadLocal, p.fThreadLocalOption == ThreadLocalOption.ConsolidatedThreadLocal, p.fInitialSize, p.fInitialThreadLocalSize, p.fLoadFactor, p.fNumConcurrentThreads);
    }

    private void startStaleCheckingOnConcurrentMap(ConcurrentMapPolicy p, IModuleFeedbackChannel feedback, IntervalHeartbeat beat) {
        Map map;
        if (p.fType == ConcurrentMapType.Aging) {
            map = (ConcurrentAgingThreadLocalHashMap)p.fMap;
            ((ConcurrentThreadLocalHashMap)map).setFeedback(feedback);
            ((ConcurrentAgingThreadLocalHashMap)map).startAging(beat, p.fTimeToLive, p.fStaleCheckFrequency);
        }
        if (p.fType == ConcurrentMapType.WeakIdentity) {
            map = (ConcurrentWeakIdentityThreadLocalHashMap)p.fMap;
            ((ConcurrentThreadLocalHashMap)map).setFeedback(feedback);
            ((AConcurrentWeakBehaviorThreadLocalHashMap)map).startStaleCheck(beat, p.fStaleCheckFrequency);
        }
        if (p.fType == ConcurrentMapType.CappedWeakIdentity) {
            map = (ConcurrentWeakIdentityHighPerformanceLRUHashMap)p.fMap;
            ((ConcurrentHighPerformanceLRUHashMap)map).setFeedback(feedback);
            ((ConcurrentWeakIdentityHighPerformanceLRUHashMap)map).startStaleCheck(beat, p.fStaleCheckFrequency);
        }
        if (p.fType == ConcurrentMapType.Weak) {
            map = (ConcurrentWeakThreadLocalHashMap)p.fMap;
            ((ConcurrentThreadLocalHashMap)map).setFeedback(feedback);
            ((AConcurrentWeakBehaviorThreadLocalHashMap)map).startStaleCheck(beat, p.fStaleCheckFrequency);
        }
        if (p.fType == ConcurrentMapType.Simple) {
            ((ConcurrentThreadLocalHashMap)p.fMap).setFeedback(feedback);
        }
        if (p.fType == ConcurrentMapType.Capped) {
            ((ConcurrentHighPerformanceLRUHashMap)p.fMap).setFeedback(feedback);
        }
    }

    private Java14MapWrapper createNewJava14MapWrapper(ConcurrentMapPolicy p) {
        if (p.fType == ConcurrentMapType.Aging) {
            return new Java14AgingMapWrapper((ConcurrentAgingThreadLocalHashMap)p.fMap);
        }
        if (p.fType == ConcurrentMapType.WeakIdentity) {
            return new Java14WeakIdentityMapWrapper((ConcurrentWeakIdentityThreadLocalHashMap)p.fMap);
        }
        if (p.fType == ConcurrentMapType.CappedWeakIdentity) {
            return new Java14CappedWeakIdentityMapWrapper((ConcurrentWeakIdentityHighPerformanceLRUHashMap)p.fMap);
        }
        if (p.fType == ConcurrentMapType.Weak) {
            return new Java14WeakMapWrapper((ConcurrentWeakThreadLocalHashMap)p.fMap);
        }
        if (p.fType == ConcurrentMapType.Capped) {
            return new Java14CappedMapWrapper((ConcurrentHighPerformanceLRUHashMap)p.fMap);
        }
        return new Java14MapWrapper(p.fMap);
    }

    @Override
    public Map getConcurrentMap(String name) {
        ConcurrentMapPolicy p = mapStore.get(name);
        if (p == null) {
            return null;
        }
        if (p.fType != ConcurrentMapType.Simple && p.fType != ConcurrentMapType.Capped) {
            return null;
        }
        if (p.fIsSingleton) {
            return p.fJava14Map;
        }
        return new Java14MapWrapper(this.createNewConcurrentMap(p));
    }

    @Override
    public IAgedMap getConcurrentAgingMap(String name) {
        ConcurrentMapPolicy p = mapStore.get(name);
        if (p == null) {
            return null;
        }
        if (p.fType != ConcurrentMapType.Aging) {
            return null;
        }
        if (p.fIsSingleton) {
            return (Java14AgingMapWrapper)p.fJava14Map;
        }
        return new Java14AgingMapWrapper((ConcurrentAgingThreadLocalHashMap)this.createNewConcurrentMap(p));
    }

    @Override
    public IWeakIdentityMap getConcurrentWeakIdentityMap(String name) {
        ConcurrentMapPolicy p = mapStore.get(name);
        if (p == null) {
            return null;
        }
        if (p.fType != ConcurrentMapType.WeakIdentity) {
            return null;
        }
        if (p.fIsSingleton) {
            return (Java14WeakIdentityMapWrapper)p.fJava14Map;
        }
        return new Java14WeakIdentityMapWrapper((ConcurrentWeakIdentityThreadLocalHashMap)this.createNewConcurrentMap(p));
    }

    @Override
    public IWeakIdentityMap getConcurrentCappedWeakIdentityMap(String name) {
        ConcurrentMapPolicy p = mapStore.get(name);
        if (p == null) {
            return null;
        }
        if (p.fType != ConcurrentMapType.CappedWeakIdentity) {
            return null;
        }
        if (p.fIsSingleton) {
            return (Java14CappedWeakIdentityMapWrapper)p.fJava14Map;
        }
        return new Java14CappedWeakIdentityMapWrapper((ConcurrentWeakIdentityHighPerformanceLRUHashMap)this.createNewConcurrentMap(p));
    }

    @Override
    public Map getConcurrentCappedMap(String name) {
        ConcurrentMapPolicy p = mapStore.get(name);
        if (p == null) {
            return null;
        }
        if (p.fType != ConcurrentMapType.Capped) {
            return null;
        }
        if (p.fIsSingleton) {
            return (Java14CappedMapWrapper)p.fJava14Map;
        }
        return new Java14CappedMapWrapper((ConcurrentHighPerformanceLRUHashMap)this.createNewConcurrentMap(p));
    }

    @Override
    public IWeakMap getConcurrentWeakMap(String name) {
        ConcurrentMapPolicy p = mapStore.get(name);
        if (p == null) {
            return null;
        }
        if (p.fType != ConcurrentMapType.Weak) {
            return null;
        }
        if (p.fIsSingleton) {
            return (Java14WeakMapWrapper)p.fJava14Map;
        }
        return new Java14WeakMapWrapper((ConcurrentWeakThreadLocalHashMap)this.createNewConcurrentMap(p));
    }

    @Override
    public <K, V> ConcurrentThreadLocalHashMap<K, V> getConcurrentHashMap(String name) {
        ConcurrentMapPolicy p = mapStore.get(name);
        if (p == null) {
            return null;
        }
        if (p.fType != ConcurrentMapType.Simple) {
            return null;
        }
        if (p.fIsSingleton) {
            return (ConcurrentThreadLocalHashMap)p.fMap;
        }
        return (ConcurrentThreadLocalHashMap)this.createNewConcurrentMap(p);
    }

    @Override
    public <K, V> ConcurrentAgingThreadLocalHashMap<K, V> getConcurrentAgingHashMap(String name) {
        ConcurrentMapPolicy p = mapStore.get(name);
        if (p == null) {
            return null;
        }
        if (p.fType != ConcurrentMapType.Aging) {
            return null;
        }
        if (p.fIsSingleton) {
            return (ConcurrentAgingThreadLocalHashMap)p.fMap;
        }
        return (ConcurrentAgingThreadLocalHashMap)this.createNewConcurrentMap(p);
    }

    @Override
    public <K, V> ConcurrentWeakIdentityThreadLocalHashMap<K, V> getConcurrentWeakIdentityHashMap(String name) {
        ConcurrentMapPolicy p = mapStore.get(name);
        if (p == null) {
            return null;
        }
        if (p.fType != ConcurrentMapType.WeakIdentity) {
            return null;
        }
        if (p.fIsSingleton) {
            return (ConcurrentWeakIdentityThreadLocalHashMap)p.fMap;
        }
        return (ConcurrentWeakIdentityThreadLocalHashMap)this.createNewConcurrentMap(p);
    }

    @Override
    public <K, V> ConcurrentWeakThreadLocalHashMap<K, V> getConcurrentWeakHashMap(String name) {
        ConcurrentMapPolicy p = mapStore.get(name);
        if (p == null) {
            return null;
        }
        if (p.fType != ConcurrentMapType.Weak) {
            return null;
        }
        if (p.fIsSingleton) {
            return (ConcurrentWeakThreadLocalHashMap)p.fMap;
        }
        return (ConcurrentWeakThreadLocalHashMap)this.createNewConcurrentMap(p);
    }

    @Override
    public <K, V> ConcurrentHighPerformanceLRUHashMap<K, V> getConcurrentCappedHashMap(String name) {
        ConcurrentMapPolicy p = mapStore.get(name);
        if (p == null) {
            return null;
        }
        if (p.fType != ConcurrentMapType.Capped) {
            return null;
        }
        if (p.fIsSingleton) {
            return (ConcurrentHighPerformanceLRUHashMap)p.fMap;
        }
        return (ConcurrentHighPerformanceLRUHashMap)this.createNewConcurrentMap(p);
    }

    private void updatePolicies(IModuleFeedbackChannel feedback) {
        for (Map.Entry<String, ConcurrentMapPolicy> e : mapStore.entrySet()) {
            int safeNewTimeToLive;
            int safeNewStaleCheckFrequency;
            int safeNewThreadLocalInitialSize;
            String mapPolicyName = e.getKey();
            String prefix = "concurrentMapPolicy." + mapPolicyName;
            int safeNewInitialSize = fProperties.getIntProperty(String.valueOf(prefix) + ".initialSize", Integer.MIN_VALUE);
            if (safeNewInitialSize > 0) {
                ConcurrentMapPolicy policy = e.getValue();
                int previousValue = policy.fInitialSize;
                policy.fInitialSize = safeNewInitialSize;
                feedback.info("Chaning value for map policy " + mapPolicyName + " initial size from default of " + previousValue + " to " + safeNewInitialSize);
            }
            if ((safeNewThreadLocalInitialSize = fProperties.getIntProperty(String.valueOf(prefix) + ".initialThreadLocalSize", Integer.MIN_VALUE)) > 0) {
                ConcurrentMapPolicy policy = e.getValue();
                int previousValue = policy.fInitialThreadLocalSize;
                policy.fInitialThreadLocalSize = safeNewThreadLocalInitialSize;
                feedback.info("Chaning value for map policy " + mapPolicyName + " initial thread local size from default of " + previousValue + " to " + safeNewThreadLocalInitialSize);
            }
            if ((safeNewStaleCheckFrequency = fProperties.getIntProperty(String.valueOf(prefix) + ".staleCheckFrequency", Integer.MIN_VALUE)) > 0) {
                ConcurrentMapPolicy policy = e.getValue();
                int previousValue = policy.fStaleCheckFrequency;
                policy.fStaleCheckFrequency = safeNewStaleCheckFrequency;
                feedback.info("Chaning value for map policy " + mapPolicyName + " stale check frequency from default of " + previousValue + " to " + safeNewStaleCheckFrequency);
            }
            if ((safeNewTimeToLive = fProperties.getIntProperty(String.valueOf(prefix) + ".timeToLive", Integer.MIN_VALUE)) <= 0) continue;
            ConcurrentMapPolicy policy = e.getValue();
            int previousValue = policy.fTimeToLive;
            policy.fTimeToLive = safeNewTimeToLive;
            feedback.info("Chaning value for map policy " + mapPolicyName + " time to live from default of " + previousValue + " to " + safeNewTimeToLive);
        }
    }

    @Override
    public IConcurrentMapHealthStatus getConcurrentMapHealthStatus() {
        MyHealthStatus result = new MyHealthStatus();
        for (Map.Entry<String, ConcurrentMapPolicy> e : mapStore.entrySet()) {
            if (e.getValue().fMap == null) continue;
            MyHealthStatusItem item = new MyHealthStatusItem();
            item.fIsWeak = e.getValue().fType == ConcurrentMapType.CappedWeakIdentity || e.getValue().fType == ConcurrentMapType.Weak || e.getValue().fType == ConcurrentMapType.WeakIdentity;
            item.fIsAging = e.getValue().fType == ConcurrentMapType.Aging;
            item.fIsCapped = e.getValue().fType == ConcurrentMapType.Capped || e.getValue().fType == ConcurrentMapType.CappedWeakIdentity;
            item.fMaxCapacity = item.fIsCapped ? e.getValue().fInitialSize : 0;
            item.fStartCapacity = e.getValue().fInitialSize;
            item.fSize = e.getValue().fMap instanceof ConcurrentHighPerformanceLRUHashMap ? ((ConcurrentHighPerformanceLRUHashMap)e.getValue().fMap).deepSize() : e.getValue().fMap.size();
            item.fName = e.getKey();
            result.healthStatusItems.add(item);
            if (!e.getKey().equals("AddressMetricCache")) continue;
            ConcurrentHighPerformanceLRUHashMap map1 = (ConcurrentHighPerformanceLRUHashMap)e.getValue().fMap;
            map1.iterateThrougEntries(new MyOperateOnEntry(result));
        }
        return result;
    }

    public class ConcurrentMapPolicy {
        String fName;
        ConcurrentMapType fType;
        boolean fIsSingleton;
        ThreadLocalOption fThreadLocalOption;
        int fNumConcurrentThreads;
        int fInitialSize;
        int fInitialThreadLocalSize;
        int fStaleCheckFrequency;
        int fTimeToLive;
        float fLoadFactor;
        Map fMap;
        Java14MapWrapper fJava14Map;

        ConcurrentMapPolicy(String name) {
            this(name, ConcurrentMapType.Simple, false, ThreadLocalOption.NoThreadLocal, 8, 64, 8, 0.75f, 3000, 36000000);
        }

        ConcurrentMapPolicy(String name, ConcurrentMapType type, boolean isSingleton, ThreadLocalOption threadLocalOption, int numConcurrentThreads, int initialSize, int initialThreadLocalSize, float loadFactor, int staleCheckFrequency, int timeToLive) {
            this.fName = name;
            this.fType = type;
            this.fIsSingleton = isSingleton;
            this.fThreadLocalOption = threadLocalOption;
            this.fNumConcurrentThreads = numConcurrentThreads;
            this.fInitialSize = initialSize;
            this.fInitialThreadLocalSize = initialThreadLocalSize;
            this.fLoadFactor = loadFactor;
            this.fStaleCheckFrequency = staleCheckFrequency;
            this.fTimeToLive = timeToLive;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ConcurrentMapType {
        Simple,
        Weak,
        WeakIdentity,
        Aging,
        Capped,
        CappedWeakIdentity;

    }

    private class Java14AgingMapWrapper
    extends Java14MapWrapper
    implements IAgedMap {
        final ConcurrentAgingThreadLocalHashMap fAgingMap;

        Java14AgingMapWrapper(ConcurrentAgingThreadLocalHashMap map) {
            super(map);
            if (map == null) {
                throw new IllegalArgumentException("Map can't be null");
            }
            this.fAgingMap = map;
        }

        public Object addAged(Object key, Object value) {
            return this.fAgingMap.putAged(key, value);
        }

        public Object getAged(Object key) {
            DatedValue dv = (DatedValue)this.fAgingMap.get(key);
            if (dv != null) {
                return dv.get();
            }
            return null;
        }

        public void addListenerOnAged(IListenerOnAging listener) {
            this.fAgingMap.addListenerOnAging(listener);
        }

        public void removeListenerOnAged(IListenerOnAging listener) {
            this.fAgingMap.removeListenerOnAging(listener);
        }

        public Object addAgedIfAbsent(Object key, Object value) {
            return this.fAgingMap.putAgedIfAbsent(key, value);
        }
    }

    private class Java14CappedMapWrapper
    extends Java14MapWrapper
    implements ICappedMap {
        final ConcurrentHighPerformanceLRUHashMap fMap;

        Java14CappedMapWrapper(ConcurrentHighPerformanceLRUHashMap map) {
            super(map);
            if (map == null) {
                throw new IllegalArgumentException("Map can't be null");
            }
            this.fMap = map;
        }

        public void setCallback(ICappedMap.IOnEntryRemovedListener callback) {
            this.fMap.setCallback(callback);
        }

        public void iterateThrougEntries(ICappedMap.IOperateOnEntry delegate) {
            this.fMap.iterateThrougEntries(delegate);
        }
    }

    private class Java14CappedWeakIdentityMapWrapper
    extends Java14MapWrapper
    implements IWeakIdentityMap,
    ICappedMap {
        final ConcurrentWeakIdentityHighPerformanceLRUHashMap fWeakIdentityMap;

        Java14CappedWeakIdentityMapWrapper(ConcurrentWeakIdentityHighPerformanceLRUHashMap map) {
            super(map);
            if (map == null) {
                throw new IllegalArgumentException("Map can't be null");
            }
            this.fWeakIdentityMap = map;
        }

        public boolean containsWeakKey(Object key) {
            return this.fWeakIdentityMap.containsWeakKey(key);
        }

        public Object getWeak(Object key) {
            return this.fWeakIdentityMap.getWeak(key);
        }

        public Object putWeak(Object key, Object value) {
            return this.fWeakIdentityMap.putWeak(key, value);
        }

        public int getSize() {
            return this.fWeakIdentityMap.deepSize();
        }

        public void setCallback(ICappedMap.IOnEntryRemovedListener callback) {
            this.fWeakIdentityMap.setCallback(callback);
        }

        public void iterateThrougEntries(ICappedMap.IOperateOnEntry delegate) {
            this.fWeakIdentityMap.iterateThrougEntries(delegate);
        }

        public Object removeWeak(Object key) {
            return this.fWeakIdentityMap.removeWeak(key);
        }
    }

    private class Java14MapWrapper
    implements Map {
        final Map fMap;

        Java14MapWrapper(Map map) {
            this.fMap = map;
        }

        public void clear() {
            this.fMap.clear();
        }

        public boolean containsKey(Object key) {
            return this.fMap.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.fMap.containsValue(value);
        }

        public Set entrySet() {
            return this.fMap.entrySet();
        }

        public Object get(Object key) {
            return this.fMap.get(key);
        }

        public boolean isEmpty() {
            return this.fMap.isEmpty();
        }

        public Set keySet() {
            return this.fMap.keySet();
        }

        public Object put(Object key, Object value) {
            return this.fMap.put(key, value);
        }

        public void putAll(Map m) {
            this.fMap.putAll(m);
        }

        public Object remove(Object key) {
            return this.fMap.remove(key);
        }

        public int size() {
            return this.fMap.size();
        }

        public Collection values() {
            return this.fMap.values();
        }
    }

    private class Java14WeakIdentityMapWrapper
    extends Java14MapWrapper
    implements IWeakIdentityMap {
        final ConcurrentWeakIdentityThreadLocalHashMap fWeakIdentityMap;

        Java14WeakIdentityMapWrapper(ConcurrentWeakIdentityThreadLocalHashMap map) {
            super(map);
            if (map == null) {
                throw new IllegalArgumentException("Map can't be null");
            }
            this.fWeakIdentityMap = map;
        }

        public boolean containsWeakKey(Object key) {
            return this.fWeakIdentityMap.containsWeakKey(key);
        }

        public Object getWeak(Object key) {
            return this.fWeakIdentityMap.getWeak(key);
        }

        public Object putWeak(Object key, Object value) {
            return this.fWeakIdentityMap.putWeak(key, value);
        }

        public Object removeWeak(Object key) {
            return this.fWeakIdentityMap.removeWeak(key);
        }

        public void iterateThrougEntries(ICappedMap.IOperateOnEntry delegate) {
        }

        public int getSize() {
            return this.fWeakIdentityMap.size();
        }
    }

    private class Java14WeakMapWrapper
    extends Java14MapWrapper
    implements IWeakMap {
        final ConcurrentWeakThreadLocalHashMap fWeakMap;

        Java14WeakMapWrapper(ConcurrentWeakThreadLocalHashMap map) {
            super(map);
            if (map == null) {
                throw new IllegalArgumentException("Map can't be null");
            }
            this.fWeakMap = map;
        }

        public boolean containsWeakKey(Object key) {
            return this.fWeakMap.containsWeakKey(key);
        }

        public Object getWeak(Object key) {
            return this.fWeakMap.getWeak(key);
        }

        public Object putWeak(Object key, Object value) {
            return this.fWeakMap.putWeak(key, value);
        }

        public Object removeWeak(Object key) {
            return this.fWeakMap.removeWeak(key);
        }
    }

    private static class MyHealthStatus
    implements IConcurrentMapHealthStatus {
        final ArrayList healthStatusItems = new ArrayList();

        private MyHealthStatus() {
        }

        public Iterator getCurrentHealthStatusItems() {
            return this.healthStatusItems.iterator();
        }
    }

    private static class MyHealthStatusItem
    implements IConcurrentMapHealthStatus.IConcurrentMapHealthStatusItem {
        private String fName;
        private int fStartCapacity;
        private int fMaxCapacity;
        private int fSize;
        private boolean fIsWeak;
        private boolean fIsAging;
        private boolean fIsCapped;

        private MyHealthStatusItem() {
        }

        public String getName() {
            return this.fName;
        }

        public int getStartCapacity() {
            return this.fStartCapacity;
        }

        public int getMaxCapacity() {
            return this.fStartCapacity;
        }

        public int getCurrentSize() {
            return this.fSize;
        }

        public boolean isWeakKey() {
            return this.fIsWeak;
        }

        public boolean isAging() {
            return this.fIsWeak;
        }

        public boolean isCapped() {
            return this.fIsWeak;
        }
    }

    private class MyOperateOnEntry
    implements ICappedMap.IOperateOnEntry {
        private MyHealthStatus result;

        public MyOperateOnEntry(MyHealthStatus r) {
            this.result = r;
        }

        public void doOnEntry(Map.Entry entry1) {
            ConcurrentHighPerformanceLRUHashMap map2 = (ConcurrentHighPerformanceLRUHashMap)entry1.getValue();
            MyHealthStatusItem item = new MyHealthStatusItem();
            item.fIsWeak = false;
            item.fIsAging = false;
            item.fIsCapped = true;
            item.fMaxCapacity = sAmcMaxPort;
            item.fStartCapacity = sAmcMaxPort;
            item.fSize = map2.size();
            item.fName = "AddressMetricCache|Host_" + entry1.getKey();
            this.result.healthStatusItems.add(item);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ThreadLocalOption {
        NoThreadLocal,
        ThreadLocalOnly,
        ConsolidatedThreadLocal;

    }
}

