/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.text;

import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.SimpleLocalizableMessage;
import java.text.NumberFormat;

public class TextUtilities {
    private static final ILocalizableMessage kSpaceLocalizableMessage = new SimpleLocalizableMessage("Space");
    private static final ILocalizableMessage kSentenceTerminatorLocalizableMessage = new SimpleLocalizableMessage("Sentence_Terminator");
    private static final ILocalizableMessage kNewlineLocalizableMessage = new SimpleLocalizableMessage("NewLine");
    private static final NumberFormat kNumberFormatter = NumberFormat.getInstance();

    private TextUtilities() {
    }

    public static ILocalizableMessage getSpaceLocalizableMessage() {
        return kSpaceLocalizableMessage;
    }

    public static ILocalizableMessage getSentenceTerminatorLocalizableMessage() {
        return kSentenceTerminatorLocalizableMessage;
    }

    public static ILocalizableMessage getNewLineLocalizableMessage() {
        return kNewlineLocalizableMessage;
    }

    public static String getFormattedNumber(long number) {
        return kNumberFormatter.format(number);
    }
}

