/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.soa.wm.tn.agent.tracers.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.soa.wm.tn.agent.util.WmCache;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.properties.AttributeListing;
import java.util.concurrent.atomic.AtomicReference;

public class TNFlowServiceBlameTracer
extends ASingleInstanceTracerFactory {
    public static final String kService = "service";
    public static final String kParentResource = "ParentResource";
    private final AtomicReference<IRepository> fRPIRep = new AtomicReference();
    private final AtomicReference<IRepository> fARTRep = new AtomicReference();
    private final AtomicReference<IRepository> fParentRPIRep = new AtomicReference();
    private final AtomicReference<IRepository> fParentARTRep = new AtomicReference();

    public TNFlowServiceBlameTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        try {
            String strFlowServiceNameFound;
            String strFlowServiceName = this.getParameter(kService);
            Object objInvocationObject = data.getInvocationObject();
            if (objInvocationObject != null && strFlowServiceName.equals(strFlowServiceNameFound = objInvocationObject.toString())) {
                IRepository newRpi;
                long startTime = data.getWallClockStartTime();
                long endTime = data.getWallClockFinishTime();
                String componentname = this.formatParameterizedName(data);
                String strRPIMetricname = String.valueOf(componentname) + ":" + "Responses Per Interval";
                AgentMetric rpiMetric = this.getDataAccumulatorFactory().safeGetMetricOfType(strRPIMetricname, 8194, "Invalid Names:Invalid name given for a long interval counter metric");
                IRepository prevRpi = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AgentMetric)rpiMetric, (IRepository)(newRpi = BlamePointTracer.getCountQueuedRepository((boolean)true)));
                if (prevRpi != null) {
                    this.fRPIRep.set(prevRpi);
                } else {
                    this.fRPIRep.set(newRpi);
                }
                this.fRPIRep.get().update(BlamePointTracer.getIncreaser(), 0L, startTime, endTime);
                if (!WmCache.isAsyncServiceExec()) {
                    strRPIMetricname = String.valueOf(this.getParameter(kParentResource)) + ":" + "Responses Per Interval";
                    rpiMetric = this.getDataAccumulatorFactory().safeGetMetricOfType(strRPIMetricname, 8194, "Invalid Names:Invalid name given for a long interval counter metric");
                    prevRpi = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AgentMetric)rpiMetric, (IRepository)(newRpi = BlamePointTracer.getCountQueuedRepository((boolean)true)));
                    if (prevRpi != null) {
                        this.fParentRPIRep.set(prevRpi);
                    } else {
                        this.fParentRPIRep.set(newRpi);
                    }
                    this.fParentRPIRep.get().update(BlamePointTracer.getIncreaser(), 0L, startTime, endTime);
                }
                int responsetime = data.getWallClockElapsedTimeAsInt();
                this.getAgent().IAgent_getModuleFeedback().debug("TNFlowServiceBlameTracer.ITracer_finishTrace()responsetime:" + responsetime);
                String strARTMetricname = String.valueOf(componentname) + ":" + "Average Response Time (ms)";
                AgentMetric artMetric = this.getDataAccumulatorFactory().safeGetMetricOfType(strARTMetricname, 1025, "Invalid Names:Invalid name given for an integer duration metric");
                IRepository newArt = BlamePointTracer.getAverageMetricRepository();
                IRepository prevArt = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AgentMetric)artMetric, (IRepository)newArt);
                if (prevArt != null) {
                    this.fARTRep.set(prevArt);
                } else {
                    this.fARTRep.set(newArt);
                }
                this.fARTRep.get().update(BlamePointTracer.getUpdater(), (long)responsetime, startTime, endTime);
                if (!WmCache.isAsyncServiceExec()) {
                    strARTMetricname = String.valueOf(this.getParameter(kParentResource)) + ":" + "Average Response Time (ms)";
                    artMetric = this.getDataAccumulatorFactory().safeGetMetricOfType(strARTMetricname, 1025, "Invalid Names:Invalid name given for an integer duration metric");
                    prevArt = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AgentMetric)artMetric, (IRepository)(newArt = BlamePointTracer.getAverageMetricRepository()));
                    if (prevArt != null) {
                        this.fParentARTRep.set(prevArt);
                    } else {
                        this.fParentARTRep.set(newArt);
                    }
                    this.fParentARTRep.get().update(BlamePointTracer.getUpdater(), (long)responsetime, startTime, endTime);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            WMUtils.getLogger().error(e.getMessage());
        }
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        try {
            String strFlowServiceName = this.getParameter(kService);
            Object objInvocationObject = data.getInvocationObject();
            if (objInvocationObject != null) {
                String strFlowServiceNameFound = objInvocationObject.toString();
                if (strFlowServiceNameFound.equals("wm.tn:receive")) {
                    WmCache.enableActivityErrorLog(true);
                }
                if (strFlowServiceName.equals(strFlowServiceNameFound)) {
                    WmCache.enableActivityErrorLog(true);
                    data.storeWallClockStartTime();
                }
            }
        }
        catch (Exception e) {
            WMUtils.getLogger().error(e.getMessage());
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

