/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.webservices.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ICacheableBlameKeyNameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.IBlameComponent;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.lang.reflect.Method;

public class WSClientNameFormatter
implements ICacheableBlameKeyNameFormatter {
    public static final String kLoggerKey = "ERROR_IN_NAMEFORMATTER";
    private IAgent fAgent;

    public WSClientNameFormatter(IAgent agent) {
        this.fAgent = agent;
    }

    protected IAgent getAgent() {
        return this.fAgent;
    }

    public String INameFormatter_format(String name, InvocationData data) {
        try {
            String wsname = (String)data.get("com.wily.soaextension.webmethods.webservices.NamespaceKey");
            String operation = (String)data.get("com.wily.soaextension.webmethods.webservices.OperationNameKey");
            if (wsname == null || operation == null) {
                Object idataObj = data.getInvocationParameterAsObject(0);
                Object[] objArr = new Object[]{idataObj, "wsdOperationName"};
                operation = WMUtils.invokeGetStringOnValuesEmulator(objArr);
                objArr[1] = "wsdName";
                String wsdName = WMUtils.invokeGetStringOnValuesEmulator(objArr);
                wsname = this.getWsName(data, operation, wsdName);
            }
            name = this.formatName(wsname, operation, name);
        }
        catch (Exception e) {
            WMUtils.handleError(this.getAgent(), kLoggerKey, e);
            WMUtils.getLogger().debug("Error in Nameformatter:" + e.getMessage());
        }
        return name;
    }

    protected String getWsName(InvocationData data, String operation, String wsdName) throws Exception {
        String wsname = "";
        Object[] objArrCreate = new Object[]{wsdName};
        Object nsObj = WMUtils.invokeCreateOnName(objArrCreate);
        Object[] nsObjArr = new Object[]{nsObj};
        Object wsdObj = WMUtils.invokeGetWSDescOnNamespace(nsObjArr);
        if (wsdObj != null) {
            Method targetNS = WMUtils.getTargetNSonWSD(wsdObj);
            wsname = (String)targetNS.invoke(wsdObj, new Object[0]);
        }
        WMUtils.getLogger().debug("WSClientNameFormatter Client::WebService Namespace:" + wsname);
        WMUtils.getLogger().debug("WSClientNameFormatter Client::WebService Operation:" + operation);
        data.put("com.wily.soaextension.webmethods.webservices.NamespaceKey", (Object)WMUtils.formatToBeResourceSafe(wsname));
        data.put("com.wily.soaextension.webmethods.webservices.OperationNameKey", (Object)operation);
        return wsname;
    }

    protected String formatName(String wsname, String operation, String name) {
        if (name.indexOf("{namespace}", 0) >= 0) {
            if ((wsname = WMUtils.formatToBeResourceSafe(wsname)) == null || wsname.equals("")) {
                wsname = "UnknownService";
            }
            name = StringUtils.replace((String)name, (String)"{namespace}", (String)wsname);
        }
        if (name.indexOf("{operationname}", 0) >= 0) {
            if ((operation = WMUtils.formatToBeResourceSafe(operation)) == null || operation.equals("")) {
                operation = "UnknownOperation";
            }
            name = StringUtils.replace((String)name, (String)"{operationname}", (String)operation);
        }
        return name;
    }

    public Object getObjectKey(IModuleFeedbackChannel imodulefeedbackchannel, int i, InvocationData invocationdata) {
        return null;
    }

    public IBlameComponent getKey(IModuleFeedbackChannel imodulefeedbackchannel, String name, InvocationData data) {
        String wsname = (String)data.get("com.wily.soaextension.webmethods.webservices.NamespaceKey");
        String operation = (String)data.get("com.wily.soaextension.webmethods.webservices.OperationNameKey");
        if (wsname == null || operation == null) {
            try {
                Object idataObj = data.getInvocationParameterAsObject(0);
                Object[] objArr = new Object[]{idataObj, "wsdOperationName"};
                operation = WMUtils.invokeGetStringOnValuesEmulator(objArr);
                objArr[1] = "wsdName";
                String wsdName = WMUtils.invokeGetStringOnValuesEmulator(objArr);
                this.getWsName(data, operation, wsdName);
                data.put("com.wily.soaextension.webmethods.webservices.NamespaceKey", (Object)WMUtils.formatToBeResourceSafe(wsname));
                data.put("com.wily.soaextension.webmethods.webservices.OperationNameKey", (Object)operation);
            }
            catch (Exception e) {
                WMUtils.handleError(this.getAgent(), kLoggerKey, e);
                WMUtils.getLogger().debug("Error in Nameformatter:" + e.getMessage());
            }
        }
        try {
            return ABlameComponent.getArrayInstance((Object[])new Object[]{name, "WebServices", "Client", wsname, operation});
        }
        catch (Exception e) {
            imodulefeedbackchannel.error(e.getMessage());
            return null;
        }
    }
}

