/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.webservices.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.errors.ErrorSnapshotFeatureFactory;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.trace.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.spec.metric.ESEException;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.StringUtils;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class WebServicesClientFaultTracer
extends ASingleMetricTracerFactory {
    protected static final String kLoggerErrorKey = "ERROR_IN_FAULT_TRACER";

    public WebServicesClientFaultTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    protected IDataAccumulator createDataAccumulator(String s) {
        return null;
    }

    public void ITracer_finishTrace(int index, InvocationData data) {
        WMUtils.getLogger().debug("WSClientFaultTracer::finishTrace()");
        try {
            Object idataObj;
            Object[] objArr;
            Object responseMsg;
            String wsname = (String)data.get("ServiceName");
            String operation = (String)data.get("Operation");
            WMUtils.getLogger().debug("WSClientFaultTracer::Got ServiceName as:" + wsname + " & Operation as:" + operation);
            String component = this.getParameter("name");
            if (component.indexOf("{namespace}", 0) >= 0) {
                component = StringUtils.replace((String)component, (String)"{namespace}", (String)wsname);
            }
            if (component.indexOf("{operationname}", 0) >= 0) {
                component = StringUtils.replace((String)component, (String)"{operationname}", (String)operation);
            }
            if (data.hasInvocationThrownException()) {
                try {
                    boolean recordError;
                    Throwable error = data.getInvocationThrownException();
                    String errorMessage = error.getMessage();
                    if (errorMessage != null) {
                        if ((errorMessage = errorMessage.trim()).equals("")) {
                            errorMessage = String.valueOf(component) + "::" + "Error Occured";
                        }
                    } else {
                        errorMessage = String.valueOf(component) + "::" + "Error Occured";
                    }
                    if (recordError = ErrorSnapshotFeatureFactory.flagErrorInManagedApplication((String)errorMessage)) {
                        this.getAgent().IAgent_getComponentTracer().noteBoundaryError();
                    }
                    String name = String.valueOf(component) + ":" + "Errors Per Interval";
                    this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(name).ILongIntervalCounterDataAccumulator_addSingleIncident();
                }
                catch (ESEException eSEException) {
                    Assertion.wilyFail((String)"Metric type conflict");
                }
            }
            if ((responseMsg = WMUtils.invokeGetOnValuesEmulator(objArr = new Object[]{idataObj = data.getInvocationParameterAsObject(0), "soapResponseData"})) != null) {
                Object soapBody = WMUtils.invokeMethodOnObject(responseMsg, "getSOAPBody");
                boolean hasFault = (Boolean)WMUtils.invokeMethodOnObject(soapBody, "hasFault");
                if (hasFault) {
                    Object detailObj;
                    String errorMessage = null;
                    String faulttext = null;
                    Object faultObj = WMUtils.invokeMethodOnObject(soapBody, "getFault");
                    faulttext = (String)WMUtils.invokeMethodOnObject(faultObj, "getFaultString");
                    if (faulttext == null && (detailObj = WMUtils.invokeMethodOnObject(faultObj, "getDetail")) != null) {
                        faulttext = ((String)WMUtils.invokeMethodOnObject(detailObj, "getText")).trim();
                    }
                    errorMessage = faulttext != null ? (!faulttext.equals("") ? "SOAP Fault:" + faulttext : "SOAP Fault:" + component + ":" + "SOAP Fault occured") : "SOAP Fault:" + component + ":" + "SOAP Fault occured";
                    boolean recordFault = ErrorSnapshotFeatureFactory.flagErrorInManagedApplication((String)errorMessage);
                    if (recordFault) {
                        this.getAgent().IAgent_getComponentTracer().noteBoundaryError();
                    }
                    try {
                        String name = String.valueOf(component) + ":" + "SOAP Faults Per Interval";
                        this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(name).ILongIntervalCounterDataAccumulator_addSingleIncident();
                    }
                    catch (ESEException eSEException) {
                        Assertion.wilyFail((String)"Metric type conflict");
                    }
                }
            } else {
                String errorMessage = null;
                Object[] resArr = new Object[]{idataObj, "response"};
                Object response = WMUtils.invokeGetOnValuesEmulator(resArr);
                if (response != null) {
                    Object[] faultArr = new Object[]{response, "fault"};
                    Object fault = WMUtils.invokeGetOnValuesEmulator(faultArr);
                    if (fault != null) {
                        Object[] reasonsArr = new Object[]{fault, "reasons"};
                        Object reasons = WMUtils.invokeGetOnValuesEmulator(reasonsArr);
                        if (reasons != null) {
                            Object[] reasonsArrObj = (Object[])reasons;
                            Object[] bodyArr = new Object[]{reasonsArrObj[0], "*body"};
                            Object body = WMUtils.invokeGetOnValuesEmulator(bodyArr);
                            if (body != null) {
                                errorMessage = body.toString();
                                boolean recordError = ErrorSnapshotFeatureFactory.flagErrorInManagedApplication((String)errorMessage);
                                if (recordError) {
                                    this.getAgent().IAgent_getComponentTracer().noteBoundaryError();
                                }
                                String name = String.valueOf(component) + ":" + "Errors Per Interval";
                                this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(name).ILongIntervalCounterDataAccumulator_addSingleIncident();
                            } else {
                                WMUtils.getLogger().debug("WSClientFaultTracer::Got body as null");
                            }
                        } else {
                            WMUtils.getLogger().debug("WSClientFaultTracer::Got reasons as null");
                        }
                    } else {
                        WMUtils.getLogger().debug("WSClientFaultTracer::Got fault as null");
                    }
                } else {
                    WMUtils.getLogger().debug("WSClientFaultTracer::Got response as null");
                }
            }
        }
        catch (Exception e) {
            WMUtils.handleError(this.getAgent(), kLoggerErrorKey, e);
        }
    }

    public void ITracer_startTrace(int index, InvocationData data) {
        WMUtils.getLogger().debug("WSClientFaultTracer::startTrace()");
        try {
            String wsname = "";
            String operation = "";
            Object idataObj = data.getInvocationParameterAsObject(0);
            Object[] objArr = new Object[]{idataObj, "wsdOperationName"};
            operation = WMUtils.invokeGetStringOnValuesEmulator(objArr);
            objArr[1] = "wsdName";
            String wsdName = WMUtils.invokeGetStringOnValuesEmulator(objArr);
            this.processWsName(data, wsname, operation, wsdName);
        }
        catch (Exception e) {
            WMUtils.handleError(this.getAgent(), kLoggerErrorKey, e);
            WMUtils.getLogger().debug("Error in Fault Tracer:" + e.getMessage());
        }
    }

    protected void processWsName(InvocationData data, String wsname, String operation, String wsdName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Object[] objArrCreate = new Object[]{wsdName};
        Object nsObj = WMUtils.invokeCreateOnName(objArrCreate);
        Object[] nsObjArr = new Object[]{nsObj};
        Object wsdObj = WMUtils.invokeGetWSDescOnNamespace(nsObjArr);
        if (wsdObj != null) {
            Method getTargetNS = WMUtils.getTargetNSonWSD(wsdObj);
            wsname = (String)getTargetNS.invoke(wsdObj, new Object[0]);
        }
        WMUtils.getLogger().debug("WSClientFaultTracer Client::WebService Namespace:" + wsname);
        WMUtils.getLogger().debug("WSClientFaultTracer Client::WebService Operation:" + operation);
        wsname = WMUtils.formatToBeResourceSafe(wsname);
        if (wsname == null || wsname.equals("")) {
            wsname = "UnknownService";
        }
        if ((operation = WMUtils.formatToBeResourceSafe(operation)) == null || operation.equals("")) {
            operation = "UnknownOperation";
        }
        data.put("ServiceName", (Object)wsname);
        data.put("Operation", (Object)operation);
    }
}

