/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.brtm.utilities.common;

import java.io.OutputStream;
import java.io.PrintWriter;

public class HexPrintWriter {
    PrintWriter m_out;
    private static int kiBytesPerLine = 16;
    private static int kiPadding = 4;

    public HexPrintWriter(OutputStream out) {
        this.m_out = new PrintWriter(out, true);
    }

    public HexPrintWriter(PrintWriter out) {
        this.m_out = out;
    }

    private static char charFromHexDigit(int digit) {
        if (digit >= 0 && digit <= 9) {
            return (char)(digit + 48);
        }
        return (char)(digit - 10 + 97);
    }

    private void printLine(byte[] src, int offset, int len) {
        StringBuffer thisLine = new StringBuffer();
        int d = 0;
        while (d < 8) {
            int digitValue = (offset >> 4 * (7 - d)) % 16;
            thisLine.append(HexPrintWriter.charFromHexDigit(digitValue >= 0 ? digitValue : 16 + digitValue));
            ++d;
        }
        thisLine.append("  ");
        int x = 0;
        while (x < len) {
            int by = src[offset + x];
            int i = by >= 0 ? by : 256 + by;
            thisLine.append(HexPrintWriter.charFromHexDigit(i / 16));
            thisLine.append(HexPrintWriter.charFromHexDigit(i % 16));
            thisLine.append(' ');
            ++x;
        }
        x = 0;
        while (x < kiPadding + (kiBytesPerLine - len) * 3) {
            thisLine.append(' ');
            ++x;
        }
        x = 0;
        while (x < len) {
            char v = (char)src[x + offset];
            if (v >= ' ' && v < '\u007f') {
                thisLine.append(v);
            } else {
                thisLine.append('.');
            }
            ++x;
        }
        this.m_out.println(thisLine);
    }

    public void printInner(String caller, byte[] src) {
        this.m_out.print(caller);
        this.m_out.println();
        int count = 0;
        while (count < src.length) {
            this.printLine(src, count, src.length - count > kiBytesPerLine ? kiBytesPerLine : src.length - count);
            count += kiBytesPerLine;
        }
    }

    public void printInner(String caller, String src) {
        byte[] temp = src.getBytes();
        this.printInner(caller, temp);
    }

    public void writeInner(String caller, String s) {
        byte[] temp = s.getBytes();
        this.printInner(caller, temp);
    }

    public void write(char[] buf) {
        String temp = new String(buf);
        this.writeInner("write(char[] buf)", temp);
    }

    public void write(char[] buf, int off, int len) {
        String temp = new String(buf, off, len);
        this.writeInner("write(char[] buf, int off, int len)", temp);
    }

    public void write(byte[] buf, int off, int len) {
        byte[] temp = new byte[len];
        int i = 0;
        while (i < len) {
            temp[i] = buf[i + off];
            ++i;
        }
        this.printInner("write(byte[] buf, int off, int len)", temp);
    }

    public void write(int c) {
        String temp = String.valueOf(c);
        this.writeInner("write(int c)", temp);
    }

    public void write(String s) {
        byte[] temp = s.getBytes();
        this.printInner("write(String s)", temp);
    }

    public void write(String s, int off, int len) {
        String temp = s.substring(off, off + len);
        this.writeInner("write(String s, int off, int len)", temp);
    }

    public void print(String src) {
        byte[] temp = src.getBytes();
        this.printInner("print(String src)", temp);
    }

    public void print(boolean src) {
        String temp = String.valueOf(src);
        this.printInner("print(boolean src)", temp);
    }

    public void print(char src) {
        String temp = String.valueOf(src);
        this.printInner("print(char src)", temp);
    }

    public void print(int src) {
        String temp = String.valueOf(src);
        this.printInner("print(int src)", temp);
    }

    public void print(long src) {
        String temp = String.valueOf(src);
        this.printInner("print(long src)", temp);
    }

    public void print(float src) {
        String temp = String.valueOf(src);
        this.printInner("print(float src)", temp);
    }

    public void print(double src) {
        String temp = String.valueOf(src);
        this.printInner("print(double src)", temp);
    }

    public void print(char[] src) {
        String temp = new String(src);
        this.printInner("print(char[] src)", temp);
    }

    public void print(byte[] src) {
        String temp = new String(src);
        this.printInner("print(byte[] src)", temp);
    }

    public void print(Object src) {
        String temp = String.valueOf(src);
        this.printInner("print(Object src)", temp);
    }

    public void println() {
        this.printInner("println(String src)", "\n");
    }

    public void println(String src) {
        String temp = src.concat("\n");
        this.printInner("println(String src)", temp);
    }

    public void println(boolean src) {
        String temp = String.valueOf(String.valueOf(src)) + "\n";
        this.printInner("println(boolean src)", temp);
    }

    public void println(char src) {
        String temp = String.valueOf(String.valueOf(src)) + "\n";
        this.printInner("println(char src)", temp);
    }

    public void println(int src) {
        String temp = String.valueOf(String.valueOf(src)) + "\n";
        this.printInner("println(int src)", temp);
    }

    public void println(long src) {
        String temp = String.valueOf(String.valueOf(src)) + "\n";
        this.printInner("println(long src)", temp);
    }

    public void println(float src) {
        String temp = String.valueOf(String.valueOf(src)) + "\n";
        this.printInner("println(float src)", temp);
    }

    public void println(double src) {
        String temp = String.valueOf(String.valueOf(src)) + "\n";
        this.printInner("println(double src)", temp);
    }

    public void println(char[] src) {
        StringBuffer temp = new StringBuffer(src.length + 1);
        temp.append(src);
        temp.append("\n");
        this.printInner("println(char[] src)", temp.toString());
    }

    public void println(Object src) {
        String temp = String.valueOf(String.valueOf(src)) + "\n";
        this.printInner("println(Object src)", temp);
    }
}

