/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.brtm.utilities.common;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class IPGroupRule {
    private IPGroupRuleUnit[] ruleUnits = new IPGroupRuleUnit[0];

    public IPGroupRule(String ruleDefinition) throws UnknownHostException {
        StringTokenizer strtok = new StringTokenizer(ruleDefinition, " ,\t", false);
        ArrayList<IPGroupRuleUnit> rules = new ArrayList<IPGroupRuleUnit>(strtok.countTokens());
        while (strtok.hasMoreTokens()) {
            String nextTok = strtok.nextToken();
            rules.add(IPGroupRuleUnit.parseRuleUnit(nextTok));
        }
        this.ruleUnits = rules.toArray(this.ruleUnits);
    }

    public boolean contains(InetAddress address) {
        int i = 0;
        while (i < this.ruleUnits.length) {
            if (this.ruleUnits[i].contains(address)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.ruleUnits.length) {
            result.append(this.ruleUnits[i].toString());
            ++i;
        }
        return result.toString();
    }

    public static class IPGroupRuleUnit {
        byte[] m_lowerBound;
        byte[] m_upperBound;
        private static final String kst_filler = "0.0.0.0.0";

        IPGroupRuleUnit(byte[] lowerBound, byte[] upperBound) {
            this.m_lowerBound = lowerBound;
            this.m_upperBound = upperBound;
        }

        IPGroupRuleUnit(InetAddress improperInterval) {
            this.m_lowerBound = improperInterval.getAddress();
            this.m_upperBound = null;
        }

        public static String byteArrayToString(byte[] array) {
            StringBuffer result = new StringBuffer("IP Group Rule: ");
            int i = 0;
            while (i < array.length) {
                if (i > 0) {
                    result.append('.');
                }
                result.append(Integer.toString(IPGroupRuleUnit.unsignedByteToInt(array[i])));
                ++i;
            }
            return result.toString();
        }

        public static String addMissingOctets(String ipString) {
            StringTokenizer strTok = new StringTokenizer(ipString, ".", true);
            StringBuffer result = new StringBuffer(ipString);
            int numTokens = 0;
            while (strTok.hasMoreTokens()) {
                strTok.nextToken();
                ++numTokens;
            }
            result.append(kst_filler.substring(numTokens + 2));
            return result.toString();
        }

        private static IPGroupRuleUnit parseRuleUnit(String source) throws UnknownHostException {
            try {
                int dashIndex = source.indexOf(45);
                if (dashIndex > 0) {
                    String startAddress = source.substring(0, dashIndex);
                    String endAddress = source.substring(dashIndex + 1);
                    InetAddress startInet = InetAddress.getByName(startAddress);
                    InetAddress endInet = InetAddress.getByName(endAddress);
                    byte[] startAddr = startInet.getAddress();
                    byte[] endAddr = endInet.getAddress();
                    return new IPGroupRuleUnit(startAddr, endAddr);
                }
                int slashIndex = source.indexOf(47);
                if (slashIndex > 0) {
                    byte[] mask;
                    String inetString0 = source.substring(0, slashIndex);
                    String inetString = IPGroupRuleUnit.addMissingOctets(inetString0);
                    String maskString = source.substring(slashIndex + 1);
                    InetAddress startInet = InetAddress.getByName(inetString);
                    byte[] startAddr = startInet.getAddress();
                    if (maskString.indexOf(46) > 0) {
                        InetAddress maskInet = InetAddress.getByName(maskString);
                        mask = maskInet.getAddress();
                    } else {
                        int maskPos = Integer.parseInt(maskString);
                        mask = IPGroupRuleUnit.generateSimpleMask(startAddr.length, maskPos);
                    }
                    startAddr = IPGroupRuleUnit.applyMask(startAddr, mask);
                    byte[] endAddr = IPGroupRuleUnit.applyMaxMask(startAddr, mask);
                    return new IPGroupRuleUnit(startAddr, endAddr);
                }
                InetAddress addr = InetAddress.getByName(source);
                return new IPGroupRuleUnit(addr);
            }
            catch (UnknownHostException unknownHostException) {
                throw new UnknownHostException(source);
            }
        }

        boolean contains(InetAddress target) {
            byte[] targetBytes = target.getAddress();
            if (this.m_upperBound == null) {
                return IPGroupRuleUnit.byteArrayCompare(this.m_lowerBound, targetBytes) == 0;
            }
            if (IPGroupRuleUnit.byteArrayCompare(targetBytes, this.m_lowerBound) < 0) {
                return false;
            }
            return IPGroupRuleUnit.byteArrayCompare(targetBytes, this.m_upperBound) <= 0;
        }

        private static int unsignedByteToInt(byte b) {
            return b & 0xFF;
        }

        private static int byteArrayCompare(byte[] a1, byte[] a2) {
            if (a1.length != a2.length) {
                throw new IllegalArgumentException("Byte arrays must be of same length");
            }
            int i = 0;
            while (i < a1.length) {
                int a2i;
                int a1i = IPGroupRuleUnit.unsignedByteToInt(a1[i]);
                if (a1i > (a2i = IPGroupRuleUnit.unsignedByteToInt(a2[i]))) {
                    return 1;
                }
                if (a1i < a2i) {
                    return -1;
                }
                ++i;
            }
            return 0;
        }

        private static byte[] applyMask(byte[] source, byte[] mask) {
            if (source.length != mask.length) {
                throw new IllegalArgumentException("Mask must be the same size as source");
            }
            byte[] result = new byte[source.length];
            int i = 0;
            while (i < source.length) {
                result[i] = (byte)(source[i] & mask[i]);
                ++i;
            }
            return result;
        }

        private static byte[] applyMaxMask(byte[] source, byte[] mask) {
            if (source.length != mask.length) {
                throw new IllegalArgumentException("Mask must be the same size as source");
            }
            byte[] result = new byte[source.length];
            int i = 0;
            while (i < source.length) {
                result[i] = (byte)(source[i] | ~mask[i]);
                ++i;
            }
            return result;
        }

        public static byte[] generateSimpleMask(int maskLen, int maskPos) {
            byte[] mask = new byte[maskLen];
            int i = 0;
            while (i < maskLen) {
                if (maskPos >= 8) {
                    mask[i] = -1;
                    maskPos -= 8;
                } else if (maskPos <= 0) {
                    mask[i] = 0;
                } else {
                    mask[i] = (byte)(-1 << 8 - maskPos);
                    maskPos = 0;
                }
                ++i;
            }
            return mask;
        }

        public String byteArrayToString2(byte[] source) {
            StringBuffer result = new StringBuffer();
            int i = 0;
            while (i < source.length) {
                int temp;
                if (i > 0) {
                    result.append('.');
                }
                if (source[i] >= 0) {
                    temp = source[i];
                } else {
                    temp = ~source[i];
                    temp = 255 - temp;
                }
                result.append(temp);
                ++i;
            }
            return result.toString();
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            result.append("Rule Unit: Lower bound: ");
            result.append(IPGroupRuleUnit.byteArrayToString(this.m_lowerBound));
            result.append(" Upper bound: ");
            result.append(IPGroupRuleUnit.byteArrayToString(this.m_upperBound));
            return result.toString();
        }
    }
}

