/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.brtm.utilities.common;

import com.wily.introscope.agent.brtm.utilities.common.IPGroupRule;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.ListIterator;

public class IPGroupRuleContainer {
    private static IPGroupRuleContainer singleton = new IPGroupRuleContainer();
    private LinkedList m_list = new LinkedList();

    public static IPGroupRuleContainer getInstance() {
        return singleton;
    }

    public void add(String name, String ruleString) throws UnknownHostException {
        IPGroupRule rule = new IPGroupRule(ruleString);
        this.m_list.add(new Pair(name, rule));
    }

    public void clear() {
        this.m_list.clear();
    }

    public int size() {
        return this.m_list.size();
    }

    public String matchFirstRule(InetAddress addr) {
        ListIterator iter = this.m_list.listIterator();
        while (iter.hasNext()) {
            Pair traverse = (Pair)iter.next();
            IPGroupRule rule = traverse.m_rule;
            if (!rule.contains(addr)) continue;
            return traverse.m_name;
        }
        return null;
    }

    private static class Pair {
        String m_name;
        IPGroupRule m_rule;

        private Pair(String name, IPGroupRule rule) {
            this.m_name = name;
            this.m_rule = rule;
        }
    }
}

