/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.brtm.utilities.common;

import com.wily.introscope.agent.brtm.utilities.common.URLComponents;
import com.wily.introscope.agent.brtm.utilities.common.URLGroupRule;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.ListIterator;

public class URLGroupRuleContainer {
    private static URLGroupRuleContainer singleton = new URLGroupRuleContainer();
    private LinkedList m_list = new LinkedList();

    public static URLGroupRuleContainer getInstance() {
        return singleton;
    }

    public void add(String prefix, String formatString) throws UnsupportedEncodingException {
        this.m_list.add(new URLGroupRule(prefix, formatString));
    }

    public void clear() {
        this.m_list.clear();
    }

    public int size() {
        return this.m_list.size();
    }

    public String matchFirstRule(URLComponents urlComponents) {
        ListIterator iter = this.m_list.listIterator();
        while (iter.hasNext()) {
            URLGroupRule traverse = (URLGroupRule)iter.next();
            if (!traverse.isMatch(urlComponents)) continue;
            return traverse.format(urlComponents);
        }
        return null;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("URLGroupRuleContainer(");
        int i = 0;
        ListIterator iter = this.m_list.listIterator();
        while (iter.hasNext()) {
            result.append('[');
            result.append(Integer.toString(i));
            result.append(']');
            result.append((URLGroupRule)iter.next());
            result.append(' ');
            ++i;
        }
        return result.toString();
    }
}

